/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.log;

import java.util.List;
import java.util.function.Predicate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.NoOpLog;

final class CompositeLog
implements Log {
    private static final Log NO_OP_LOG = new NoOpLog();
    private final Log fatalLogger;
    private final Log errorLogger;
    private final Log warnLogger;
    private final Log infoLogger;
    private final Log debugLogger;
    private final Log traceLogger;

    public CompositeLog(List<Log> list) {
        this.fatalLogger = CompositeLog.initLogger(list, Log::isFatalEnabled);
        this.errorLogger = CompositeLog.initLogger(list, Log::isErrorEnabled);
        this.warnLogger = CompositeLog.initLogger(list, Log::isWarnEnabled);
        this.infoLogger = CompositeLog.initLogger(list, Log::isInfoEnabled);
        this.debugLogger = CompositeLog.initLogger(list, Log::isDebugEnabled);
        this.traceLogger = CompositeLog.initLogger(list, Log::isTraceEnabled);
    }

    private static Log initLogger(List<Log> list, Predicate<Log> predicate) {
        for (Log log : list) {
            if (!predicate.test(log)) continue;
            return log;
        }
        return NO_OP_LOG;
    }

    @Override
    public boolean isFatalEnabled() {
        return this.fatalLogger != NO_OP_LOG;
    }

    @Override
    public boolean isErrorEnabled() {
        return this.errorLogger != NO_OP_LOG;
    }

    @Override
    public boolean isWarnEnabled() {
        return this.warnLogger != NO_OP_LOG;
    }

    @Override
    public boolean isInfoEnabled() {
        return this.infoLogger != NO_OP_LOG;
    }

    @Override
    public boolean isDebugEnabled() {
        return this.debugLogger != NO_OP_LOG;
    }

    @Override
    public boolean isTraceEnabled() {
        return this.traceLogger != NO_OP_LOG;
    }

    @Override
    public void fatal(Object object) {
        this.fatalLogger.fatal(object);
    }

    @Override
    public void fatal(Object object, Throwable throwable) {
        this.fatalLogger.fatal(object, throwable);
    }

    @Override
    public void error(Object object) {
        this.errorLogger.error(object);
    }

    @Override
    public void error(Object object, Throwable throwable) {
        this.errorLogger.error(object, throwable);
    }

    @Override
    public void warn(Object object) {
        this.warnLogger.warn(object);
    }

    @Override
    public void warn(Object object, Throwable throwable) {
        this.warnLogger.warn(object, throwable);
    }

    @Override
    public void info(Object object) {
        this.infoLogger.info(object);
    }

    @Override
    public void info(Object object, Throwable throwable) {
        this.infoLogger.info(object, throwable);
    }

    @Override
    public void debug(Object object) {
        this.debugLogger.debug(object);
    }

    @Override
    public void debug(Object object, Throwable throwable) {
        this.debugLogger.debug(object, throwable);
    }

    @Override
    public void trace(Object object) {
        this.traceLogger.trace(object);
    }

    @Override
    public void trace(Object object, Throwable throwable) {
        this.traceLogger.trace(object, throwable);
    }
}

