/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.io.support;

import java.io.IOException;
import java.util.Map;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.EncodedResource;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public class ResourcePropertySource
extends PropertiesPropertySource {
    @Nullable
    private final String resourceName;

    public ResourcePropertySource(String string, EncodedResource encodedResource) throws IOException {
        super(string, PropertiesLoaderUtils.loadProperties(encodedResource));
        this.resourceName = ResourcePropertySource.getNameForResource(encodedResource.getResource());
    }

    public ResourcePropertySource(EncodedResource encodedResource) throws IOException {
        super(ResourcePropertySource.getNameForResource(encodedResource.getResource()), PropertiesLoaderUtils.loadProperties(encodedResource));
        this.resourceName = null;
    }

    public ResourcePropertySource(String string, Resource resource) throws IOException {
        super(string, PropertiesLoaderUtils.loadProperties(new EncodedResource(resource)));
        this.resourceName = ResourcePropertySource.getNameForResource(resource);
    }

    public ResourcePropertySource(Resource resource) throws IOException {
        super(ResourcePropertySource.getNameForResource(resource), PropertiesLoaderUtils.loadProperties(new EncodedResource(resource)));
        this.resourceName = null;
    }

    public ResourcePropertySource(String string, String string2, ClassLoader classLoader) throws IOException {
        this(string, new DefaultResourceLoader(classLoader).getResource(string2));
    }

    public ResourcePropertySource(String string, ClassLoader classLoader) throws IOException {
        this(new DefaultResourceLoader(classLoader).getResource(string));
    }

    public ResourcePropertySource(String string, String string2) throws IOException {
        this(string, new DefaultResourceLoader().getResource(string2));
    }

    public ResourcePropertySource(String string) throws IOException {
        this(new DefaultResourceLoader().getResource(string));
    }

    private ResourcePropertySource(String string, @Nullable String string2, Map<String, Object> map) {
        super(string, map);
        this.resourceName = string2;
    }

    public ResourcePropertySource withName(String string) {
        if (this.name.equals(string)) {
            return this;
        }
        if (this.resourceName != null) {
            if (this.resourceName.equals(string)) {
                return new ResourcePropertySource(this.resourceName, null, (Map)this.source);
            }
            return new ResourcePropertySource(string, this.resourceName, (Map)this.source);
        }
        return new ResourcePropertySource(string, this.name, (Map)this.source);
    }

    public ResourcePropertySource withResourceName() {
        if (this.resourceName == null) {
            return this;
        }
        return new ResourcePropertySource(this.resourceName, null, (Map)this.source);
    }

    private static String getNameForResource(Resource resource) {
        String string = resource.getDescription();
        if (!StringUtils.hasText(string)) {
            string = resource.getClass().getSimpleName() + "@" + System.identityHashCode(resource);
        }
        return string;
    }
}

