/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.io.support;

import java.beans.PropertyEditorSupport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class ResourceArrayPropertyEditor
extends PropertyEditorSupport {
    private static final Log logger = LogFactory.getLog(ResourceArrayPropertyEditor.class);
    private final ResourcePatternResolver resourcePatternResolver;
    @Nullable
    private PropertyResolver propertyResolver;
    private final boolean ignoreUnresolvablePlaceholders;

    public ResourceArrayPropertyEditor() {
        this(new PathMatchingResourcePatternResolver(), null, true);
    }

    public ResourceArrayPropertyEditor(ResourcePatternResolver resourcePatternResolver, @Nullable PropertyResolver propertyResolver) {
        this(resourcePatternResolver, propertyResolver, true);
    }

    public ResourceArrayPropertyEditor(ResourcePatternResolver resourcePatternResolver, @Nullable PropertyResolver propertyResolver, boolean bl) {
        Assert.notNull((Object)resourcePatternResolver, "ResourcePatternResolver must not be null");
        this.resourcePatternResolver = resourcePatternResolver;
        this.propertyResolver = propertyResolver;
        this.ignoreUnresolvablePlaceholders = bl;
    }

    @Override
    public void setAsText(String string) {
        String string2 = this.resolvePath(string).trim();
        try {
            this.setValue(this.resourcePatternResolver.getResources(string2));
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Could not resolve resource location pattern [" + string2 + "]: " + iOException.getMessage());
        }
    }

    @Override
    public void setValue(Object object) throws IllegalArgumentException {
        if (object instanceof Collection || object instanceof Object[] && !(object instanceof Resource[])) {
            List<Object> list = object instanceof Collection ? (List<Object>)object : Arrays.asList((Object[])object);
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (Object e : list) {
                Object object2;
                if (e instanceof String) {
                    object2 = this.resolvePath((String)e).trim();
                    try {
                        Resource[] resourceArray;
                        for (Resource resource : resourceArray = this.resourcePatternResolver.getResources((String)object2)) {
                            if (arrayList.contains(resource)) continue;
                            arrayList.add(resource);
                        }
                        continue;
                    }
                    catch (IOException iOException) {
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug("Could not retrieve resources for pattern '" + (String)object2 + "'", iOException);
                        continue;
                    }
                }
                if (e instanceof Resource) {
                    object2 = (Resource)e;
                    if (arrayList.contains(object2)) continue;
                    arrayList.add(object2);
                    continue;
                }
                throw new IllegalArgumentException("Cannot convert element [" + e + "] to [" + Resource.class.getName() + "]: only location String and Resource object supported");
            }
            super.setValue(arrayList.toArray(new Resource[0]));
        } else {
            super.setValue(object);
        }
    }

    protected String resolvePath(String string) {
        if (this.propertyResolver == null) {
            this.propertyResolver = new StandardEnvironment();
        }
        return this.ignoreUnresolvablePlaceholders ? this.propertyResolver.resolvePlaceholders(string) : this.propertyResolver.resolveRequiredPlaceholders(string);
    }
}

