/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.io.support;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Properties;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.EncodedResource;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.DefaultPropertiesPersister;
import org.springframework.util.PropertiesPersister;
import org.springframework.util.ResourceUtils;

public abstract class PropertiesLoaderUtils {
    private static final String XML_FILE_EXTENSION = ".xml";

    public static Properties loadProperties(EncodedResource encodedResource) throws IOException {
        Properties properties = new Properties();
        PropertiesLoaderUtils.fillProperties(properties, encodedResource);
        return properties;
    }

    public static void fillProperties(Properties properties, EncodedResource encodedResource) throws IOException {
        PropertiesLoaderUtils.fillProperties(properties, encodedResource, new DefaultPropertiesPersister());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void fillProperties(Properties properties, EncodedResource encodedResource, PropertiesPersister propertiesPersister) throws IOException {
        InputStream inputStream2 = null;
        Reader reader = null;
        try {
            String string = encodedResource.getResource().getFilename();
            if (string != null && string.endsWith(XML_FILE_EXTENSION)) {
                inputStream2 = encodedResource.getInputStream();
                propertiesPersister.loadFromXml(properties, inputStream2);
            } else if (encodedResource.requiresReader()) {
                reader = encodedResource.getReader();
                propertiesPersister.load(properties, reader);
            } else {
                inputStream2 = encodedResource.getInputStream();
                propertiesPersister.load(properties, inputStream2);
            }
        }
        finally {
            if (inputStream2 != null) {
                inputStream2.close();
            }
            if (reader != null) {
                reader.close();
            }
        }
    }

    public static Properties loadProperties(Resource resource) throws IOException {
        Properties properties = new Properties();
        PropertiesLoaderUtils.fillProperties(properties, resource);
        return properties;
    }

    public static void fillProperties(Properties properties, Resource resource) throws IOException {
        try (InputStream inputStream2 = resource.getInputStream();){
            String string = resource.getFilename();
            if (string != null && string.endsWith(XML_FILE_EXTENSION)) {
                properties.loadFromXML(inputStream2);
            } else {
                properties.load(inputStream2);
            }
        }
    }

    public static Properties loadAllProperties(String string) throws IOException {
        return PropertiesLoaderUtils.loadAllProperties(string, null);
    }

    public static Properties loadAllProperties(String string, @Nullable ClassLoader classLoader) throws IOException {
        Assert.notNull((Object)string, "Resource name must not be null");
        ClassLoader classLoader2 = classLoader;
        if (classLoader2 == null) {
            classLoader2 = ClassUtils.getDefaultClassLoader();
        }
        Enumeration<URL> enumeration = classLoader2 != null ? classLoader2.getResources(string) : ClassLoader.getSystemResources(string);
        Properties properties = new Properties();
        while (enumeration.hasMoreElements()) {
            URL uRL = enumeration.nextElement();
            URLConnection uRLConnection = uRL.openConnection();
            ResourceUtils.useCachesIfNecessary(uRLConnection);
            InputStream inputStream2 = uRLConnection.getInputStream();
            Throwable throwable = null;
            try {
                if (string.endsWith(XML_FILE_EXTENSION)) {
                    properties.loadFromXML(inputStream2);
                    continue;
                }
                properties.load(inputStream2);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (inputStream2 == null) continue;
                if (throwable != null) {
                    try {
                        inputStream2.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                inputStream2.close();
            }
        }
        return properties;
    }
}

