/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.io.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.ByteBufUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.function.IntPredicate;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.NettyDataBufferFactory;
import org.springframework.core.io.buffer.PooledDataBuffer;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class NettyDataBuffer
implements PooledDataBuffer {
    private final ByteBuf byteBuf;
    private final NettyDataBufferFactory dataBufferFactory;

    NettyDataBuffer(ByteBuf byteBuf, NettyDataBufferFactory nettyDataBufferFactory) {
        Assert.notNull((Object)byteBuf, "ByteBuf must not be null");
        Assert.notNull((Object)nettyDataBufferFactory, "NettyDataBufferFactory must not be null");
        this.byteBuf = byteBuf;
        this.dataBufferFactory = nettyDataBufferFactory;
    }

    public ByteBuf getNativeBuffer() {
        return this.byteBuf;
    }

    @Override
    public NettyDataBufferFactory factory() {
        return this.dataBufferFactory;
    }

    @Override
    public int indexOf(IntPredicate intPredicate, int n) {
        Assert.notNull((Object)intPredicate, "IntPredicate must not be null");
        if (n < 0) {
            n = 0;
        } else if (n >= this.byteBuf.writerIndex()) {
            return -1;
        }
        int n2 = this.byteBuf.writerIndex() - n;
        return this.byteBuf.forEachByte(n, n2, intPredicate.negate()::test);
    }

    @Override
    public int lastIndexOf(IntPredicate intPredicate, int n) {
        Assert.notNull((Object)intPredicate, "IntPredicate must not be null");
        if (n < 0) {
            return -1;
        }
        n = Math.min(n, this.byteBuf.writerIndex() - 1);
        return this.byteBuf.forEachByteDesc(0, n + 1, intPredicate.negate()::test);
    }

    @Override
    public int readableByteCount() {
        return this.byteBuf.readableBytes();
    }

    @Override
    public int writableByteCount() {
        return this.byteBuf.writableBytes();
    }

    @Override
    public int readPosition() {
        return this.byteBuf.readerIndex();
    }

    @Override
    public NettyDataBuffer readPosition(int n) {
        this.byteBuf.readerIndex(n);
        return this;
    }

    @Override
    public int writePosition() {
        return this.byteBuf.writerIndex();
    }

    @Override
    public NettyDataBuffer writePosition(int n) {
        this.byteBuf.writerIndex(n);
        return this;
    }

    @Override
    public byte getByte(int n) {
        return this.byteBuf.getByte(n);
    }

    @Override
    public int capacity() {
        return this.byteBuf.capacity();
    }

    @Override
    public NettyDataBuffer capacity(int n) {
        this.byteBuf.capacity(n);
        return this;
    }

    @Override
    public DataBuffer ensureCapacity(int n) {
        this.byteBuf.ensureWritable(n);
        return this;
    }

    @Override
    public byte read() {
        return this.byteBuf.readByte();
    }

    @Override
    public NettyDataBuffer read(byte[] byArray) {
        this.byteBuf.readBytes(byArray);
        return this;
    }

    @Override
    public NettyDataBuffer read(byte[] byArray, int n, int n2) {
        this.byteBuf.readBytes(byArray, n, n2);
        return this;
    }

    @Override
    public NettyDataBuffer write(byte by) {
        this.byteBuf.writeByte((int)by);
        return this;
    }

    @Override
    public NettyDataBuffer write(byte[] byArray) {
        this.byteBuf.writeBytes(byArray);
        return this;
    }

    @Override
    public NettyDataBuffer write(byte[] byArray, int n, int n2) {
        this.byteBuf.writeBytes(byArray, n, n2);
        return this;
    }

    @Override
    public NettyDataBuffer write(DataBuffer ... dataBufferArray) {
        if (!ObjectUtils.isEmpty(dataBufferArray)) {
            if (NettyDataBuffer.hasNettyDataBuffers(dataBufferArray)) {
                ByteBuf[] byteBufArray = new ByteBuf[dataBufferArray.length];
                for (int i = 0; i < dataBufferArray.length; ++i) {
                    byteBufArray[i] = ((NettyDataBuffer)dataBufferArray[i]).getNativeBuffer();
                }
                this.write(byteBufArray);
            } else {
                ByteBuffer[] byteBufferArray = new ByteBuffer[dataBufferArray.length];
                for (int i = 0; i < dataBufferArray.length; ++i) {
                    byteBufferArray[i] = dataBufferArray[i].asByteBuffer();
                }
                this.write(byteBufferArray);
            }
        }
        return this;
    }

    private static boolean hasNettyDataBuffers(DataBuffer[] dataBufferArray) {
        for (DataBuffer dataBuffer : dataBufferArray) {
            if (dataBuffer instanceof NettyDataBuffer) continue;
            return false;
        }
        return true;
    }

    @Override
    public NettyDataBuffer write(ByteBuffer ... byteBufferArray) {
        if (!ObjectUtils.isEmpty(byteBufferArray)) {
            for (ByteBuffer byteBuffer : byteBufferArray) {
                this.byteBuf.writeBytes(byteBuffer);
            }
        }
        return this;
    }

    public NettyDataBuffer write(ByteBuf ... byteBufArray) {
        if (!ObjectUtils.isEmpty(byteBufArray)) {
            for (ByteBuf byteBuf : byteBufArray) {
                this.byteBuf.writeBytes(byteBuf);
            }
        }
        return this;
    }

    @Override
    public DataBuffer write(CharSequence charSequence, Charset charset) {
        Assert.notNull((Object)charSequence, "CharSequence must not be null");
        Assert.notNull((Object)charset, "Charset must not be null");
        if (StandardCharsets.UTF_8.equals(charset)) {
            ByteBufUtil.writeUtf8((ByteBuf)this.byteBuf, (CharSequence)charSequence);
        } else if (StandardCharsets.US_ASCII.equals(charset)) {
            ByteBufUtil.writeAscii((ByteBuf)this.byteBuf, (CharSequence)charSequence);
        } else {
            return PooledDataBuffer.super.write(charSequence, charset);
        }
        return this;
    }

    @Override
    public NettyDataBuffer slice(int n, int n2) {
        ByteBuf byteBuf = this.byteBuf.slice(n, n2);
        return new NettyDataBuffer(byteBuf, this.dataBufferFactory);
    }

    @Override
    public NettyDataBuffer retainedSlice(int n, int n2) {
        ByteBuf byteBuf = this.byteBuf.retainedSlice(n, n2);
        return new NettyDataBuffer(byteBuf, this.dataBufferFactory);
    }

    @Override
    public ByteBuffer asByteBuffer() {
        return this.byteBuf.nioBuffer();
    }

    @Override
    public ByteBuffer asByteBuffer(int n, int n2) {
        return this.byteBuf.nioBuffer(n, n2);
    }

    @Override
    public InputStream asInputStream() {
        return new ByteBufInputStream(this.byteBuf);
    }

    @Override
    public InputStream asInputStream(boolean bl) {
        return new ByteBufInputStream(this.byteBuf, bl);
    }

    @Override
    public OutputStream asOutputStream() {
        return new ByteBufOutputStream(this.byteBuf);
    }

    @Override
    public String toString(Charset charset) {
        Assert.notNull((Object)charset, "Charset must not be null");
        return this.byteBuf.toString(charset);
    }

    @Override
    public String toString(int n, int n2, Charset charset) {
        Assert.notNull((Object)charset, "Charset must not be null");
        return this.byteBuf.toString(n, n2, charset);
    }

    @Override
    public boolean isAllocated() {
        return this.byteBuf.refCnt() > 0;
    }

    @Override
    public PooledDataBuffer retain() {
        return new NettyDataBuffer(this.byteBuf.retain(), this.dataBufferFactory);
    }

    @Override
    public boolean release() {
        return this.byteBuf.release();
    }

    public boolean equals(@Nullable Object object) {
        return this == object || object instanceof NettyDataBuffer && this.byteBuf.equals((Object)((NettyDataBuffer)object).byteBuf);
    }

    public int hashCode() {
        return this.byteBuf.hashCode();
    }

    public String toString() {
        return this.byteBuf.toString();
    }
}

