/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import org.springframework.core.io.AbstractFileResolvingResource;
import org.springframework.core.io.Resource;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ResourceUtils;
import org.springframework.util.StringUtils;

public class UrlResource
extends AbstractFileResolvingResource {
    @Nullable
    private final URI uri;
    private final URL url;
    @Nullable
    private volatile URL cleanedUrl;

    public UrlResource(URI uRI) throws MalformedURLException {
        Assert.notNull((Object)uRI, "URI must not be null");
        this.uri = uRI;
        this.url = uRI.toURL();
    }

    public UrlResource(URL uRL) {
        Assert.notNull((Object)uRL, "URL must not be null");
        this.uri = null;
        this.url = uRL;
    }

    public UrlResource(String string) throws MalformedURLException {
        Assert.notNull((Object)string, "Path must not be null");
        this.uri = null;
        this.url = new URL(string);
        this.cleanedUrl = UrlResource.getCleanedUrl(this.url, string);
    }

    public UrlResource(String string, String string2) throws MalformedURLException {
        this(string, string2, null);
    }

    public UrlResource(String string, String string2, @Nullable String string3) throws MalformedURLException {
        try {
            this.uri = new URI(string, string2, string3);
            this.url = this.uri.toURL();
        }
        catch (URISyntaxException uRISyntaxException) {
            MalformedURLException malformedURLException = new MalformedURLException(uRISyntaxException.getMessage());
            malformedURLException.initCause(uRISyntaxException);
            throw malformedURLException;
        }
    }

    private static URL getCleanedUrl(URL uRL, String string) {
        String string2 = StringUtils.cleanPath(string);
        if (!string2.equals(string)) {
            try {
                return new URL(string2);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return uRL;
    }

    private URL getCleanedUrl() {
        URL uRL = this.cleanedUrl;
        if (uRL != null) {
            return uRL;
        }
        this.cleanedUrl = uRL = UrlResource.getCleanedUrl(this.url, (this.uri != null ? this.uri : this.url).toString());
        return uRL;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        URLConnection uRLConnection = this.url.openConnection();
        ResourceUtils.useCachesIfNecessary(uRLConnection);
        try {
            return uRLConnection.getInputStream();
        }
        catch (IOException iOException) {
            if (uRLConnection instanceof HttpURLConnection) {
                ((HttpURLConnection)uRLConnection).disconnect();
            }
            throw iOException;
        }
    }

    @Override
    public URL getURL() {
        return this.url;
    }

    @Override
    public URI getURI() throws IOException {
        if (this.uri != null) {
            return this.uri;
        }
        return super.getURI();
    }

    @Override
    public boolean isFile() {
        if (this.uri != null) {
            return super.isFile(this.uri);
        }
        return super.isFile();
    }

    @Override
    public File getFile() throws IOException {
        if (this.uri != null) {
            return super.getFile(this.uri);
        }
        return super.getFile();
    }

    @Override
    public Resource createRelative(String string) throws MalformedURLException {
        return new UrlResource(this.createRelativeURL(string));
    }

    protected URL createRelativeURL(String string) throws MalformedURLException {
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        string = StringUtils.replace(string, "#", "%23");
        return new URL(this.url, string);
    }

    @Override
    public String getFilename() {
        return StringUtils.getFilename(this.getCleanedUrl().getPath());
    }

    @Override
    public String getDescription() {
        return "URL [" + this.url + "]";
    }

    @Override
    public boolean equals(@Nullable Object object) {
        return this == object || object instanceof UrlResource && this.getCleanedUrl().equals(((UrlResource)object).getCleanedUrl());
    }

    @Override
    public int hashCode() {
        return this.getCleanedUrl().hashCode();
    }
}

