/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.io;

import java.beans.PropertyEditorSupport;
import java.io.IOException;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class ResourceEditor
extends PropertyEditorSupport {
    private final ResourceLoader resourceLoader;
    @Nullable
    private PropertyResolver propertyResolver;
    private final boolean ignoreUnresolvablePlaceholders;

    public ResourceEditor() {
        this(new DefaultResourceLoader(), null);
    }

    public ResourceEditor(ResourceLoader resourceLoader, @Nullable PropertyResolver propertyResolver) {
        this(resourceLoader, propertyResolver, true);
    }

    public ResourceEditor(ResourceLoader resourceLoader, @Nullable PropertyResolver propertyResolver, boolean bl) {
        Assert.notNull((Object)resourceLoader, "ResourceLoader must not be null");
        this.resourceLoader = resourceLoader;
        this.propertyResolver = propertyResolver;
        this.ignoreUnresolvablePlaceholders = bl;
    }

    @Override
    public void setAsText(String string) {
        if (StringUtils.hasText(string)) {
            String string2 = this.resolvePath(string).trim();
            this.setValue(this.resourceLoader.getResource(string2));
        } else {
            this.setValue(null);
        }
    }

    protected String resolvePath(String string) {
        if (this.propertyResolver == null) {
            this.propertyResolver = new StandardEnvironment();
        }
        return this.ignoreUnresolvablePlaceholders ? this.propertyResolver.resolvePlaceholders(string) : this.propertyResolver.resolveRequiredPlaceholders(string);
    }

    @Override
    @Nullable
    public String getAsText() {
        Resource resource = (Resource)this.getValue();
        try {
            return resource != null ? resource.getURL().toExternalForm() : "";
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

