/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.io;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.ContextResource;
import org.springframework.core.io.FileUrlResource;
import org.springframework.core.io.ProtocolResolver;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.UrlResource;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ResourceUtils;
import org.springframework.util.StringUtils;

public class DefaultResourceLoader
implements ResourceLoader {
    @Nullable
    private ClassLoader classLoader;
    private final Set<ProtocolResolver> protocolResolvers = new LinkedHashSet<ProtocolResolver>(4);
    private final Map<Class<?>, Map<Resource, ?>> resourceCaches = new ConcurrentHashMap(4);

    public DefaultResourceLoader() {
        this.classLoader = ClassUtils.getDefaultClassLoader();
    }

    public DefaultResourceLoader(@Nullable ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setClassLoader(@Nullable ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    @Nullable
    public ClassLoader getClassLoader() {
        return this.classLoader != null ? this.classLoader : ClassUtils.getDefaultClassLoader();
    }

    public void addProtocolResolver(ProtocolResolver protocolResolver) {
        Assert.notNull((Object)protocolResolver, "ProtocolResolver must not be null");
        this.protocolResolvers.add(protocolResolver);
    }

    public Collection<ProtocolResolver> getProtocolResolvers() {
        return this.protocolResolvers;
    }

    public <T> Map<Resource, T> getResourceCache(Class<T> clazz2) {
        return this.resourceCaches.computeIfAbsent(clazz2, clazz -> new ConcurrentHashMap());
    }

    public void clearResourceCaches() {
        this.resourceCaches.clear();
    }

    @Override
    public Resource getResource(String string) {
        Assert.notNull((Object)string, "Location must not be null");
        for (ProtocolResolver protocolResolver : this.getProtocolResolvers()) {
            Resource resource = protocolResolver.resolve(string, this);
            if (resource == null) continue;
            return resource;
        }
        if (string.startsWith("/")) {
            return this.getResourceByPath(string);
        }
        if (string.startsWith("classpath:")) {
            return new ClassPathResource(string.substring("classpath:".length()), this.getClassLoader());
        }
        try {
            URL uRL = new URL(string);
            return ResourceUtils.isFileURL(uRL) ? new FileUrlResource(uRL) : new UrlResource(uRL);
        }
        catch (MalformedURLException malformedURLException) {
            return this.getResourceByPath(string);
        }
    }

    protected Resource getResourceByPath(String string) {
        return new ClassPathContextResource(string, this.getClassLoader());
    }

    protected static class ClassPathContextResource
    extends ClassPathResource
    implements ContextResource {
        public ClassPathContextResource(String string, @Nullable ClassLoader classLoader) {
            super(string, classLoader);
        }

        @Override
        public String getPathWithinContext() {
            return this.getPath();
        }

        @Override
        public Resource createRelative(String string) {
            String string2 = StringUtils.applyRelativePath(this.getPath(), string);
            return new ClassPathContextResource(string2, this.getClassLoader());
        }
    }
}

