/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.env;

import java.util.Map;
import org.springframework.core.env.MapPropertySource;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class SystemEnvironmentPropertySource
extends MapPropertySource {
    public SystemEnvironmentPropertySource(String string, Map<String, Object> map) {
        super(string, map);
    }

    @Override
    public boolean containsProperty(String string) {
        return this.getProperty(string) != null;
    }

    @Override
    @Nullable
    public Object getProperty(String string) {
        String string2 = this.resolvePropertyName(string);
        if (this.logger.isDebugEnabled() && !string.equals(string2)) {
            this.logger.debug("PropertySource '" + this.getName() + "' does not contain property '" + string + "', but found equivalent '" + string2 + "'");
        }
        return super.getProperty(string2);
    }

    protected final String resolvePropertyName(String string) {
        Assert.notNull((Object)string, "Property name must not be null");
        String string2 = this.checkPropertyName(string);
        if (string2 != null) {
            return string2;
        }
        String string3 = string.toUpperCase();
        if (!string.equals(string3) && (string2 = this.checkPropertyName(string3)) != null) {
            return string2;
        }
        return string;
    }

    @Nullable
    private String checkPropertyName(String string) {
        if (this.containsKey(string)) {
            return string;
        }
        String string2 = string.replace('.', '_');
        if (!string.equals(string2) && this.containsKey(string2)) {
            return string2;
        }
        String string3 = string.replace('-', '_');
        if (!string.equals(string3) && this.containsKey(string3)) {
            return string3;
        }
        String string4 = string2.replace('-', '_');
        if (!string2.equals(string4) && this.containsKey(string4)) {
            return string4;
        }
        return null;
    }

    private boolean containsKey(String string) {
        return this.isSecurityManagerPresent() ? ((Map)this.source).keySet().contains(string) : ((Map)this.source).containsKey(string);
    }

    protected boolean isSecurityManagerPresent() {
        return System.getSecurityManager() != null;
    }
}

