/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.env;

import org.springframework.core.env.AbstractPropertyResolver;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.PropertySources;
import org.springframework.lang.Nullable;

public class PropertySourcesPropertyResolver
extends AbstractPropertyResolver {
    @Nullable
    private final PropertySources propertySources;

    public PropertySourcesPropertyResolver(@Nullable PropertySources propertySources) {
        this.propertySources = propertySources;
    }

    @Override
    public boolean containsProperty(String string) {
        if (this.propertySources != null) {
            for (PropertySource propertySource : this.propertySources) {
                if (!propertySource.containsProperty(string)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    @Nullable
    public String getProperty(String string) {
        return this.getProperty(string, String.class, true);
    }

    @Override
    @Nullable
    public <T> T getProperty(String string, Class<T> clazz) {
        return this.getProperty(string, clazz, true);
    }

    @Override
    @Nullable
    protected String getPropertyAsRawString(String string) {
        return this.getProperty(string, String.class, false);
    }

    @Nullable
    protected <T> T getProperty(String string, Class<T> clazz, boolean bl) {
        if (this.propertySources != null) {
            for (PropertySource propertySource : this.propertySources) {
                Object object;
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("Searching for key '" + string + "' in PropertySource '" + propertySource.getName() + "'");
                }
                if ((object = propertySource.getProperty(string)) == null) continue;
                if (bl && object instanceof String) {
                    object = this.resolveNestedPlaceholders((String)object);
                }
                this.logKeyFound(string, propertySource, object);
                return this.convertValueIfNecessary(object, clazz);
            }
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Could not find key '" + string + "' in any property source");
        }
        return null;
    }

    protected void logKeyFound(String string, PropertySource<?> propertySource, Object object) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Found key '" + string + "' in PropertySource '" + propertySource.getName() + "' with value of type " + object.getClass().getSimpleName());
        }
    }
}

