/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.env;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public abstract class PropertySource<T> {
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected final String name;
    protected final T source;

    public PropertySource(String string, T t2) {
        Assert.hasText(string, "Property source name must contain at least one character");
        Assert.notNull(t2, "Property source must not be null");
        this.name = string;
        this.source = t2;
    }

    public PropertySource(String string) {
        this(string, new Object());
    }

    public String getName() {
        return this.name;
    }

    public T getSource() {
        return this.source;
    }

    public boolean containsProperty(String string) {
        return this.getProperty(string) != null;
    }

    @Nullable
    public abstract Object getProperty(String var1);

    public boolean equals(@Nullable Object object) {
        return this == object || object instanceof PropertySource && ObjectUtils.nullSafeEquals(this.getName(), ((PropertySource)object).getName());
    }

    public int hashCode() {
        return ObjectUtils.nullSafeHashCode(this.getName());
    }

    public String toString() {
        if (this.logger.isDebugEnabled()) {
            return this.getClass().getSimpleName() + "@" + System.identityHashCode(this) + " {name='" + this.getName() + "', properties=" + this.getSource() + "}";
        }
        return this.getClass().getSimpleName() + " {name='" + this.getName() + "'}";
    }

    public static PropertySource<?> named(String string) {
        return new ComparisonPropertySource(string);
    }

    static class ComparisonPropertySource
    extends StubPropertySource {
        private static final String USAGE_ERROR = "ComparisonPropertySource instances are for use with collection comparison only";

        public ComparisonPropertySource(String string) {
            super(string);
        }

        @Override
        public Object getSource() {
            throw new UnsupportedOperationException(USAGE_ERROR);
        }

        @Override
        public boolean containsProperty(String string) {
            throw new UnsupportedOperationException(USAGE_ERROR);
        }

        @Override
        @Nullable
        public String getProperty(String string) {
            throw new UnsupportedOperationException(USAGE_ERROR);
        }
    }

    public static class StubPropertySource
    extends PropertySource<Object> {
        public StubPropertySource(String string) {
            super(string, new Object());
        }

        @Override
        @Nullable
        public String getProperty(String string) {
            return null;
        }
    }
}

