/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.env;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.function.Predicate;
import org.springframework.core.env.Profiles;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

final class ProfilesParser {
    private ProfilesParser() {
    }

    static Profiles parse(String ... stringArray) {
        Assert.notEmpty((Object[])stringArray, "Must specify at least one profile");
        Profiles[] profilesArray = new Profiles[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            profilesArray[i] = ProfilesParser.parseExpression(stringArray[i]);
        }
        return new ParsedProfiles(stringArray, profilesArray);
    }

    private static Profiles parseExpression(String string) {
        Assert.hasText(string, () -> "Invalid profile expression [" + string + "]: must contain text");
        StringTokenizer stringTokenizer = new StringTokenizer(string, "()&|!", true);
        return ProfilesParser.parseTokens(string, stringTokenizer);
    }

    private static Profiles parseTokens(String string, StringTokenizer stringTokenizer) {
        return ProfilesParser.parseTokens(string, stringTokenizer, Context.NONE);
    }

    private static Profiles parseTokens(String string, StringTokenizer stringTokenizer, Context context) {
        ArrayList<Profiles> arrayList = new ArrayList<Profiles>();
        Operator operator = null;
        block14: while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (string2.isEmpty()) continue;
            switch (string2) {
                case "(": {
                    Profiles profiles = ProfilesParser.parseTokens(string, stringTokenizer, Context.BRACKET);
                    if (context == Context.INVERT) {
                        return profiles;
                    }
                    arrayList.add(profiles);
                    continue block14;
                }
                case "&": {
                    ProfilesParser.assertWellFormed(string, operator == null || operator == Operator.AND);
                    operator = Operator.AND;
                    continue block14;
                }
                case "|": {
                    ProfilesParser.assertWellFormed(string, operator == null || operator == Operator.OR);
                    operator = Operator.OR;
                    continue block14;
                }
                case "!": {
                    arrayList.add(ProfilesParser.not(ProfilesParser.parseTokens(string, stringTokenizer, Context.INVERT)));
                    continue block14;
                }
                case ")": {
                    Profiles profiles = ProfilesParser.merge(string, arrayList, operator);
                    if (context == Context.BRACKET) {
                        return profiles;
                    }
                    arrayList.clear();
                    arrayList.add(profiles);
                    operator = null;
                    continue block14;
                }
            }
            Profiles profiles = ProfilesParser.equals(string2);
            if (context == Context.INVERT) {
                return profiles;
            }
            arrayList.add(profiles);
        }
        return ProfilesParser.merge(string, arrayList, operator);
    }

    private static Profiles merge(String string, List<Profiles> list, @Nullable Operator operator) {
        ProfilesParser.assertWellFormed(string, !list.isEmpty());
        if (list.size() == 1) {
            return list.get(0);
        }
        Profiles[] profilesArray = list.toArray(new Profiles[0]);
        return operator == Operator.AND ? ProfilesParser.and(profilesArray) : ProfilesParser.or(profilesArray);
    }

    private static void assertWellFormed(String string, boolean bl) {
        Assert.isTrue(bl, () -> "Malformed profile expression [" + string + "]");
    }

    private static Profiles or(Profiles ... profilesArray) {
        return predicate -> Arrays.stream(profilesArray).anyMatch(ProfilesParser.isMatch(predicate));
    }

    private static Profiles and(Profiles ... profilesArray) {
        return predicate -> Arrays.stream(profilesArray).allMatch(ProfilesParser.isMatch(predicate));
    }

    private static Profiles not(Profiles profiles) {
        return predicate -> !profiles.matches(predicate);
    }

    private static Profiles equals(String string) {
        return predicate -> predicate.test(string);
    }

    private static Predicate<Profiles> isMatch(Predicate<String> predicate) {
        return profiles -> profiles.matches(predicate);
    }

    private static class ParsedProfiles
    implements Profiles {
        private final Set<String> expressions = new LinkedHashSet<String>();
        private final Profiles[] parsed;

        ParsedProfiles(String[] stringArray, Profiles[] profilesArray) {
            Collections.addAll(this.expressions, stringArray);
            this.parsed = profilesArray;
        }

        @Override
        public boolean matches(Predicate<String> predicate) {
            for (Profiles profiles : this.parsed) {
                if (!profiles.matches(predicate)) continue;
                return true;
            }
            return false;
        }

        public int hashCode() {
            return this.expressions.hashCode();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            ParsedProfiles parsedProfiles = (ParsedProfiles)object;
            return this.expressions.equals(parsedProfiles.expressions);
        }

        public String toString() {
            return StringUtils.collectionToDelimitedString(this.expressions, " or ");
        }
    }

    private static enum Context {
        NONE,
        INVERT,
        BRACKET;

    }

    private static enum Operator {
        AND,
        OR;

    }
}

