/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.env;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.springframework.core.env.CommandLinePropertySource;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class JOptCommandLinePropertySource
extends CommandLinePropertySource<OptionSet> {
    public JOptCommandLinePropertySource(OptionSet optionSet) {
        super(optionSet);
    }

    public JOptCommandLinePropertySource(String string, OptionSet optionSet) {
        super(string, optionSet);
    }

    @Override
    protected boolean containsOption(String string) {
        return ((OptionSet)this.source).has(string);
    }

    @Override
    public String[] getPropertyNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (OptionSpec optionSpec : ((OptionSet)this.source).specs()) {
            String string = (String)CollectionUtils.lastElement(optionSpec.options());
            if (string == null) continue;
            arrayList.add(string);
        }
        return StringUtils.toStringArray(arrayList);
    }

    @Override
    @Nullable
    public List<String> getOptionValues(String string) {
        List list = ((OptionSet)this.source).valuesOf(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Object e : list) {
            arrayList.add(e.toString());
        }
        if (arrayList.isEmpty()) {
            return ((OptionSet)this.source).has(string) ? Collections.emptyList() : null;
        }
        return Collections.unmodifiableList(arrayList);
    }

    @Override
    protected List<String> getNonOptionArgs() {
        List list = ((OptionSet)this.source).nonOptionArguments();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Object e : list) {
            arrayList.add(e.toString());
        }
        return arrayList.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(arrayList);
    }
}

