/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.env;

import java.util.List;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public abstract class CommandLinePropertySource<T>
extends EnumerablePropertySource<T> {
    public static final String COMMAND_LINE_PROPERTY_SOURCE_NAME = "commandLineArgs";
    public static final String DEFAULT_NON_OPTION_ARGS_PROPERTY_NAME = "nonOptionArgs";
    private String nonOptionArgsPropertyName = "nonOptionArgs";

    public CommandLinePropertySource(T t2) {
        super(COMMAND_LINE_PROPERTY_SOURCE_NAME, t2);
    }

    public CommandLinePropertySource(String string, T t2) {
        super(string, t2);
    }

    public void setNonOptionArgsPropertyName(String string) {
        this.nonOptionArgsPropertyName = string;
    }

    @Override
    public final boolean containsProperty(String string) {
        if (this.nonOptionArgsPropertyName.equals(string)) {
            return !this.getNonOptionArgs().isEmpty();
        }
        return this.containsOption(string);
    }

    @Override
    @Nullable
    public final String getProperty(String string) {
        if (this.nonOptionArgsPropertyName.equals(string)) {
            List<String> list = this.getNonOptionArgs();
            if (list.isEmpty()) {
                return null;
            }
            return StringUtils.collectionToCommaDelimitedString(list);
        }
        List<String> list = this.getOptionValues(string);
        if (list == null) {
            return null;
        }
        return StringUtils.collectionToCommaDelimitedString(list);
    }

    protected abstract boolean containsOption(String var1);

    @Nullable
    protected abstract List<String> getOptionValues(String var1);

    protected abstract List<String> getNonOptionArgs();
}

