/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.env;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.lang.Nullable;

class CommandLineArgs {
    private final Map<String, List<String>> optionArgs = new HashMap<String, List<String>>();
    private final List<String> nonOptionArgs = new ArrayList<String>();

    CommandLineArgs() {
    }

    public void addOptionArg(String string, @Nullable String string2) {
        if (!this.optionArgs.containsKey(string)) {
            this.optionArgs.put(string, new ArrayList());
        }
        if (string2 != null) {
            this.optionArgs.get(string).add(string2);
        }
    }

    public Set<String> getOptionNames() {
        return Collections.unmodifiableSet(this.optionArgs.keySet());
    }

    public boolean containsOption(String string) {
        return this.optionArgs.containsKey(string);
    }

    @Nullable
    public List<String> getOptionValues(String string) {
        return this.optionArgs.get(string);
    }

    public void addNonOptionArg(String string) {
        this.nonOptionArgs.add(string);
    }

    public List<String> getNonOptionArgs() {
        return Collections.unmodifiableList(this.nonOptionArgs);
    }
}

