/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.convert.support;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.springframework.core.CollectionFactory;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConditionalGenericConverter;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.convert.support.ConversionUtils;
import org.springframework.lang.Nullable;

final class CollectionToCollectionConverter
implements ConditionalGenericConverter {
    private final ConversionService conversionService;

    public CollectionToCollectionConverter(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    @Override
    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return Collections.singleton(new GenericConverter.ConvertiblePair(Collection.class, Collection.class));
    }

    @Override
    public boolean matches(TypeDescriptor typeDescriptor, TypeDescriptor typeDescriptor2) {
        return ConversionUtils.canConvertElements(typeDescriptor.getElementTypeDescriptor(), typeDescriptor2.getElementTypeDescriptor(), this.conversionService);
    }

    @Override
    @Nullable
    public Object convert(@Nullable Object object, TypeDescriptor typeDescriptor, TypeDescriptor typeDescriptor2) {
        boolean bl;
        if (object == null) {
            return null;
        }
        Collection collection = (Collection)object;
        boolean bl2 = bl = !typeDescriptor2.getType().isInstance(object);
        if (!bl && collection.isEmpty()) {
            return object;
        }
        TypeDescriptor typeDescriptor3 = typeDescriptor2.getElementTypeDescriptor();
        if (typeDescriptor3 == null && !bl) {
            return object;
        }
        Collection<Object> collection2 = CollectionFactory.createCollection(typeDescriptor2.getType(), typeDescriptor3 != null ? typeDescriptor3.getType() : null, collection.size());
        if (typeDescriptor3 == null) {
            collection2.addAll(collection);
        } else {
            for (Object e : collection) {
                Object object2 = this.conversionService.convert(e, typeDescriptor.elementTypeDescriptor(e), typeDescriptor3);
                collection2.add(object2);
                if (e == object2) continue;
                bl = true;
            }
        }
        return bl ? collection2 : object;
    }
}

