/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.convert.support;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConditionalGenericConverter;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.convert.support.ConversionUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

final class CollectionToArrayConverter
implements ConditionalGenericConverter {
    private final ConversionService conversionService;

    public CollectionToArrayConverter(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    @Override
    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return Collections.singleton(new GenericConverter.ConvertiblePair(Collection.class, Object[].class));
    }

    @Override
    public boolean matches(TypeDescriptor typeDescriptor, TypeDescriptor typeDescriptor2) {
        return ConversionUtils.canConvertElements(typeDescriptor.getElementTypeDescriptor(), typeDescriptor2.getElementTypeDescriptor(), this.conversionService);
    }

    @Override
    @Nullable
    public Object convert(@Nullable Object object, TypeDescriptor typeDescriptor, TypeDescriptor typeDescriptor2) {
        if (object == null) {
            return null;
        }
        Collection collection = (Collection)object;
        TypeDescriptor typeDescriptor3 = typeDescriptor2.getElementTypeDescriptor();
        Assert.state(typeDescriptor3 != null, "No target element type");
        Object object2 = Array.newInstance(typeDescriptor3.getType(), collection.size());
        int n = 0;
        for (Object e : collection) {
            Object object3 = this.conversionService.convert(e, typeDescriptor.elementTypeDescriptor(e), typeDescriptor3);
            Array.set(object2, n++, object3);
        }
        return object2;
    }
}

