/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.convert;

import org.springframework.core.convert.ConversionException;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.lang.Nullable;
import org.springframework.util.ObjectUtils;

public class ConversionFailedException
extends ConversionException {
    @Nullable
    private final TypeDescriptor sourceType;
    private final TypeDescriptor targetType;
    @Nullable
    private final Object value;

    public ConversionFailedException(@Nullable TypeDescriptor typeDescriptor, TypeDescriptor typeDescriptor2, @Nullable Object object, Throwable throwable) {
        super("Failed to convert from type [" + typeDescriptor + "] to type [" + typeDescriptor2 + "] for value '" + ObjectUtils.nullSafeToString(object) + "'", throwable);
        this.sourceType = typeDescriptor;
        this.targetType = typeDescriptor2;
        this.value = object;
    }

    @Nullable
    public TypeDescriptor getSourceType() {
        return this.sourceType;
    }

    public TypeDescriptor getTargetType() {
        return this.targetType;
    }

    @Nullable
    public Object getValue() {
        return this.value;
    }
}

