/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.codec;

import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.reactivestreams.Publisher;
import org.springframework.core.ResolvableType;
import org.springframework.core.codec.AbstractDataBufferDecoder;
import org.springframework.core.codec.Hints;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.core.io.buffer.LimitedDataBufferList;
import org.springframework.core.io.buffer.PooledDataBuffer;
import org.springframework.core.log.LogFormatUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.MimeType;
import org.springframework.util.MimeTypeUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class StringDecoder
extends AbstractDataBufferDecoder<String> {
    public static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    public static final List<String> DEFAULT_DELIMITERS = Arrays.asList("\r\n", "\n");
    private final List<String> delimiters;
    private final boolean stripDelimiter;
    private Charset defaultCharset = DEFAULT_CHARSET;
    private final ConcurrentMap<Charset, byte[][]> delimitersCache = new ConcurrentHashMap<Charset, byte[][]>();

    private StringDecoder(List<String> list, boolean bl, MimeType ... mimeTypeArray) {
        super(mimeTypeArray);
        Assert.notEmpty(list, "'delimiters' must not be empty");
        this.delimiters = new ArrayList<String>(list);
        this.stripDelimiter = bl;
    }

    public void setDefaultCharset(Charset charset) {
        this.defaultCharset = charset;
    }

    public Charset getDefaultCharset() {
        return this.defaultCharset;
    }

    @Override
    public boolean canDecode(ResolvableType resolvableType, @Nullable MimeType mimeType) {
        return resolvableType.resolve() == String.class && super.canDecode(resolvableType, mimeType);
    }

    @Override
    public Flux<String> decode(Publisher<DataBuffer> publisher, ResolvableType resolvableType, @Nullable MimeType mimeType, @Nullable Map<String, Object> map) {
        byte[][] byArray = this.getDelimiterBytes(mimeType);
        LimitedDataBufferList limitedDataBufferList = new LimitedDataBufferList(this.getMaxInMemorySize());
        DataBufferUtils.Matcher matcher = DataBufferUtils.matcher(byArray);
        return Flux.from(publisher).concatMapIterable(dataBuffer -> this.processDataBuffer((DataBuffer)dataBuffer, matcher, limitedDataBufferList)).concatWith((Publisher)Mono.defer(() -> {
            if (limitedDataBufferList.isEmpty()) {
                return Mono.empty();
            }
            DataBuffer dataBuffer = ((DataBuffer)limitedDataBufferList.get(0)).factory().join(limitedDataBufferList);
            limitedDataBufferList.clear();
            return Mono.just((Object)dataBuffer);
        })).doOnTerminate(limitedDataBufferList::releaseAndClear).doOnDiscard(PooledDataBuffer.class, PooledDataBuffer::release).map(dataBuffer -> this.decode((DataBuffer)dataBuffer, resolvableType, mimeType, (Map)map));
    }

    private byte[][] getDelimiterBytes(@Nullable MimeType mimeType) {
        return this.delimitersCache.computeIfAbsent(this.getCharset(mimeType), charset -> {
            byte[][] byArrayArray = new byte[this.delimiters.size()][];
            for (int i = 0; i < this.delimiters.size(); ++i) {
                byArrayArray[i] = this.delimiters.get(i).getBytes((Charset)charset);
            }
            return byArrayArray;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<DataBuffer> processDataBuffer(DataBuffer dataBuffer, DataBufferUtils.Matcher matcher, LimitedDataBufferList limitedDataBufferList) {
        try {
            ArrayList<DataBuffer> arrayList = null;
            do {
                int n;
                if ((n = matcher.match(dataBuffer)) == -1) {
                    limitedDataBufferList.add(dataBuffer);
                    DataBufferUtils.retain(dataBuffer);
                    break;
                }
                int n2 = dataBuffer.readPosition();
                int n3 = n - n2 + 1;
                DataBuffer dataBuffer2 = dataBuffer.retainedSlice(n2, n3);
                ArrayList<DataBuffer> arrayList2 = arrayList = arrayList != null ? arrayList : new ArrayList<DataBuffer>();
                if (limitedDataBufferList.isEmpty()) {
                    if (this.stripDelimiter) {
                        dataBuffer2.writePosition(dataBuffer2.writePosition() - matcher.delimiter().length);
                    }
                    arrayList.add(dataBuffer2);
                } else {
                    limitedDataBufferList.add(dataBuffer2);
                    DataBuffer dataBuffer3 = dataBuffer.factory().join(limitedDataBufferList);
                    if (this.stripDelimiter) {
                        dataBuffer3.writePosition(dataBuffer3.writePosition() - matcher.delimiter().length);
                    }
                    arrayList.add(dataBuffer3);
                    limitedDataBufferList.clear();
                }
                dataBuffer.readPosition(n + 1);
            } while (dataBuffer.readableByteCount() > 0);
            ArrayList<DataBuffer> arrayList3 = arrayList != null ? arrayList : Collections.emptyList();
            return arrayList3;
        }
        finally {
            DataBufferUtils.release(dataBuffer);
        }
    }

    @Override
    public String decode(DataBuffer dataBuffer, ResolvableType resolvableType, @Nullable MimeType mimeType, @Nullable Map<String, Object> map) {
        Charset charset = this.getCharset(mimeType);
        CharBuffer charBuffer = charset.decode(dataBuffer.asByteBuffer());
        DataBufferUtils.release(dataBuffer);
        String string = charBuffer.toString();
        LogFormatUtils.traceDebug(this.logger, bl -> {
            String string2 = LogFormatUtils.formatValue(string, bl == false);
            return Hints.getLogPrefix(map) + "Decoded " + string2;
        });
        return string;
    }

    private Charset getCharset(@Nullable MimeType mimeType) {
        if (mimeType != null && mimeType.getCharset() != null) {
            return mimeType.getCharset();
        }
        return this.getDefaultCharset();
    }

    @Deprecated
    public static StringDecoder textPlainOnly(boolean bl) {
        return StringDecoder.textPlainOnly();
    }

    public static StringDecoder textPlainOnly() {
        return StringDecoder.textPlainOnly(DEFAULT_DELIMITERS, true);
    }

    public static StringDecoder textPlainOnly(List<String> list, boolean bl) {
        return new StringDecoder(list, bl, new MimeType("text", "plain", DEFAULT_CHARSET));
    }

    @Deprecated
    public static StringDecoder allMimeTypes(boolean bl) {
        return StringDecoder.allMimeTypes();
    }

    public static StringDecoder allMimeTypes() {
        return StringDecoder.allMimeTypes(DEFAULT_DELIMITERS, true);
    }

    public static StringDecoder allMimeTypes(List<String> list, boolean bl) {
        return new StringDecoder(list, bl, new MimeType("text", "plain", DEFAULT_CHARSET), MimeTypeUtils.ALL);
    }
}

