/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.codec;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.OptionalLong;
import org.reactivestreams.Publisher;
import org.springframework.core.ResolvableType;
import org.springframework.core.codec.AbstractEncoder;
import org.springframework.core.codec.EncodingException;
import org.springframework.core.codec.Hints;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.core.io.support.ResourceRegion;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.MimeType;
import org.springframework.util.MimeTypeUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ResourceRegionEncoder
extends AbstractEncoder<ResourceRegion> {
    public static final int DEFAULT_BUFFER_SIZE = 4096;
    public static final String BOUNDARY_STRING_HINT = ResourceRegionEncoder.class.getName() + ".boundaryString";
    private final int bufferSize;

    public ResourceRegionEncoder() {
        this(4096);
    }

    public ResourceRegionEncoder(int n) {
        super(MimeTypeUtils.APPLICATION_OCTET_STREAM, MimeTypeUtils.ALL);
        Assert.isTrue(n > 0, "'bufferSize' must be larger than 0");
        this.bufferSize = n;
    }

    @Override
    public boolean canEncode(ResolvableType resolvableType, @Nullable MimeType mimeType) {
        return super.canEncode(resolvableType, mimeType) && ResourceRegion.class.isAssignableFrom(resolvableType.toClass());
    }

    @Override
    public Flux<DataBuffer> encode(Publisher<? extends ResourceRegion> publisher, DataBufferFactory dataBufferFactory, ResolvableType resolvableType, @Nullable MimeType mimeType, @Nullable Map<String, Object> map) {
        Assert.notNull(publisher, "'inputStream' must not be null");
        Assert.notNull((Object)dataBufferFactory, "'bufferFactory' must not be null");
        Assert.notNull((Object)resolvableType, "'elementType' must not be null");
        if (publisher instanceof Mono) {
            return Mono.from(publisher).flatMapMany(resourceRegion -> {
                if (!resourceRegion.getResource().isReadable()) {
                    return Flux.error((Throwable)new EncodingException("Resource " + resourceRegion.getResource() + " is not readable"));
                }
                return this.writeResourceRegion((ResourceRegion)resourceRegion, dataBufferFactory, map);
            });
        }
        String string = (String)Hints.getRequiredHint(map, BOUNDARY_STRING_HINT);
        byte[] byArray = this.toAsciiBytes("\r\n--" + string + "\r\n");
        byte[] byArray2 = mimeType != null ? this.toAsciiBytes("Content-Type: " + mimeType + "\r\n") : new byte[]{};
        return Flux.from(publisher).concatMap(resourceRegion -> {
            if (!resourceRegion.getResource().isReadable()) {
                return Flux.error((Throwable)new EncodingException("Resource " + resourceRegion.getResource() + " is not readable"));
            }
            Flux flux = Flux.just((Object[])new DataBuffer[]{dataBufferFactory.wrap(byArray), dataBufferFactory.wrap(byArray2), dataBufferFactory.wrap(this.getContentRangeHeader((ResourceRegion)resourceRegion))});
            return flux.concatWith(this.writeResourceRegion((ResourceRegion)resourceRegion, dataBufferFactory, map));
        }).concatWithValues((Object[])new DataBuffer[]{this.getRegionSuffix(dataBufferFactory, string)});
    }

    private Flux<DataBuffer> writeResourceRegion(ResourceRegion resourceRegion, DataBufferFactory dataBufferFactory, @Nullable Map<String, Object> map) {
        Resource resource = resourceRegion.getResource();
        long l = resourceRegion.getPosition();
        long l2 = resourceRegion.getCount();
        if (this.logger.isDebugEnabled() && !Hints.isLoggingSuppressed(map)) {
            this.logger.debug(Hints.getLogPrefix(map) + "Writing region " + l + "-" + (l + l2) + " of [" + resource + "]");
        }
        Flux<DataBuffer> flux = DataBufferUtils.read(resource, l, dataBufferFactory, this.bufferSize);
        return DataBufferUtils.takeUntilByteCount(flux, l2);
    }

    private DataBuffer getRegionSuffix(DataBufferFactory dataBufferFactory, String string) {
        byte[] byArray = this.toAsciiBytes("\r\n--" + string + "--");
        return dataBufferFactory.wrap(byArray);
    }

    private byte[] toAsciiBytes(String string) {
        return string.getBytes(StandardCharsets.US_ASCII);
    }

    private byte[] getContentRangeHeader(ResourceRegion resourceRegion) {
        long l = resourceRegion.getPosition();
        long l2 = l + resourceRegion.getCount() - 1L;
        OptionalLong optionalLong = this.contentLength(resourceRegion.getResource());
        if (optionalLong.isPresent()) {
            long l3 = optionalLong.getAsLong();
            return this.toAsciiBytes("Content-Range: bytes " + l + '-' + l2 + '/' + l3 + "\r\n\r\n");
        }
        return this.toAsciiBytes("Content-Range: bytes " + l + '-' + l2 + "\r\n\r\n");
    }

    private OptionalLong contentLength(Resource resource) {
        if (InputStreamResource.class != resource.getClass()) {
            try {
                return OptionalLong.of(resource.contentLength());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return OptionalLong.empty();
    }
}

