/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.codec;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.springframework.lang.Nullable;

public abstract class Hints {
    public static final String LOG_PREFIX_HINT = Log.class.getName() + ".PREFIX";
    public static final String SUPPRESS_LOGGING_HINT = Log.class.getName() + ".SUPPRESS_LOGGING";

    public static Map<String, Object> from(String string, Object object) {
        return Collections.singletonMap(string, object);
    }

    public static Map<String, Object> none() {
        return Collections.emptyMap();
    }

    public static <T> T getRequiredHint(@Nullable Map<String, Object> map, String string) {
        if (map == null) {
            throw new IllegalArgumentException("No hints map for required hint '" + string + "'");
        }
        Object object = map.get(string);
        if (object == null) {
            throw new IllegalArgumentException("Hints map must contain the hint '" + string + "'");
        }
        return (T)object;
    }

    public static String getLogPrefix(@Nullable Map<String, Object> map) {
        return map != null ? (String)map.getOrDefault(LOG_PREFIX_HINT, "") : "";
    }

    public static boolean isLoggingSuppressed(@Nullable Map<String, Object> map) {
        return map != null && (Boolean)map.getOrDefault(SUPPRESS_LOGGING_HINT, false) != false;
    }

    public static Map<String, Object> merge(Map<String, Object> map, Map<String, Object> map2) {
        if (map.isEmpty() && map2.isEmpty()) {
            return Collections.emptyMap();
        }
        if (map2.isEmpty()) {
            return map;
        }
        if (map.isEmpty()) {
            return map2;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>(map.size() + map2.size());
        hashMap.putAll(map);
        hashMap.putAll(map2);
        return hashMap;
    }

    public static Map<String, Object> merge(Map<String, Object> map, String string, Object object) {
        if (map.isEmpty()) {
            return Collections.singletonMap(string, object);
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>(map.size() + 1);
        hashMap.putAll(map);
        hashMap.put(string, object);
        return hashMap;
    }
}

