/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.codec;

import java.util.Map;
import org.reactivestreams.Publisher;
import org.springframework.core.ResolvableType;
import org.springframework.core.codec.AbstractEncoder;
import org.springframework.core.codec.Hints;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.MimeType;
import org.springframework.util.MimeTypeUtils;
import reactor.core.publisher.Flux;

public class DataBufferEncoder
extends AbstractEncoder<DataBuffer> {
    public DataBufferEncoder() {
        super(MimeTypeUtils.ALL);
    }

    @Override
    public boolean canEncode(ResolvableType resolvableType, @Nullable MimeType mimeType) {
        Class<?> clazz = resolvableType.toClass();
        return super.canEncode(resolvableType, mimeType) && DataBuffer.class.isAssignableFrom(clazz);
    }

    @Override
    public Flux<DataBuffer> encode(Publisher<? extends DataBuffer> publisher, DataBufferFactory dataBufferFactory, ResolvableType resolvableType, @Nullable MimeType mimeType, @Nullable Map<String, Object> map) {
        Flux flux = Flux.from(publisher);
        if (this.logger.isDebugEnabled() && !Hints.isLoggingSuppressed(map)) {
            flux = flux.doOnNext(dataBuffer -> this.logValue((DataBuffer)dataBuffer, map));
        }
        return flux;
    }

    @Override
    public DataBuffer encodeValue(DataBuffer dataBuffer, DataBufferFactory dataBufferFactory, ResolvableType resolvableType, @Nullable MimeType mimeType, @Nullable Map<String, Object> map) {
        if (this.logger.isDebugEnabled() && !Hints.isLoggingSuppressed(map)) {
            this.logValue(dataBuffer, map);
        }
        return dataBuffer;
    }

    private void logValue(DataBuffer dataBuffer, @Nullable Map<String, Object> map) {
        String string = Hints.getLogPrefix(map);
        this.logger.debug(string + "Writing " + dataBuffer.readableByteCount() + " bytes");
    }
}

