/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.codec;

import java.util.Map;
import org.reactivestreams.Publisher;
import org.springframework.core.ResolvableType;
import org.springframework.core.codec.AbstractEncoder;
import org.springframework.core.codec.Hints;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.MimeType;
import org.springframework.util.MimeTypeUtils;
import reactor.core.publisher.Flux;

public class ByteArrayEncoder
extends AbstractEncoder<byte[]> {
    public ByteArrayEncoder() {
        super(MimeTypeUtils.ALL);
    }

    @Override
    public boolean canEncode(ResolvableType resolvableType, @Nullable MimeType mimeType) {
        Class<?> clazz = resolvableType.toClass();
        return super.canEncode(resolvableType, mimeType) && byte[].class.isAssignableFrom(clazz);
    }

    @Override
    public Flux<DataBuffer> encode(Publisher<? extends byte[]> publisher, DataBufferFactory dataBufferFactory, ResolvableType resolvableType, @Nullable MimeType mimeType, @Nullable Map<String, Object> map) {
        return Flux.from(publisher).map(byArray -> this.encodeValue((byte[])byArray, dataBufferFactory, resolvableType, mimeType, map));
    }

    @Override
    public DataBuffer encodeValue(byte[] byArray, DataBufferFactory dataBufferFactory, ResolvableType resolvableType, @Nullable MimeType mimeType, @Nullable Map<String, Object> map) {
        DataBuffer dataBuffer = dataBufferFactory.wrap(byArray);
        if (this.logger.isDebugEnabled() && !Hints.isLoggingSuppressed(map)) {
            String string = Hints.getLogPrefix(map);
            this.logger.debug(string + "Writing " + dataBuffer.readableByteCount() + " bytes");
        }
        return dataBuffer;
    }
}

