/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.springframework.core.annotation.AnnotationFilter;
import org.springframework.core.annotation.AnnotationTypeMapping;
import org.springframework.core.annotation.AnnotationTypeMappings;
import org.springframework.core.annotation.AnnotationsProcessor;
import org.springframework.core.annotation.AnnotationsScanner;
import org.springframework.core.annotation.IntrospectionFailureLogger;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotationSelector;
import org.springframework.core.annotation.MergedAnnotationSelectors;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.core.annotation.RepeatableContainers;
import org.springframework.core.annotation.TypeMappedAnnotation;
import org.springframework.lang.Nullable;

final class TypeMappedAnnotations
implements MergedAnnotations {
    static final MergedAnnotations NONE = new TypeMappedAnnotations(null, new Annotation[0], RepeatableContainers.none(), AnnotationFilter.ALL);
    @Nullable
    private final Object source;
    @Nullable
    private final AnnotatedElement element;
    @Nullable
    private final MergedAnnotations.SearchStrategy searchStrategy;
    @Nullable
    private final Annotation[] annotations;
    private final RepeatableContainers repeatableContainers;
    private final AnnotationFilter annotationFilter;
    @Nullable
    private volatile List<Aggregate> aggregates;

    private TypeMappedAnnotations(AnnotatedElement annotatedElement, MergedAnnotations.SearchStrategy searchStrategy, RepeatableContainers repeatableContainers, AnnotationFilter annotationFilter) {
        this.source = annotatedElement;
        this.element = annotatedElement;
        this.searchStrategy = searchStrategy;
        this.annotations = null;
        this.repeatableContainers = repeatableContainers;
        this.annotationFilter = annotationFilter;
    }

    private TypeMappedAnnotations(@Nullable Object object, Annotation[] annotationArray, RepeatableContainers repeatableContainers, AnnotationFilter annotationFilter) {
        this.source = object;
        this.element = null;
        this.searchStrategy = null;
        this.annotations = annotationArray;
        this.repeatableContainers = repeatableContainers;
        this.annotationFilter = annotationFilter;
    }

    @Override
    public <A extends Annotation> boolean isPresent(Class<A> clazz) {
        if (this.annotationFilter.matches(clazz)) {
            return false;
        }
        return Boolean.TRUE.equals(this.scan(clazz, IsPresent.get(this.repeatableContainers, this.annotationFilter, false)));
    }

    @Override
    public boolean isPresent(String string) {
        if (this.annotationFilter.matches(string)) {
            return false;
        }
        return Boolean.TRUE.equals(this.scan(string, IsPresent.get(this.repeatableContainers, this.annotationFilter, false)));
    }

    @Override
    public <A extends Annotation> boolean isDirectlyPresent(Class<A> clazz) {
        if (this.annotationFilter.matches(clazz)) {
            return false;
        }
        return Boolean.TRUE.equals(this.scan(clazz, IsPresent.get(this.repeatableContainers, this.annotationFilter, true)));
    }

    @Override
    public boolean isDirectlyPresent(String string) {
        if (this.annotationFilter.matches(string)) {
            return false;
        }
        return Boolean.TRUE.equals(this.scan(string, IsPresent.get(this.repeatableContainers, this.annotationFilter, true)));
    }

    @Override
    public <A extends Annotation> MergedAnnotation<A> get(Class<A> clazz) {
        return this.get(clazz, null, null);
    }

    @Override
    public <A extends Annotation> MergedAnnotation<A> get(Class<A> clazz, @Nullable Predicate<? super MergedAnnotation<A>> predicate) {
        return this.get(clazz, predicate, null);
    }

    @Override
    public <A extends Annotation> MergedAnnotation<A> get(Class<A> clazz, @Nullable Predicate<? super MergedAnnotation<A>> predicate, @Nullable MergedAnnotationSelector<A> mergedAnnotationSelector) {
        if (this.annotationFilter.matches(clazz)) {
            return MergedAnnotation.missing();
        }
        MergedAnnotation mergedAnnotation = (MergedAnnotation)this.scan(clazz, new MergedAnnotationFinder<A>(clazz, predicate, mergedAnnotationSelector));
        return mergedAnnotation != null ? mergedAnnotation : MergedAnnotation.missing();
    }

    @Override
    public <A extends Annotation> MergedAnnotation<A> get(String string) {
        return this.get(string, null, null);
    }

    @Override
    public <A extends Annotation> MergedAnnotation<A> get(String string, @Nullable Predicate<? super MergedAnnotation<A>> predicate) {
        return this.get(string, predicate, null);
    }

    @Override
    public <A extends Annotation> MergedAnnotation<A> get(String string, @Nullable Predicate<? super MergedAnnotation<A>> predicate, @Nullable MergedAnnotationSelector<A> mergedAnnotationSelector) {
        if (this.annotationFilter.matches(string)) {
            return MergedAnnotation.missing();
        }
        MergedAnnotation mergedAnnotation = (MergedAnnotation)this.scan(string, new MergedAnnotationFinder<A>(string, predicate, mergedAnnotationSelector));
        return mergedAnnotation != null ? mergedAnnotation : MergedAnnotation.missing();
    }

    @Override
    public <A extends Annotation> Stream<MergedAnnotation<A>> stream(Class<A> clazz) {
        if (this.annotationFilter == AnnotationFilter.ALL) {
            return Stream.empty();
        }
        return StreamSupport.stream(this.spliterator(clazz), false);
    }

    @Override
    public <A extends Annotation> Stream<MergedAnnotation<A>> stream(String string) {
        if (this.annotationFilter == AnnotationFilter.ALL) {
            return Stream.empty();
        }
        return StreamSupport.stream(this.spliterator(string), false);
    }

    @Override
    public Stream<MergedAnnotation<Annotation>> stream() {
        if (this.annotationFilter == AnnotationFilter.ALL) {
            return Stream.empty();
        }
        return StreamSupport.stream(this.spliterator(), false);
    }

    @Override
    public Iterator<MergedAnnotation<Annotation>> iterator() {
        if (this.annotationFilter == AnnotationFilter.ALL) {
            return Collections.emptyIterator();
        }
        return Spliterators.iterator(this.spliterator());
    }

    @Override
    public Spliterator<MergedAnnotation<Annotation>> spliterator() {
        if (this.annotationFilter == AnnotationFilter.ALL) {
            return Spliterators.emptySpliterator();
        }
        return this.spliterator(null);
    }

    private <A extends Annotation> Spliterator<MergedAnnotation<A>> spliterator(@Nullable Object object) {
        return new AggregatesSpliterator(object, this.getAggregates());
    }

    private List<Aggregate> getAggregates() {
        List<Aggregate> list = this.aggregates;
        if (list == null) {
            list = this.scan(this, new AggregatesCollector());
            if (list == null || list.isEmpty()) {
                list = Collections.emptyList();
            }
            this.aggregates = list;
        }
        return list;
    }

    @Nullable
    private <C, R> R scan(C c, AnnotationsProcessor<C, R> annotationsProcessor) {
        if (this.annotations != null) {
            R r = annotationsProcessor.doWithAnnotations(c, 0, this.source, this.annotations);
            return annotationsProcessor.finish(r);
        }
        if (this.element != null && this.searchStrategy != null) {
            return AnnotationsScanner.scan(c, this.element, this.searchStrategy, annotationsProcessor);
        }
        return null;
    }

    static MergedAnnotations from(AnnotatedElement annotatedElement, MergedAnnotations.SearchStrategy searchStrategy, RepeatableContainers repeatableContainers, AnnotationFilter annotationFilter) {
        if (AnnotationsScanner.isKnownEmpty(annotatedElement, searchStrategy)) {
            return NONE;
        }
        return new TypeMappedAnnotations(annotatedElement, searchStrategy, repeatableContainers, annotationFilter);
    }

    static MergedAnnotations from(@Nullable Object object, Annotation[] annotationArray, RepeatableContainers repeatableContainers, AnnotationFilter annotationFilter) {
        if (annotationArray.length == 0) {
            return NONE;
        }
        return new TypeMappedAnnotations(object, annotationArray, repeatableContainers, annotationFilter);
    }

    private static boolean isMappingForType(AnnotationTypeMapping annotationTypeMapping, AnnotationFilter annotationFilter, @Nullable Object object) {
        Class<? extends Annotation> clazz = annotationTypeMapping.getAnnotationType();
        return !annotationFilter.matches(clazz) && (object == null || clazz == object || clazz.getName().equals(object));
    }

    private class AggregatesSpliterator<A extends Annotation>
    implements Spliterator<MergedAnnotation<A>> {
        @Nullable
        private final Object requiredType;
        private final List<Aggregate> aggregates;
        private int aggregateCursor;
        @Nullable
        private int[] mappingCursors;

        AggregatesSpliterator(@Nullable Object object, List<Aggregate> list) {
            this.requiredType = object;
            this.aggregates = list;
            this.aggregateCursor = 0;
        }

        @Override
        public boolean tryAdvance(Consumer<? super MergedAnnotation<A>> consumer) {
            while (this.aggregateCursor < this.aggregates.size()) {
                Aggregate aggregate = this.aggregates.get(this.aggregateCursor);
                if (this.tryAdvance(aggregate, consumer)) {
                    return true;
                }
                ++this.aggregateCursor;
                this.mappingCursors = null;
            }
            return false;
        }

        private boolean tryAdvance(Aggregate aggregate, Consumer<? super MergedAnnotation<A>> consumer) {
            if (this.mappingCursors == null) {
                this.mappingCursors = new int[aggregate.size()];
            }
            int n = Integer.MAX_VALUE;
            int n2 = -1;
            for (int i = 0; i < aggregate.size(); ++i) {
                AnnotationTypeMapping annotationTypeMapping = this.getNextSuitableMapping(aggregate, i);
                if (annotationTypeMapping != null && annotationTypeMapping.getDistance() < n) {
                    n2 = i;
                    n = annotationTypeMapping.getDistance();
                }
                if (n == 0) break;
            }
            if (n2 != -1) {
                MergedAnnotation mergedAnnotation = aggregate.createMergedAnnotationIfPossible(n2, this.mappingCursors[n2], this.requiredType != null ? IntrospectionFailureLogger.INFO : IntrospectionFailureLogger.DEBUG);
                int n3 = n2;
                this.mappingCursors[n3] = this.mappingCursors[n3] + 1;
                if (mergedAnnotation == null) {
                    return this.tryAdvance(aggregate, consumer);
                }
                consumer.accept(mergedAnnotation);
                return true;
            }
            return false;
        }

        @Nullable
        private AnnotationTypeMapping getNextSuitableMapping(Aggregate aggregate, int n) {
            int[] nArray = this.mappingCursors;
            if (nArray != null) {
                AnnotationTypeMapping annotationTypeMapping;
                do {
                    if ((annotationTypeMapping = aggregate.getMapping(n, nArray[n])) != null && TypeMappedAnnotations.isMappingForType(annotationTypeMapping, TypeMappedAnnotations.this.annotationFilter, this.requiredType)) {
                        return annotationTypeMapping;
                    }
                    int n2 = n;
                    nArray[n2] = nArray[n2] + 1;
                } while (annotationTypeMapping != null);
            }
            return null;
        }

        @Override
        @Nullable
        public Spliterator<MergedAnnotation<A>> trySplit() {
            return null;
        }

        @Override
        public long estimateSize() {
            int n = 0;
            for (int i = this.aggregateCursor; i < this.aggregates.size(); ++i) {
                Aggregate aggregate = this.aggregates.get(i);
                for (int j = 0; j < aggregate.size(); ++j) {
                    AnnotationTypeMappings annotationTypeMappings = aggregate.getMappings(j);
                    int n2 = annotationTypeMappings.size();
                    if (i == this.aggregateCursor && this.mappingCursors != null) {
                        n2 -= Math.min(this.mappingCursors[j], annotationTypeMappings.size());
                    }
                    n += n2;
                }
            }
            return n;
        }

        @Override
        public int characteristics() {
            return 1280;
        }
    }

    private static class Aggregate {
        private final int aggregateIndex;
        @Nullable
        private final Object source;
        private final List<Annotation> annotations;
        private final AnnotationTypeMappings[] mappings;

        Aggregate(int n, @Nullable Object object, List<Annotation> list) {
            this.aggregateIndex = n;
            this.source = object;
            this.annotations = list;
            this.mappings = new AnnotationTypeMappings[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                this.mappings[i] = AnnotationTypeMappings.forAnnotationType(list.get(i).annotationType());
            }
        }

        int size() {
            return this.annotations.size();
        }

        @Nullable
        AnnotationTypeMapping getMapping(int n, int n2) {
            AnnotationTypeMappings annotationTypeMappings = this.getMappings(n);
            return n2 < annotationTypeMappings.size() ? annotationTypeMappings.get(n2) : null;
        }

        AnnotationTypeMappings getMappings(int n) {
            return this.mappings[n];
        }

        @Nullable
        <A extends Annotation> MergedAnnotation<A> createMergedAnnotationIfPossible(int n, int n2, IntrospectionFailureLogger introspectionFailureLogger) {
            return TypeMappedAnnotation.createIfPossible(this.mappings[n].get(n2), this.source, this.annotations.get(n), this.aggregateIndex, introspectionFailureLogger);
        }
    }

    private class AggregatesCollector
    implements AnnotationsProcessor<Object, List<Aggregate>> {
        private final List<Aggregate> aggregates = new ArrayList<Aggregate>();

        private AggregatesCollector() {
        }

        @Override
        @Nullable
        public List<Aggregate> doWithAnnotations(Object object, int n, @Nullable Object object2, Annotation[] annotationArray) {
            this.aggregates.add(this.createAggregate(n, object2, annotationArray));
            return null;
        }

        private Aggregate createAggregate(int n, @Nullable Object object, Annotation[] annotationArray) {
            List<Annotation> list = this.getAggregateAnnotations(annotationArray);
            return new Aggregate(n, object, list);
        }

        private List<Annotation> getAggregateAnnotations(Annotation[] annotationArray) {
            ArrayList<Annotation> arrayList = new ArrayList<Annotation>(annotationArray.length);
            this.addAggregateAnnotations(arrayList, annotationArray);
            return arrayList;
        }

        private void addAggregateAnnotations(List<Annotation> list, Annotation[] annotationArray) {
            for (Annotation annotation : annotationArray) {
                if (annotation == null || TypeMappedAnnotations.this.annotationFilter.matches(annotation)) continue;
                Annotation[] annotationArray2 = TypeMappedAnnotations.this.repeatableContainers.findRepeatedAnnotations(annotation);
                if (annotationArray2 != null) {
                    this.addAggregateAnnotations(list, annotationArray2);
                    continue;
                }
                list.add(annotation);
            }
        }

        @Override
        public List<Aggregate> finish(@Nullable List<Aggregate> list) {
            return this.aggregates;
        }
    }

    private class MergedAnnotationFinder<A extends Annotation>
    implements AnnotationsProcessor<Object, MergedAnnotation<A>> {
        private final Object requiredType;
        @Nullable
        private final Predicate<? super MergedAnnotation<A>> predicate;
        private final MergedAnnotationSelector<A> selector;
        @Nullable
        private MergedAnnotation<A> result;

        MergedAnnotationFinder(Object object, @Nullable Predicate<? super MergedAnnotation<A>> predicate, @Nullable MergedAnnotationSelector<A> mergedAnnotationSelector) {
            this.requiredType = object;
            this.predicate = predicate;
            this.selector = mergedAnnotationSelector != null ? mergedAnnotationSelector : MergedAnnotationSelectors.nearest();
        }

        @Override
        @Nullable
        public MergedAnnotation<A> doWithAggregate(Object object, int n) {
            return this.result;
        }

        @Override
        @Nullable
        public MergedAnnotation<A> doWithAnnotations(Object object, int n, @Nullable Object object2, Annotation[] annotationArray) {
            for (Annotation annotation : annotationArray) {
                MergedAnnotation<A> mergedAnnotation;
                if (annotation == null || TypeMappedAnnotations.this.annotationFilter.matches(annotation) || (mergedAnnotation = this.process(object, n, object2, annotation)) == null) continue;
                return mergedAnnotation;
            }
            return null;
        }

        @Nullable
        private MergedAnnotation<A> process(Object object, int n, @Nullable Object object2, Annotation annotation) {
            Annotation[] annotationArray = TypeMappedAnnotations.this.repeatableContainers.findRepeatedAnnotations(annotation);
            if (annotationArray != null) {
                return this.doWithAnnotations(object, n, object2, annotationArray);
            }
            AnnotationTypeMappings annotationTypeMappings = AnnotationTypeMappings.forAnnotationType(annotation.annotationType(), TypeMappedAnnotations.this.repeatableContainers, TypeMappedAnnotations.this.annotationFilter);
            for (int i = 0; i < annotationTypeMappings.size(); ++i) {
                TypeMappedAnnotation typeMappedAnnotation;
                AnnotationTypeMapping annotationTypeMapping = annotationTypeMappings.get(i);
                if (!TypeMappedAnnotations.isMappingForType(annotationTypeMapping, TypeMappedAnnotations.this.annotationFilter, this.requiredType) || (typeMappedAnnotation = TypeMappedAnnotation.createIfPossible(annotationTypeMapping, object2, annotation, n, IntrospectionFailureLogger.INFO)) == null || this.predicate != null && !this.predicate.test(typeMappedAnnotation)) continue;
                if (this.selector.isBestCandidate(typeMappedAnnotation)) {
                    return typeMappedAnnotation;
                }
                this.updateLastResult(typeMappedAnnotation);
            }
            return null;
        }

        private void updateLastResult(MergedAnnotation<A> mergedAnnotation) {
            MergedAnnotation<A> mergedAnnotation2 = this.result;
            this.result = mergedAnnotation2 != null ? this.selector.select(mergedAnnotation2, mergedAnnotation) : mergedAnnotation;
        }

        @Override
        @Nullable
        public MergedAnnotation<A> finish(@Nullable MergedAnnotation<A> mergedAnnotation) {
            return mergedAnnotation != null ? mergedAnnotation : this.result;
        }
    }

    private static final class IsPresent
    implements AnnotationsProcessor<Object, Boolean> {
        private static final IsPresent[] SHARED = new IsPresent[4];
        private final RepeatableContainers repeatableContainers;
        private final AnnotationFilter annotationFilter;
        private final boolean directOnly;

        private IsPresent(RepeatableContainers repeatableContainers, AnnotationFilter annotationFilter, boolean bl) {
            this.repeatableContainers = repeatableContainers;
            this.annotationFilter = annotationFilter;
            this.directOnly = bl;
        }

        @Override
        @Nullable
        public Boolean doWithAnnotations(Object object, int n, @Nullable Object object2, Annotation[] annotationArray) {
            for (Annotation annotation : annotationArray) {
                Object object3;
                Class<? extends Annotation> clazz;
                if (annotation == null || (clazz = annotation.annotationType()) == null || this.annotationFilter.matches(clazz)) continue;
                if (clazz == object || clazz.getName().equals(object)) {
                    return Boolean.TRUE;
                }
                Annotation[] annotationArray2 = this.repeatableContainers.findRepeatedAnnotations(annotation);
                if (annotationArray2 != null && (object3 = this.doWithAnnotations(object, n, object2, annotationArray2)) != null) {
                    return object3;
                }
                if (this.directOnly) continue;
                object3 = AnnotationTypeMappings.forAnnotationType(clazz);
                for (int i = 0; i < ((AnnotationTypeMappings)object3).size(); ++i) {
                    AnnotationTypeMapping annotationTypeMapping = ((AnnotationTypeMappings)object3).get(i);
                    if (!TypeMappedAnnotations.isMappingForType(annotationTypeMapping, this.annotationFilter, object)) continue;
                    return Boolean.TRUE;
                }
            }
            return null;
        }

        static IsPresent get(RepeatableContainers repeatableContainers, AnnotationFilter annotationFilter, boolean bl) {
            if (annotationFilter == AnnotationFilter.PLAIN) {
                if (repeatableContainers == RepeatableContainers.none()) {
                    return SHARED[bl ? 0 : 1];
                }
                if (repeatableContainers == RepeatableContainers.standardRepeatables()) {
                    return SHARED[bl ? 2 : 3];
                }
            }
            return new IsPresent(repeatableContainers, annotationFilter, bl);
        }

        static {
            IsPresent.SHARED[0] = new IsPresent(RepeatableContainers.none(), AnnotationFilter.PLAIN, true);
            IsPresent.SHARED[1] = new IsPresent(RepeatableContainers.none(), AnnotationFilter.PLAIN, false);
            IsPresent.SHARED[2] = new IsPresent(RepeatableContainers.standardRepeatables(), AnnotationFilter.PLAIN, true);
            IsPresent.SHARED[3] = new IsPresent(RepeatableContainers.standardRepeatables(), AnnotationFilter.PLAIN, false);
        }
    }
}

