/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import org.springframework.core.annotation.AbstractMergedAnnotation;
import org.springframework.core.annotation.AnnotationTypeMapping;
import org.springframework.core.annotation.AnnotationTypeMappings;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.annotation.AttributeMethods;
import org.springframework.core.annotation.IntrospectionFailureLogger;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.SynthesizedAnnotation;
import org.springframework.core.annotation.SynthesizedMergedAnnotationInvocationHandler;
import org.springframework.core.annotation.ValueExtractor;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

final class TypeMappedAnnotation<A extends Annotation>
extends AbstractMergedAnnotation<A> {
    private static final Map<Class<?>, Object> EMPTY_ARRAYS;
    private final AnnotationTypeMapping mapping;
    @Nullable
    private final ClassLoader classLoader;
    @Nullable
    private final Object source;
    @Nullable
    private final Object rootAttributes;
    private final ValueExtractor valueExtractor;
    private final int aggregateIndex;
    private final boolean useMergedValues;
    @Nullable
    private final Predicate<String> attributeFilter;
    private final int[] resolvedRootMirrors;
    private final int[] resolvedMirrors;

    private TypeMappedAnnotation(AnnotationTypeMapping annotationTypeMapping, @Nullable ClassLoader classLoader, @Nullable Object object, @Nullable Object object2, ValueExtractor valueExtractor, int n) {
        this(annotationTypeMapping, classLoader, object, object2, valueExtractor, n, null);
    }

    private TypeMappedAnnotation(AnnotationTypeMapping annotationTypeMapping, @Nullable ClassLoader classLoader, @Nullable Object object, @Nullable Object object2, ValueExtractor valueExtractor, int n, @Nullable int[] nArray) {
        this.mapping = annotationTypeMapping;
        this.classLoader = classLoader;
        this.source = object;
        this.rootAttributes = object2;
        this.valueExtractor = valueExtractor;
        this.aggregateIndex = n;
        this.useMergedValues = true;
        this.attributeFilter = null;
        this.resolvedRootMirrors = nArray != null ? nArray : annotationTypeMapping.getRoot().getMirrorSets().resolve(object, object2, this.valueExtractor);
        this.resolvedMirrors = this.getDistance() == 0 ? this.resolvedRootMirrors : annotationTypeMapping.getMirrorSets().resolve(object, this, this::getValueForMirrorResolution);
    }

    private TypeMappedAnnotation(AnnotationTypeMapping annotationTypeMapping, @Nullable ClassLoader classLoader, @Nullable Object object, @Nullable Object object2, ValueExtractor valueExtractor, int n, boolean bl, @Nullable Predicate<String> predicate, int[] nArray, int[] nArray2) {
        this.classLoader = classLoader;
        this.source = object;
        this.rootAttributes = object2;
        this.valueExtractor = valueExtractor;
        this.mapping = annotationTypeMapping;
        this.aggregateIndex = n;
        this.useMergedValues = bl;
        this.attributeFilter = predicate;
        this.resolvedRootMirrors = nArray;
        this.resolvedMirrors = nArray2;
    }

    @Override
    public Class<A> getType() {
        return this.mapping.getAnnotationType();
    }

    @Override
    public List<Class<? extends Annotation>> getMetaTypes() {
        return this.mapping.getMetaTypes();
    }

    @Override
    public boolean isPresent() {
        return true;
    }

    @Override
    public int getDistance() {
        return this.mapping.getDistance();
    }

    @Override
    public int getAggregateIndex() {
        return this.aggregateIndex;
    }

    @Override
    @Nullable
    public Object getSource() {
        return this.source;
    }

    @Override
    @Nullable
    public MergedAnnotation<?> getMetaSource() {
        AnnotationTypeMapping annotationTypeMapping = this.mapping.getSource();
        if (annotationTypeMapping == null) {
            return null;
        }
        return new TypeMappedAnnotation<A>(annotationTypeMapping, this.classLoader, this.source, this.rootAttributes, this.valueExtractor, this.aggregateIndex, this.resolvedRootMirrors);
    }

    @Override
    public MergedAnnotation<?> getRoot() {
        if (this.getDistance() == 0) {
            return this;
        }
        AnnotationTypeMapping annotationTypeMapping = this.mapping.getRoot();
        return new TypeMappedAnnotation<A>(annotationTypeMapping, this.classLoader, this.source, this.rootAttributes, this.valueExtractor, this.aggregateIndex, this.resolvedRootMirrors);
    }

    @Override
    public boolean hasDefaultValue(String string) {
        int n = this.getAttributeIndex(string, true);
        Object object = this.getValue(n, true, false);
        return object == null || this.mapping.isEquivalentToDefaultValue(n, object, this.valueExtractor);
    }

    @Override
    public <T extends Annotation> MergedAnnotation<T> getAnnotation(String string, Class<T> clazz) throws NoSuchElementException {
        int n = this.getAttributeIndex(string, true);
        Method method = this.mapping.getAttributes().get(n);
        Assert.notNull(clazz, "Type must not be null");
        Assert.isAssignable(clazz, method.getReturnType(), () -> "Attribute " + string + " type mismatch:");
        return (MergedAnnotation)this.getRequiredValue(n, string);
    }

    @Override
    public <T extends Annotation> MergedAnnotation<T>[] getAnnotationArray(String string, Class<T> clazz) throws NoSuchElementException {
        int n = this.getAttributeIndex(string, true);
        Method method = this.mapping.getAttributes().get(n);
        Class<?> clazz2 = method.getReturnType().getComponentType();
        Assert.notNull(clazz, "Type must not be null");
        Assert.notNull(clazz2, () -> "Attribute " + string + " is not an array");
        Assert.isAssignable(clazz, clazz2, () -> "Attribute " + string + " component type mismatch:");
        return (MergedAnnotation[])this.getRequiredValue(n, string);
    }

    @Override
    public <T> Optional<T> getDefaultValue(String string, Class<T> clazz) {
        int n = this.getAttributeIndex(string, false);
        if (n == -1) {
            return Optional.empty();
        }
        Method method = this.mapping.getAttributes().get(n);
        return Optional.ofNullable(this.adapt(method, method.getDefaultValue(), clazz));
    }

    @Override
    public MergedAnnotation<A> filterAttributes(Predicate<String> predicate) {
        if (this.attributeFilter != null) {
            predicate = this.attributeFilter.and(predicate);
        }
        return new TypeMappedAnnotation<A>(this.mapping, this.classLoader, this.source, this.rootAttributes, this.valueExtractor, this.aggregateIndex, this.useMergedValues, predicate, this.resolvedRootMirrors, this.resolvedMirrors);
    }

    @Override
    public MergedAnnotation<A> withNonMergedAttributes() {
        return new TypeMappedAnnotation<A>(this.mapping, this.classLoader, this.source, this.rootAttributes, this.valueExtractor, this.aggregateIndex, false, this.attributeFilter, this.resolvedRootMirrors, this.resolvedMirrors);
    }

    @Override
    public Map<String, Object> asMap(MergedAnnotation.Adapt ... adaptArray) {
        return Collections.unmodifiableMap(this.asMap((MergedAnnotation<?> mergedAnnotation) -> new LinkedHashMap(), adaptArray));
    }

    @Override
    public <T extends Map<String, Object>> T asMap(Function<MergedAnnotation<?>, T> function, MergedAnnotation.Adapt ... adaptArray) {
        Map map = (Map)function.apply(this);
        Assert.state(map != null, "Factory used to create MergedAnnotation Map must not return null");
        AttributeMethods attributeMethods = this.mapping.getAttributes();
        for (int i = 0; i < attributeMethods.size(); ++i) {
            Object var7_7;
            Method method = attributeMethods.get(i);
            Object v0 = var7_7 = this.isFiltered(method.getName()) ? null : this.getValue(i, this.getTypeForMapOptions(method, adaptArray));
            if (var7_7 == null) continue;
            map.put(method.getName(), this.adaptValueForMapOptions(method, var7_7, map.getClass(), function, adaptArray));
        }
        return (T)map;
    }

    private Class<?> getTypeForMapOptions(Method method, MergedAnnotation.Adapt[] adaptArray) {
        Class<?> clazz;
        Class<?> clazz2 = method.getReturnType();
        Class<?> clazz3 = clazz = clazz2.isArray() ? clazz2.getComponentType() : clazz2;
        if (MergedAnnotation.Adapt.CLASS_TO_STRING.isIn(adaptArray) && clazz == Class.class) {
            return clazz2.isArray() ? String[].class : String.class;
        }
        return Object.class;
    }

    private <T extends Map<String, Object>> Object adaptValueForMapOptions(Method method, Object object, Class<?> clazz, Function<MergedAnnotation<?>, T> function, MergedAnnotation.Adapt[] adaptArray) {
        if (object instanceof MergedAnnotation) {
            MergedAnnotation mergedAnnotation = (MergedAnnotation)object;
            return MergedAnnotation.Adapt.ANNOTATION_TO_MAP.isIn(adaptArray) ? mergedAnnotation.asMap(function, adaptArray) : mergedAnnotation.synthesize();
        }
        if (object instanceof MergedAnnotation[]) {
            MergedAnnotation[] mergedAnnotationArray = (MergedAnnotation[])object;
            if (MergedAnnotation.Adapt.ANNOTATION_TO_MAP.isIn(adaptArray)) {
                Object object2 = Array.newInstance(clazz, mergedAnnotationArray.length);
                for (int i = 0; i < mergedAnnotationArray.length; ++i) {
                    Array.set(object2, i, mergedAnnotationArray[i].asMap(function, adaptArray));
                }
                return object2;
            }
            Object object3 = Array.newInstance(method.getReturnType().getComponentType(), mergedAnnotationArray.length);
            for (int i = 0; i < mergedAnnotationArray.length; ++i) {
                Array.set(object3, i, mergedAnnotationArray[i].synthesize());
            }
            return object3;
        }
        return object;
    }

    @Override
    protected A createSynthesized() {
        if (this.getType().isInstance(this.rootAttributes) && !this.isSynthesizable()) {
            return (A)((Annotation)this.rootAttributes);
        }
        return SynthesizedMergedAnnotationInvocationHandler.createProxy(this, this.getType());
    }

    private boolean isSynthesizable() {
        if (this.rootAttributes instanceof SynthesizedAnnotation) {
            return false;
        }
        return this.mapping.isSynthesizable();
    }

    @Override
    @Nullable
    protected <T> T getAttributeValue(String string, Class<T> clazz) {
        int n = this.getAttributeIndex(string, false);
        return n != -1 ? (T)this.getValue(n, clazz) : null;
    }

    private Object getRequiredValue(int n, String string) {
        Object object = this.getValue(n, Object.class);
        if (object == null) {
            throw new NoSuchElementException("No element at attribute index " + n + " for name " + string);
        }
        return object;
    }

    @Nullable
    private <T> T getValue(int n, Class<T> clazz) {
        Method method = this.mapping.getAttributes().get(n);
        Object object = this.getValue(n, true, false);
        if (object == null) {
            object = method.getDefaultValue();
        }
        return this.adapt(method, object, clazz);
    }

    @Nullable
    private Object getValue(int n, boolean bl, boolean bl2) {
        AnnotationTypeMapping annotationTypeMapping = this.mapping;
        if (this.useMergedValues) {
            int n2 = this.mapping.getAliasMapping(n);
            if (n2 == -1 && bl) {
                n2 = this.mapping.getConventionMapping(n);
            }
            if (n2 != -1) {
                annotationTypeMapping = annotationTypeMapping.getRoot();
                n = n2;
            }
        }
        if (!bl2) {
            n = (annotationTypeMapping.getDistance() != 0 ? this.resolvedMirrors : this.resolvedRootMirrors)[n];
        }
        if (n == -1) {
            return null;
        }
        if (annotationTypeMapping.getDistance() == 0) {
            Method method = annotationTypeMapping.getAttributes().get(n);
            Object object = this.valueExtractor.extract(method, this.rootAttributes);
            return object != null ? object : method.getDefaultValue();
        }
        return this.getValueFromMetaAnnotation(n, bl2);
    }

    @Nullable
    private Object getValueFromMetaAnnotation(int n, boolean bl) {
        Object object = null;
        if (this.useMergedValues || bl) {
            object = this.mapping.getMappedAnnotationValue(n, bl);
        }
        if (object == null) {
            Method method = this.mapping.getAttributes().get(n);
            object = ReflectionUtils.invokeMethod(method, this.mapping.getAnnotation());
        }
        return object;
    }

    @Nullable
    private Object getValueForMirrorResolution(Method method, Object object) {
        int n = this.mapping.getAttributes().indexOf(method);
        boolean bl = "value".equals(method.getName());
        return this.getValue(n, !bl, true);
    }

    @Nullable
    private <T> T adapt(Method method, @Nullable Object object, Class<T> clazz) {
        if (object == null) {
            return null;
        }
        object = this.adaptForAttribute(method, object);
        clazz = this.getAdaptType(method, clazz);
        if (object instanceof Class && clazz == String.class) {
            object = ((Class)object).getName();
        } else if (object instanceof String && clazz == Class.class) {
            object = ClassUtils.resolveClassName((String)object, this.getClassLoader());
        } else if (object instanceof Class[] && clazz == String[].class) {
            Class[] classArray = (Class[])object;
            String[] stringArray = new String[classArray.length];
            for (int i = 0; i < classArray.length; ++i) {
                stringArray[i] = classArray[i].getName();
            }
            object = stringArray;
        } else if (object instanceof String[] && clazz == Class[].class) {
            String[] stringArray = (String[])object;
            Class[] classArray = new Class[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                classArray[i] = ClassUtils.resolveClassName(stringArray[i], this.getClassLoader());
            }
            object = classArray;
        } else if (object instanceof MergedAnnotation && clazz.isAnnotation()) {
            MergedAnnotation mergedAnnotation = (MergedAnnotation)object;
            object = mergedAnnotation.synthesize();
        } else if (object instanceof MergedAnnotation[] && clazz.isArray() && clazz.getComponentType().isAnnotation()) {
            MergedAnnotation[] mergedAnnotationArray = (MergedAnnotation[])object;
            Object object2 = Array.newInstance(clazz.getComponentType(), mergedAnnotationArray.length);
            for (int i = 0; i < mergedAnnotationArray.length; ++i) {
                Array.set(object2, i, mergedAnnotationArray[i].synthesize());
            }
            object = object2;
        }
        if (!clazz.isInstance(object)) {
            throw new IllegalArgumentException("Unable to adapt value of type " + object.getClass().getName() + " to " + clazz.getName());
        }
        return (T)object;
    }

    private Object adaptForAttribute(Method method, Object object) {
        Class<?> clazz = ClassUtils.resolvePrimitiveIfNecessary(method.getReturnType());
        if (clazz.isArray() && !object.getClass().isArray()) {
            Object object2 = Array.newInstance(object.getClass(), 1);
            Array.set(object2, 0, object);
            return this.adaptForAttribute(method, object2);
        }
        if (clazz.isAnnotation()) {
            return this.adaptToMergedAnnotation(object, clazz);
        }
        if (clazz.isArray() && clazz.getComponentType().isAnnotation()) {
            MergedAnnotation[] mergedAnnotationArray = new MergedAnnotation[Array.getLength(object)];
            for (int i = 0; i < mergedAnnotationArray.length; ++i) {
                mergedAnnotationArray[i] = this.adaptToMergedAnnotation(Array.get(object, i), clazz.getComponentType());
            }
            return mergedAnnotationArray;
        }
        if (clazz == Class.class && object instanceof String || clazz == Class[].class && object instanceof String[] || clazz == String.class && object instanceof Class || clazz == String[].class && object instanceof Class[]) {
            return object;
        }
        if (clazz.isArray() && this.isEmptyObjectArray(object)) {
            return this.emptyArray(clazz.getComponentType());
        }
        if (!clazz.isInstance(object)) {
            throw new IllegalStateException("Attribute '" + method.getName() + "' in annotation " + this.getType().getName() + " should be compatible with " + clazz.getName() + " but a " + object.getClass().getName() + " value was returned");
        }
        return object;
    }

    private boolean isEmptyObjectArray(Object object) {
        return object instanceof Object[] && ((Object[])object).length == 0;
    }

    private Object emptyArray(Class<?> clazz) {
        Object object = EMPTY_ARRAYS.get(clazz);
        if (object == null) {
            object = Array.newInstance(clazz, 0);
        }
        return object;
    }

    private MergedAnnotation<?> adaptToMergedAnnotation(Object object, Class<? extends Annotation> clazz) {
        if (object instanceof MergedAnnotation) {
            return (MergedAnnotation)object;
        }
        AnnotationTypeMapping annotationTypeMapping = AnnotationTypeMappings.forAnnotationType(clazz).get(0);
        return new TypeMappedAnnotation<A>(annotationTypeMapping, null, this.source, object, this.getValueExtractor(object), this.aggregateIndex);
    }

    private ValueExtractor getValueExtractor(Object object) {
        if (object instanceof Annotation) {
            return ReflectionUtils::invokeMethod;
        }
        if (object instanceof Map) {
            return TypeMappedAnnotation::extractFromMap;
        }
        return this.valueExtractor;
    }

    private <T> Class<T> getAdaptType(Method method, Class<T> clazz) {
        if (clazz != Object.class) {
            return clazz;
        }
        Class<?> clazz2 = method.getReturnType();
        if (clazz2.isAnnotation()) {
            return MergedAnnotation.class;
        }
        if (clazz2.isArray() && clazz2.getComponentType().isAnnotation()) {
            return MergedAnnotation[].class;
        }
        return ClassUtils.resolvePrimitiveIfNecessary(clazz2);
    }

    private int getAttributeIndex(String string, boolean bl) {
        int n;
        Assert.hasText(string, "Attribute name must not be null");
        int n2 = n = this.isFiltered(string) ? -1 : this.mapping.getAttributes().indexOf(string);
        if (n == -1 && bl) {
            throw new NoSuchElementException("No attribute named '" + string + "' present in merged annotation " + this.getType().getName());
        }
        return n;
    }

    private boolean isFiltered(String string) {
        if (this.attributeFilter != null) {
            return !this.attributeFilter.test(string);
        }
        return false;
    }

    @Nullable
    private ClassLoader getClassLoader() {
        if (this.classLoader != null) {
            return this.classLoader;
        }
        if (this.source != null) {
            if (this.source instanceof Class) {
                return ((Class)this.source).getClassLoader();
            }
            if (this.source instanceof Member) {
                ((Member)this.source).getDeclaringClass().getClassLoader();
            }
        }
        return null;
    }

    static <A extends Annotation> MergedAnnotation<A> from(@Nullable Object object, A a) {
        Assert.notNull(a, "Annotation must not be null");
        AnnotationTypeMappings annotationTypeMappings = AnnotationTypeMappings.forAnnotationType(a.annotationType());
        return new TypeMappedAnnotation<A>(annotationTypeMappings.get(0), null, object, a, ReflectionUtils::invokeMethod, 0);
    }

    static <A extends Annotation> MergedAnnotation<A> of(@Nullable ClassLoader classLoader, @Nullable Object object, Class<A> clazz, @Nullable Map<String, ?> map) {
        Assert.notNull(clazz, "Annotation type must not be null");
        AnnotationTypeMappings annotationTypeMappings = AnnotationTypeMappings.forAnnotationType(clazz);
        return new TypeMappedAnnotation<A>(annotationTypeMappings.get(0), classLoader, object, map, TypeMappedAnnotation::extractFromMap, 0);
    }

    @Nullable
    static <A extends Annotation> TypeMappedAnnotation<A> createIfPossible(AnnotationTypeMapping annotationTypeMapping, MergedAnnotation<?> mergedAnnotation, IntrospectionFailureLogger introspectionFailureLogger) {
        if (mergedAnnotation instanceof TypeMappedAnnotation) {
            TypeMappedAnnotation typeMappedAnnotation = (TypeMappedAnnotation)mergedAnnotation;
            return TypeMappedAnnotation.createIfPossible(annotationTypeMapping, typeMappedAnnotation.source, typeMappedAnnotation.rootAttributes, typeMappedAnnotation.valueExtractor, typeMappedAnnotation.aggregateIndex, introspectionFailureLogger);
        }
        return TypeMappedAnnotation.createIfPossible(annotationTypeMapping, mergedAnnotation.getSource(), mergedAnnotation.synthesize(), mergedAnnotation.getAggregateIndex(), introspectionFailureLogger);
    }

    @Nullable
    static <A extends Annotation> TypeMappedAnnotation<A> createIfPossible(AnnotationTypeMapping annotationTypeMapping, @Nullable Object object, Annotation annotation, int n, IntrospectionFailureLogger introspectionFailureLogger) {
        return TypeMappedAnnotation.createIfPossible(annotationTypeMapping, object, annotation, ReflectionUtils::invokeMethod, n, introspectionFailureLogger);
    }

    @Nullable
    private static <A extends Annotation> TypeMappedAnnotation<A> createIfPossible(AnnotationTypeMapping annotationTypeMapping, @Nullable Object object, @Nullable Object object2, ValueExtractor valueExtractor, int n, IntrospectionFailureLogger introspectionFailureLogger) {
        try {
            return new TypeMappedAnnotation<A>(annotationTypeMapping, null, object, object2, valueExtractor, n);
        }
        catch (Exception exception) {
            AnnotationUtils.rethrowAnnotationConfigurationException(exception);
            if (introspectionFailureLogger.isEnabled()) {
                String string = annotationTypeMapping.getAnnotationType().getName();
                String string2 = annotationTypeMapping.getDistance() == 0 ? "annotation " + string : "meta-annotation " + string + " from " + annotationTypeMapping.getRoot().getAnnotationType().getName();
                introspectionFailureLogger.log("Failed to introspect " + string2, object, exception);
            }
            return null;
        }
    }

    @Nullable
    static Object extractFromMap(Method method, @Nullable Object object) {
        return object != null ? ((Map)object).get(method.getName()) : null;
    }

    static {
        HashMap<Class<Object>, Object[]> hashMap = new HashMap<Class<Object>, Object[]>();
        hashMap.put(Boolean.TYPE, new boolean[0]);
        hashMap.put(Byte.TYPE, new byte[0]);
        hashMap.put(Character.TYPE, new char[0]);
        hashMap.put(Double.TYPE, new double[0]);
        hashMap.put(Float.TYPE, new float[0]);
        hashMap.put(Integer.TYPE, new int[0]);
        hashMap.put(Long.TYPE, new long[0]);
        hashMap.put(Short.TYPE, new short[0]);
        hashMap.put(String.class, new String[0]);
        EMPTY_ARRAYS = Collections.unmodifiableMap(hashMap);
    }
}

