/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.annotation;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.springframework.core.annotation.AnnotationTypeMapping;
import org.springframework.core.annotation.AnnotationTypeMappings;
import org.springframework.core.annotation.IntrospectionFailureLogger;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotationSelector;
import org.springframework.core.annotation.MergedAnnotationSelectors;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.core.annotation.TypeMappedAnnotation;
import org.springframework.core.annotation.TypeMappedAnnotations;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

final class MergedAnnotationsCollection
implements MergedAnnotations {
    private final MergedAnnotation<?>[] annotations;
    private final AnnotationTypeMappings[] mappings;

    private MergedAnnotationsCollection(Collection<MergedAnnotation<?>> collection) {
        Assert.notNull(collection, "Annotations must not be null");
        this.annotations = collection.toArray(new MergedAnnotation[0]);
        this.mappings = new AnnotationTypeMappings[this.annotations.length];
        for (int i = 0; i < this.annotations.length; ++i) {
            MergedAnnotation<?> mergedAnnotation = this.annotations[i];
            Assert.notNull(mergedAnnotation, "Annotation must not be null");
            Assert.isTrue(mergedAnnotation.isDirectlyPresent(), "Annotation must be directly present");
            Assert.isTrue(mergedAnnotation.getAggregateIndex() == 0, "Annotation must have aggregate index of zero");
            this.mappings[i] = AnnotationTypeMappings.forAnnotationType(mergedAnnotation.getType());
        }
    }

    @Override
    public Iterator<MergedAnnotation<Annotation>> iterator() {
        return Spliterators.iterator(this.spliterator());
    }

    @Override
    public Spliterator<MergedAnnotation<Annotation>> spliterator() {
        return this.spliterator(null);
    }

    private <A extends Annotation> Spliterator<MergedAnnotation<A>> spliterator(@Nullable Object object) {
        return new AnnotationsSpliterator(object);
    }

    @Override
    public <A extends Annotation> boolean isPresent(Class<A> clazz) {
        return this.isPresent(clazz, false);
    }

    @Override
    public boolean isPresent(String string) {
        return this.isPresent(string, false);
    }

    @Override
    public <A extends Annotation> boolean isDirectlyPresent(Class<A> clazz) {
        return this.isPresent(clazz, true);
    }

    @Override
    public boolean isDirectlyPresent(String string) {
        return this.isPresent(string, true);
    }

    private boolean isPresent(Object object, boolean bl) {
        for (MergedAnnotation<?> mergedAnnotation : this.annotations) {
            Class<?> clazz = mergedAnnotation.getType();
            if (clazz != object && !clazz.getName().equals(object)) continue;
            return true;
        }
        if (!bl) {
            for (AnnotationTypeMappings annotationTypeMappings : this.mappings) {
                for (int i = 1; i < annotationTypeMappings.size(); ++i) {
                    AnnotationTypeMapping annotationTypeMapping = annotationTypeMappings.get(i);
                    if (!MergedAnnotationsCollection.isMappingForType(annotationTypeMapping, object)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public <A extends Annotation> MergedAnnotation<A> get(Class<A> clazz) {
        return this.get(clazz, null, null);
    }

    @Override
    public <A extends Annotation> MergedAnnotation<A> get(Class<A> clazz, @Nullable Predicate<? super MergedAnnotation<A>> predicate) {
        return this.get(clazz, predicate, null);
    }

    @Override
    public <A extends Annotation> MergedAnnotation<A> get(Class<A> clazz, @Nullable Predicate<? super MergedAnnotation<A>> predicate, @Nullable MergedAnnotationSelector<A> mergedAnnotationSelector) {
        MergedAnnotation<A> mergedAnnotation = this.find(clazz, predicate, mergedAnnotationSelector);
        return mergedAnnotation != null ? mergedAnnotation : MergedAnnotation.missing();
    }

    @Override
    public <A extends Annotation> MergedAnnotation<A> get(String string) {
        return this.get(string, null, null);
    }

    @Override
    public <A extends Annotation> MergedAnnotation<A> get(String string, @Nullable Predicate<? super MergedAnnotation<A>> predicate) {
        return this.get(string, predicate, null);
    }

    @Override
    public <A extends Annotation> MergedAnnotation<A> get(String string, @Nullable Predicate<? super MergedAnnotation<A>> predicate, @Nullable MergedAnnotationSelector<A> mergedAnnotationSelector) {
        MergedAnnotation<A> mergedAnnotation = this.find(string, predicate, mergedAnnotationSelector);
        return mergedAnnotation != null ? mergedAnnotation : MergedAnnotation.missing();
    }

    @Nullable
    private <A extends Annotation> MergedAnnotation<A> find(Object object, @Nullable Predicate<? super MergedAnnotation<A>> predicate, @Nullable MergedAnnotationSelector<A> mergedAnnotationSelector) {
        if (mergedAnnotationSelector == null) {
            mergedAnnotationSelector = MergedAnnotationSelectors.nearest();
        }
        MergedAnnotation<?> mergedAnnotation = null;
        for (int i = 0; i < this.annotations.length; ++i) {
            MergedAnnotation<?> mergedAnnotation2 = this.annotations[i];
            AnnotationTypeMappings annotationTypeMappings = this.mappings[i];
            for (int j = 0; j < annotationTypeMappings.size(); ++j) {
                MergedAnnotation<?> mergedAnnotation3;
                AnnotationTypeMapping annotationTypeMapping = annotationTypeMappings.get(j);
                if (!MergedAnnotationsCollection.isMappingForType(annotationTypeMapping, object)) continue;
                MergedAnnotation<Object> mergedAnnotation4 = mergedAnnotation3 = j == 0 ? mergedAnnotation2 : TypeMappedAnnotation.createIfPossible(annotationTypeMapping, mergedAnnotation2, IntrospectionFailureLogger.INFO);
                if (mergedAnnotation3 == null || predicate != null && !predicate.test(mergedAnnotation3)) continue;
                if (mergedAnnotationSelector.isBestCandidate(mergedAnnotation3)) {
                    return mergedAnnotation3;
                }
                mergedAnnotation = mergedAnnotation != null ? mergedAnnotationSelector.select(mergedAnnotation, mergedAnnotation3) : mergedAnnotation3;
            }
        }
        return mergedAnnotation;
    }

    @Override
    public <A extends Annotation> Stream<MergedAnnotation<A>> stream(Class<A> clazz) {
        return StreamSupport.stream(this.spliterator(clazz), false);
    }

    @Override
    public <A extends Annotation> Stream<MergedAnnotation<A>> stream(String string) {
        return StreamSupport.stream(this.spliterator(string), false);
    }

    @Override
    public Stream<MergedAnnotation<Annotation>> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    private static boolean isMappingForType(AnnotationTypeMapping annotationTypeMapping, @Nullable Object object) {
        if (object == null) {
            return true;
        }
        Class<? extends Annotation> clazz = annotationTypeMapping.getAnnotationType();
        return clazz == object || clazz.getName().equals(object);
    }

    static MergedAnnotations of(Collection<MergedAnnotation<?>> collection) {
        Assert.notNull(collection, "Annotations must not be null");
        if (collection.isEmpty()) {
            return TypeMappedAnnotations.NONE;
        }
        return new MergedAnnotationsCollection(collection);
    }

    private class AnnotationsSpliterator<A extends Annotation>
    implements Spliterator<MergedAnnotation<A>> {
        @Nullable
        private Object requiredType;
        private final int[] mappingCursors;

        public AnnotationsSpliterator(@Nullable Object object) {
            this.mappingCursors = new int[MergedAnnotationsCollection.this.annotations.length];
            this.requiredType = object;
        }

        @Override
        public boolean tryAdvance(Consumer<? super MergedAnnotation<A>> consumer) {
            int n = Integer.MAX_VALUE;
            int n2 = -1;
            for (int i = 0; i < MergedAnnotationsCollection.this.annotations.length; ++i) {
                AnnotationTypeMapping annotationTypeMapping = this.getNextSuitableMapping(i);
                if (annotationTypeMapping != null && annotationTypeMapping.getDistance() < n) {
                    n2 = i;
                    n = annotationTypeMapping.getDistance();
                }
                if (n == 0) break;
            }
            if (n2 != -1) {
                MergedAnnotation<A> mergedAnnotation = this.createMergedAnnotationIfPossible(n2, this.mappingCursors[n2]);
                int n3 = n2;
                this.mappingCursors[n3] = this.mappingCursors[n3] + 1;
                if (mergedAnnotation == null) {
                    return this.tryAdvance((Consumer<? super MergedAnnotation<A>>)consumer);
                }
                consumer.accept(mergedAnnotation);
                return true;
            }
            return false;
        }

        @Nullable
        private AnnotationTypeMapping getNextSuitableMapping(int n) {
            AnnotationTypeMapping annotationTypeMapping;
            do {
                if ((annotationTypeMapping = this.getMapping(n, this.mappingCursors[n])) != null && MergedAnnotationsCollection.isMappingForType(annotationTypeMapping, this.requiredType)) {
                    return annotationTypeMapping;
                }
                int n2 = n;
                this.mappingCursors[n2] = this.mappingCursors[n2] + 1;
            } while (annotationTypeMapping != null);
            return null;
        }

        @Nullable
        private AnnotationTypeMapping getMapping(int n, int n2) {
            AnnotationTypeMappings annotationTypeMappings = MergedAnnotationsCollection.this.mappings[n];
            return n2 < annotationTypeMappings.size() ? annotationTypeMappings.get(n2) : null;
        }

        @Nullable
        private MergedAnnotation<A> createMergedAnnotationIfPossible(int n, int n2) {
            MergedAnnotation mergedAnnotation = MergedAnnotationsCollection.this.annotations[n];
            if (n2 == 0) {
                return mergedAnnotation;
            }
            IntrospectionFailureLogger introspectionFailureLogger = this.requiredType != null ? IntrospectionFailureLogger.INFO : IntrospectionFailureLogger.DEBUG;
            return TypeMappedAnnotation.createIfPossible(MergedAnnotationsCollection.this.mappings[n].get(n2), mergedAnnotation, introspectionFailureLogger);
        }

        @Override
        @Nullable
        public Spliterator<MergedAnnotation<A>> trySplit() {
            return null;
        }

        @Override
        public long estimateSize() {
            int n = 0;
            for (int i = 0; i < MergedAnnotationsCollection.this.annotations.length; ++i) {
                AnnotationTypeMappings annotationTypeMappings = MergedAnnotationsCollection.this.mappings[i];
                int n2 = annotationTypeMappings.size();
                n += (n2 -= Math.min(this.mappingCursors[i], annotationTypeMappings.size()));
            }
            return n;
        }

        @Override
        public int characteristics() {
            return 1280;
        }
    }
}

