/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Map;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.core.Ordered;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotationFilter;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.annotation.AnnotationsProcessor;
import org.springframework.core.annotation.AttributeMethods;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.lang.Nullable;
import org.springframework.util.ConcurrentReferenceHashMap;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;

abstract class AnnotationsScanner {
    private static final Annotation[] NO_ANNOTATIONS = new Annotation[0];
    private static final Method[] NO_METHODS = new Method[0];
    private static final Map<AnnotatedElement, Annotation[]> declaredAnnotationCache = new ConcurrentReferenceHashMap<AnnotatedElement, Annotation[]>(256);
    private static final Map<Class<?>, Method[]> baseTypeMethodsCache = new ConcurrentReferenceHashMap(256);

    private AnnotationsScanner() {
    }

    @Nullable
    static <C, R> R scan(C c, AnnotatedElement annotatedElement, MergedAnnotations.SearchStrategy searchStrategy, AnnotationsProcessor<C, R> annotationsProcessor) {
        R r = AnnotationsScanner.process(c, annotatedElement, searchStrategy, annotationsProcessor);
        return annotationsProcessor.finish(r);
    }

    @Nullable
    private static <C, R> R process(C c, AnnotatedElement annotatedElement, MergedAnnotations.SearchStrategy searchStrategy, AnnotationsProcessor<C, R> annotationsProcessor) {
        if (annotatedElement instanceof Class) {
            return AnnotationsScanner.processClass(c, (Class)annotatedElement, searchStrategy, annotationsProcessor);
        }
        if (annotatedElement instanceof Method) {
            return AnnotationsScanner.processMethod(c, (Method)annotatedElement, searchStrategy, annotationsProcessor);
        }
        return AnnotationsScanner.processElement(c, annotatedElement, annotationsProcessor);
    }

    @Nullable
    private static <C, R> R processClass(C c, Class<?> clazz, MergedAnnotations.SearchStrategy searchStrategy, AnnotationsProcessor<C, R> annotationsProcessor) {
        switch (searchStrategy) {
            case DIRECT: {
                return AnnotationsScanner.processElement(c, clazz, annotationsProcessor);
            }
            case INHERITED_ANNOTATIONS: {
                return AnnotationsScanner.processClassInheritedAnnotations(c, clazz, searchStrategy, annotationsProcessor);
            }
            case SUPERCLASS: {
                return AnnotationsScanner.processClassHierarchy(c, clazz, annotationsProcessor, false, false);
            }
            case TYPE_HIERARCHY: {
                return AnnotationsScanner.processClassHierarchy(c, clazz, annotationsProcessor, true, false);
            }
            case TYPE_HIERARCHY_AND_ENCLOSING_CLASSES: {
                return AnnotationsScanner.processClassHierarchy(c, clazz, annotationsProcessor, true, true);
            }
        }
        throw new IllegalStateException("Unsupported search strategy " + (Object)((Object)searchStrategy));
    }

    @Nullable
    private static <C, R> R processClassInheritedAnnotations(C c, Class<?> clazz, MergedAnnotations.SearchStrategy searchStrategy, AnnotationsProcessor<C, R> annotationsProcessor) {
        try {
            if (AnnotationsScanner.isWithoutHierarchy(clazz, searchStrategy)) {
                return AnnotationsScanner.processElement(c, clazz, annotationsProcessor);
            }
            Annotation[] annotationArray = null;
            int n = Integer.MAX_VALUE;
            int n2 = 0;
            Class<?> clazz2 = clazz;
            while (clazz != null && clazz != Object.class && n > 0 && !AnnotationsScanner.hasPlainJavaAnnotationsOnly(clazz)) {
                R r = annotationsProcessor.doWithAggregate(c, n2);
                if (r != null) {
                    return r;
                }
                Annotation[] annotationArray2 = AnnotationsScanner.getDeclaredAnnotations(clazz, true);
                if (annotationArray == null && annotationArray2.length > 0) {
                    annotationArray = clazz2.getAnnotations();
                    n = annotationArray.length;
                }
                for (int i = 0; i < annotationArray2.length; ++i) {
                    if (annotationArray2[i] == null) continue;
                    boolean bl = false;
                    for (int j = 0; j < annotationArray.length; ++j) {
                        if (annotationArray[j] == null || annotationArray2[i].annotationType() != annotationArray[j].annotationType()) continue;
                        bl = true;
                        annotationArray[j] = null;
                        --n;
                        break;
                    }
                    if (bl) continue;
                    annotationArray2[i] = null;
                }
                r = annotationsProcessor.doWithAnnotations(c, n2, clazz, annotationArray2);
                if (r != null) {
                    return r;
                }
                clazz = clazz.getSuperclass();
                ++n2;
            }
        }
        catch (Throwable throwable) {
            AnnotationUtils.handleIntrospectionFailure(clazz, throwable);
        }
        return null;
    }

    @Nullable
    private static <C, R> R processClassHierarchy(C c, Class<?> clazz, AnnotationsProcessor<C, R> annotationsProcessor, boolean bl, boolean bl2) {
        return AnnotationsScanner.processClassHierarchy(c, new int[]{0}, clazz, annotationsProcessor, bl, bl2);
    }

    @Nullable
    private static <C, R> R processClassHierarchy(C c, int[] nArray, Class<?> clazz, AnnotationsProcessor<C, R> annotationsProcessor, boolean bl, boolean bl2) {
        block11: {
            try {
                R r;
                Object object;
                R r2 = annotationsProcessor.doWithAggregate(c, nArray[0]);
                if (r2 != null) {
                    return r2;
                }
                if (AnnotationsScanner.hasPlainJavaAnnotationsOnly(clazz)) {
                    return null;
                }
                Annotation[] annotationArray = AnnotationsScanner.getDeclaredAnnotations(clazz, false);
                r2 = annotationsProcessor.doWithAnnotations(c, nArray[0], clazz, annotationArray);
                if (r2 != null) {
                    return r2;
                }
                nArray[0] = nArray[0] + 1;
                if (bl) {
                    object = clazz.getInterfaces();
                    int n = ((Class<?>[])object).length;
                    for (int i = 0; i < n; ++i) {
                        Class<?> clazz2 = object[i];
                        R r3 = AnnotationsScanner.processClassHierarchy(c, nArray, clazz2, annotationsProcessor, true, bl2);
                        if (r3 == null) continue;
                        return r3;
                    }
                }
                if ((object = clazz.getSuperclass()) != Object.class && object != null && (r = AnnotationsScanner.processClassHierarchy(c, nArray, object, annotationsProcessor, bl, bl2)) != null) {
                    return r;
                }
                if (!bl2) break block11;
                try {
                    R r4;
                    Class<?> clazz3 = clazz.getEnclosingClass();
                    if (clazz3 != null && (r4 = AnnotationsScanner.processClassHierarchy(c, nArray, clazz3, annotationsProcessor, bl, true)) != null) {
                        return r4;
                    }
                }
                catch (Throwable throwable) {
                    AnnotationUtils.handleIntrospectionFailure(clazz, throwable);
                }
            }
            catch (Throwable throwable) {
                AnnotationUtils.handleIntrospectionFailure(clazz, throwable);
            }
        }
        return null;
    }

    @Nullable
    private static <C, R> R processMethod(C c, Method method, MergedAnnotations.SearchStrategy searchStrategy, AnnotationsProcessor<C, R> annotationsProcessor) {
        switch (searchStrategy) {
            case DIRECT: 
            case INHERITED_ANNOTATIONS: {
                return AnnotationsScanner.processMethodInheritedAnnotations(c, method, annotationsProcessor);
            }
            case SUPERCLASS: {
                return AnnotationsScanner.processMethodHierarchy(c, new int[]{0}, method.getDeclaringClass(), annotationsProcessor, method, false);
            }
            case TYPE_HIERARCHY: 
            case TYPE_HIERARCHY_AND_ENCLOSING_CLASSES: {
                return AnnotationsScanner.processMethodHierarchy(c, new int[]{0}, method.getDeclaringClass(), annotationsProcessor, method, true);
            }
        }
        throw new IllegalStateException("Unsupported search strategy " + (Object)((Object)searchStrategy));
    }

    @Nullable
    private static <C, R> R processMethodInheritedAnnotations(C c, Method method, AnnotationsProcessor<C, R> annotationsProcessor) {
        try {
            R r = annotationsProcessor.doWithAggregate(c, 0);
            return r != null ? r : AnnotationsScanner.processMethodAnnotations(c, 0, method, annotationsProcessor);
        }
        catch (Throwable throwable) {
            AnnotationUtils.handleIntrospectionFailure(method, throwable);
            return null;
        }
    }

    @Nullable
    private static <C, R> R processMethodHierarchy(C c, int[] nArray, Class<?> clazz, AnnotationsProcessor<C, R> annotationsProcessor, Method method, boolean bl) {
        try {
            R r;
            GenericDeclaration genericDeclaration;
            int n;
            int n2;
            Object object;
            R r2 = annotationsProcessor.doWithAggregate(c, nArray[0]);
            if (r2 != null) {
                return r2;
            }
            if (AnnotationsScanner.hasPlainJavaAnnotationsOnly(clazz)) {
                return null;
            }
            boolean bl2 = false;
            if (clazz == method.getDeclaringClass()) {
                r2 = AnnotationsScanner.processMethodAnnotations(c, nArray[0], method, annotationsProcessor);
                bl2 = true;
                if (r2 != null) {
                    return r2;
                }
            } else {
                object = AnnotationsScanner.getBaseTypeMethods(c, clazz);
                n2 = ((Method[])object).length;
                for (n = 0; n < n2; ++n) {
                    genericDeclaration = object[n];
                    if (genericDeclaration == null || !AnnotationsScanner.isOverride(method, genericDeclaration)) continue;
                    r2 = AnnotationsScanner.processMethodAnnotations(c, nArray[0], genericDeclaration, annotationsProcessor);
                    bl2 = true;
                    if (r2 == null) continue;
                    return r2;
                }
            }
            if (Modifier.isPrivate(method.getModifiers())) {
                return null;
            }
            if (bl2) {
                nArray[0] = nArray[0] + 1;
            }
            if (bl) {
                object = clazz.getInterfaces();
                n2 = ((GenericDeclaration[])object).length;
                for (n = 0; n < n2; ++n) {
                    genericDeclaration = object[n];
                    R r3 = AnnotationsScanner.processMethodHierarchy(c, nArray, genericDeclaration, annotationsProcessor, method, true);
                    if (r3 == null) continue;
                    return r3;
                }
            }
            if ((object = clazz.getSuperclass()) != Object.class && object != null && (r = AnnotationsScanner.processMethodHierarchy(c, nArray, object, annotationsProcessor, method, bl)) != null) {
                return r;
            }
        }
        catch (Throwable throwable) {
            AnnotationUtils.handleIntrospectionFailure(method, throwable);
        }
        return null;
    }

    private static <C> Method[] getBaseTypeMethods(C c, Class<?> clazz) {
        if (clazz == Object.class || AnnotationsScanner.hasPlainJavaAnnotationsOnly(clazz)) {
            return NO_METHODS;
        }
        Method[] methodArray = baseTypeMethodsCache.get(clazz);
        if (methodArray == null) {
            boolean bl = clazz.isInterface();
            methodArray = bl ? clazz.getMethods() : ReflectionUtils.getDeclaredMethods(clazz);
            int n = 0;
            for (int i = 0; i < methodArray.length; ++i) {
                if ((bl || !Modifier.isPrivate(methodArray[i].getModifiers())) && !AnnotationsScanner.hasPlainJavaAnnotationsOnly(methodArray[i]) && AnnotationsScanner.getDeclaredAnnotations(methodArray[i], false).length != 0) continue;
                methodArray[i] = null;
                ++n;
            }
            if (n == methodArray.length) {
                methodArray = NO_METHODS;
            }
            baseTypeMethodsCache.put(clazz, methodArray);
        }
        return methodArray;
    }

    private static boolean isOverride(Method method, Method method2) {
        return !Modifier.isPrivate(method2.getModifiers()) && method2.getName().equals(method.getName()) && AnnotationsScanner.hasSameParameterTypes(method, method2);
    }

    private static boolean hasSameParameterTypes(Method method, Method method2) {
        if (method2.getParameterCount() != method.getParameterCount()) {
            return false;
        }
        Object[] objectArray = method.getParameterTypes();
        Object[] objectArray2 = method2.getParameterTypes();
        if (Arrays.equals(objectArray2, objectArray)) {
            return true;
        }
        return AnnotationsScanner.hasSameGenericTypeParameters(method, method2, objectArray);
    }

    private static boolean hasSameGenericTypeParameters(Method method, Method method2, Class<?>[] classArray) {
        Class<?> clazz = method.getDeclaringClass();
        Class<?> clazz2 = method2.getDeclaringClass();
        if (!clazz2.isAssignableFrom(clazz)) {
            return false;
        }
        for (int i = 0; i < classArray.length; ++i) {
            Class<?> clazz3 = ResolvableType.forMethodParameter(method2, i, clazz).resolve();
            if (classArray[i] == clazz3) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private static <C, R> R processMethodAnnotations(C c, int n, Method method, AnnotationsProcessor<C, R> annotationsProcessor) {
        Object[] objectArray = AnnotationsScanner.getDeclaredAnnotations(method, false);
        R r = annotationsProcessor.doWithAnnotations(c, n, method, (Annotation[])objectArray);
        if (r != null) {
            return r;
        }
        Method method2 = BridgeMethodResolver.findBridgedMethod(method);
        if (method2 != method) {
            Annotation[] annotationArray = AnnotationsScanner.getDeclaredAnnotations(method2, true);
            for (int i = 0; i < annotationArray.length; ++i) {
                if (!ObjectUtils.containsElement(objectArray, annotationArray[i])) continue;
                annotationArray[i] = null;
            }
            return annotationsProcessor.doWithAnnotations(c, n, method, annotationArray);
        }
        return null;
    }

    @Nullable
    private static <C, R> R processElement(C c, AnnotatedElement annotatedElement, AnnotationsProcessor<C, R> annotationsProcessor) {
        try {
            R r = annotationsProcessor.doWithAggregate(c, 0);
            return r != null ? r : annotationsProcessor.doWithAnnotations(c, 0, annotatedElement, AnnotationsScanner.getDeclaredAnnotations(annotatedElement, false));
        }
        catch (Throwable throwable) {
            AnnotationUtils.handleIntrospectionFailure(annotatedElement, throwable);
            return null;
        }
    }

    @Nullable
    static <A extends Annotation> A getDeclaredAnnotation(AnnotatedElement annotatedElement, Class<A> clazz) {
        Annotation[] annotationArray;
        for (Annotation annotation : annotationArray = AnnotationsScanner.getDeclaredAnnotations(annotatedElement, false)) {
            if (annotation == null || clazz != annotation.annotationType()) continue;
            return (A)annotation;
        }
        return null;
    }

    static Annotation[] getDeclaredAnnotations(AnnotatedElement annotatedElement, boolean bl) {
        boolean bl2 = false;
        Annotation[] annotationArray = declaredAnnotationCache.get(annotatedElement);
        if (annotationArray != null) {
            bl2 = true;
        } else {
            annotationArray = annotatedElement.getDeclaredAnnotations();
            if (annotationArray.length != 0) {
                boolean bl3 = true;
                for (int i = 0; i < annotationArray.length; ++i) {
                    Annotation annotation = annotationArray[i];
                    if (AnnotationsScanner.isIgnorable(annotation.annotationType()) || !AttributeMethods.forAnnotationType(annotation.annotationType()).isValid(annotation)) {
                        annotationArray[i] = null;
                        continue;
                    }
                    bl3 = false;
                }
                Annotation[] annotationArray2 = annotationArray = bl3 ? NO_ANNOTATIONS : annotationArray;
                if (annotatedElement instanceof Class || annotatedElement instanceof Member) {
                    declaredAnnotationCache.put(annotatedElement, annotationArray);
                    bl2 = true;
                }
            }
        }
        if (!bl || annotationArray.length == 0 || !bl2) {
            return annotationArray;
        }
        return (Annotation[])annotationArray.clone();
    }

    private static boolean isIgnorable(Class<?> clazz) {
        return AnnotationFilter.PLAIN.matches(clazz);
    }

    static boolean isKnownEmpty(AnnotatedElement annotatedElement, MergedAnnotations.SearchStrategy searchStrategy) {
        if (AnnotationsScanner.hasPlainJavaAnnotationsOnly(annotatedElement)) {
            return true;
        }
        if (searchStrategy == MergedAnnotations.SearchStrategy.DIRECT || AnnotationsScanner.isWithoutHierarchy(annotatedElement, searchStrategy)) {
            if (annotatedElement instanceof Method && ((Method)annotatedElement).isBridge()) {
                return false;
            }
            return AnnotationsScanner.getDeclaredAnnotations(annotatedElement, false).length == 0;
        }
        return false;
    }

    static boolean hasPlainJavaAnnotationsOnly(@Nullable Object object) {
        if (object instanceof Class) {
            return AnnotationsScanner.hasPlainJavaAnnotationsOnly((Class)object);
        }
        if (object instanceof Member) {
            return AnnotationsScanner.hasPlainJavaAnnotationsOnly(((Member)object).getDeclaringClass());
        }
        return false;
    }

    static boolean hasPlainJavaAnnotationsOnly(Class<?> clazz) {
        return clazz.getName().startsWith("java.") || clazz == Ordered.class;
    }

    private static boolean isWithoutHierarchy(AnnotatedElement annotatedElement, MergedAnnotations.SearchStrategy searchStrategy) {
        if (annotatedElement == Object.class) {
            return true;
        }
        if (annotatedElement instanceof Class) {
            boolean bl;
            Class clazz = (Class)annotatedElement;
            boolean bl2 = bl = clazz.getSuperclass() == Object.class && clazz.getInterfaces().length == 0;
            return searchStrategy == MergedAnnotations.SearchStrategy.TYPE_HIERARCHY_AND_ENCLOSING_CLASSES ? bl && clazz.getEnclosingClass() == null : bl;
        }
        if (annotatedElement instanceof Method) {
            Method method = (Method)annotatedElement;
            return Modifier.isPrivate(method.getModifiers()) || AnnotationsScanner.isWithoutHierarchy(method.getDeclaringClass(), searchStrategy);
        }
        return true;
    }

    static void clearCache() {
        declaredAnnotationCache.clear();
        baseTypeMethodsCache.clear();
    }
}

