/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.annotation.AnnotationFilter;
import org.springframework.core.annotation.AnnotationsScanner;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotationCollectors;
import org.springframework.core.annotation.MergedAnnotationPredicates;
import org.springframework.core.annotation.MergedAnnotationSelectors;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.core.annotation.RepeatableContainers;
import org.springframework.lang.Nullable;
import org.springframework.util.MultiValueMap;

public abstract class AnnotatedElementUtils {
    public static AnnotatedElement forAnnotations(Annotation ... annotationArray) {
        return new AnnotatedElementForAnnotations(annotationArray);
    }

    public static Set<String> getMetaAnnotationTypes(AnnotatedElement annotatedElement, Class<? extends Annotation> clazz) {
        return AnnotatedElementUtils.getMetaAnnotationTypes(annotatedElement, annotatedElement.getAnnotation(clazz));
    }

    public static Set<String> getMetaAnnotationTypes(AnnotatedElement annotatedElement, String string) {
        for (Annotation annotation : annotatedElement.getAnnotations()) {
            if (!annotation.annotationType().getName().equals(string)) continue;
            return AnnotatedElementUtils.getMetaAnnotationTypes(annotatedElement, annotation);
        }
        return Collections.emptySet();
    }

    private static Set<String> getMetaAnnotationTypes(AnnotatedElement annotatedElement, @Nullable Annotation annotation) {
        if (annotation == null) {
            return Collections.emptySet();
        }
        return AnnotatedElementUtils.getAnnotations(annotation.annotationType()).stream().map(mergedAnnotation -> mergedAnnotation.getType().getName()).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public static boolean hasMetaAnnotationTypes(AnnotatedElement annotatedElement, Class<? extends Annotation> clazz) {
        return AnnotatedElementUtils.getAnnotations(annotatedElement).stream(clazz).anyMatch(MergedAnnotation::isMetaPresent);
    }

    public static boolean hasMetaAnnotationTypes(AnnotatedElement annotatedElement, String string) {
        return AnnotatedElementUtils.getAnnotations(annotatedElement).stream(string).anyMatch(MergedAnnotation::isMetaPresent);
    }

    public static boolean isAnnotated(AnnotatedElement annotatedElement, Class<? extends Annotation> clazz) {
        if (AnnotationFilter.PLAIN.matches(clazz) || AnnotationsScanner.hasPlainJavaAnnotationsOnly(annotatedElement)) {
            return annotatedElement.isAnnotationPresent(clazz);
        }
        return AnnotatedElementUtils.getAnnotations(annotatedElement).isPresent(clazz);
    }

    public static boolean isAnnotated(AnnotatedElement annotatedElement, String string) {
        return AnnotatedElementUtils.getAnnotations(annotatedElement).isPresent(string);
    }

    @Nullable
    public static AnnotationAttributes getMergedAnnotationAttributes(AnnotatedElement annotatedElement, Class<? extends Annotation> clazz) {
        MergedAnnotation<? extends Annotation> mergedAnnotation = AnnotatedElementUtils.getAnnotations(annotatedElement).get(clazz, null, MergedAnnotationSelectors.firstDirectlyDeclared());
        return AnnotatedElementUtils.getAnnotationAttributes(mergedAnnotation, false, false);
    }

    @Nullable
    public static AnnotationAttributes getMergedAnnotationAttributes(AnnotatedElement annotatedElement, String string) {
        return AnnotatedElementUtils.getMergedAnnotationAttributes(annotatedElement, string, false, false);
    }

    @Nullable
    public static AnnotationAttributes getMergedAnnotationAttributes(AnnotatedElement annotatedElement, String string, boolean bl, boolean bl2) {
        MergedAnnotation mergedAnnotation = AnnotatedElementUtils.getAnnotations(annotatedElement).get(string, null, MergedAnnotationSelectors.firstDirectlyDeclared());
        return AnnotatedElementUtils.getAnnotationAttributes(mergedAnnotation, bl, bl2);
    }

    @Nullable
    public static <A extends Annotation> A getMergedAnnotation(AnnotatedElement annotatedElement, Class<A> clazz) {
        if (AnnotationFilter.PLAIN.matches(clazz) || AnnotationsScanner.hasPlainJavaAnnotationsOnly(annotatedElement)) {
            return annotatedElement.getDeclaredAnnotation(clazz);
        }
        return (A)((Annotation)AnnotatedElementUtils.getAnnotations(annotatedElement).get(clazz, null, MergedAnnotationSelectors.firstDirectlyDeclared()).synthesize(MergedAnnotation::isPresent).orElse(null));
    }

    public static <A extends Annotation> Set<A> getAllMergedAnnotations(AnnotatedElement annotatedElement, Class<A> clazz) {
        return AnnotatedElementUtils.getAnnotations(annotatedElement).stream(clazz).collect(MergedAnnotationCollectors.toAnnotationSet());
    }

    public static Set<Annotation> getAllMergedAnnotations(AnnotatedElement annotatedElement, Set<Class<? extends Annotation>> set) {
        return AnnotatedElementUtils.getAnnotations(annotatedElement).stream().filter(MergedAnnotationPredicates.typeIn(set)).collect(MergedAnnotationCollectors.toAnnotationSet());
    }

    public static <A extends Annotation> Set<A> getMergedRepeatableAnnotations(AnnotatedElement annotatedElement, Class<A> clazz) {
        return AnnotatedElementUtils.getMergedRepeatableAnnotations(annotatedElement, clazz, null);
    }

    public static <A extends Annotation> Set<A> getMergedRepeatableAnnotations(AnnotatedElement annotatedElement, Class<A> clazz, @Nullable Class<? extends Annotation> clazz2) {
        return AnnotatedElementUtils.getRepeatableAnnotations(annotatedElement, clazz2, clazz).stream(clazz).collect(MergedAnnotationCollectors.toAnnotationSet());
    }

    @Nullable
    public static MultiValueMap<String, Object> getAllAnnotationAttributes(AnnotatedElement annotatedElement, String string) {
        return AnnotatedElementUtils.getAllAnnotationAttributes(annotatedElement, string, false, false);
    }

    @Nullable
    public static MultiValueMap<String, Object> getAllAnnotationAttributes(AnnotatedElement annotatedElement, String string, boolean bl, boolean bl2) {
        MergedAnnotation.Adapt[] adaptArray = MergedAnnotation.Adapt.values(bl, bl2);
        return AnnotatedElementUtils.getAnnotations(annotatedElement).stream(string).filter(MergedAnnotationPredicates.unique(MergedAnnotation::getMetaTypes)).map(MergedAnnotation::withNonMergedAttributes).collect(MergedAnnotationCollectors.toMultiValueMap(AnnotatedElementUtils::nullIfEmpty, adaptArray));
    }

    public static boolean hasAnnotation(AnnotatedElement annotatedElement, Class<? extends Annotation> clazz) {
        if (AnnotationFilter.PLAIN.matches(clazz) || AnnotationsScanner.hasPlainJavaAnnotationsOnly(annotatedElement)) {
            return annotatedElement.isAnnotationPresent(clazz);
        }
        return AnnotatedElementUtils.findAnnotations(annotatedElement).isPresent(clazz);
    }

    @Nullable
    public static AnnotationAttributes findMergedAnnotationAttributes(AnnotatedElement annotatedElement, Class<? extends Annotation> clazz, boolean bl, boolean bl2) {
        MergedAnnotation<? extends Annotation> mergedAnnotation = AnnotatedElementUtils.findAnnotations(annotatedElement).get(clazz, null, MergedAnnotationSelectors.firstDirectlyDeclared());
        return AnnotatedElementUtils.getAnnotationAttributes(mergedAnnotation, bl, bl2);
    }

    @Nullable
    public static AnnotationAttributes findMergedAnnotationAttributes(AnnotatedElement annotatedElement, String string, boolean bl, boolean bl2) {
        MergedAnnotation mergedAnnotation = AnnotatedElementUtils.findAnnotations(annotatedElement).get(string, null, MergedAnnotationSelectors.firstDirectlyDeclared());
        return AnnotatedElementUtils.getAnnotationAttributes(mergedAnnotation, bl, bl2);
    }

    @Nullable
    public static <A extends Annotation> A findMergedAnnotation(AnnotatedElement annotatedElement, Class<A> clazz) {
        if (AnnotationFilter.PLAIN.matches(clazz) || AnnotationsScanner.hasPlainJavaAnnotationsOnly(annotatedElement)) {
            return annotatedElement.getDeclaredAnnotation(clazz);
        }
        return (A)((Annotation)AnnotatedElementUtils.findAnnotations(annotatedElement).get(clazz, null, MergedAnnotationSelectors.firstDirectlyDeclared()).synthesize(MergedAnnotation::isPresent).orElse(null));
    }

    public static <A extends Annotation> Set<A> findAllMergedAnnotations(AnnotatedElement annotatedElement, Class<A> clazz) {
        return AnnotatedElementUtils.findAnnotations(annotatedElement).stream(clazz).sorted(AnnotatedElementUtils.highAggregateIndexesFirst()).collect(MergedAnnotationCollectors.toAnnotationSet());
    }

    public static Set<Annotation> findAllMergedAnnotations(AnnotatedElement annotatedElement, Set<Class<? extends Annotation>> set) {
        return AnnotatedElementUtils.findAnnotations(annotatedElement).stream().filter(MergedAnnotationPredicates.typeIn(set)).sorted(AnnotatedElementUtils.highAggregateIndexesFirst()).collect(MergedAnnotationCollectors.toAnnotationSet());
    }

    public static <A extends Annotation> Set<A> findMergedRepeatableAnnotations(AnnotatedElement annotatedElement, Class<A> clazz) {
        return AnnotatedElementUtils.findMergedRepeatableAnnotations(annotatedElement, clazz, null);
    }

    public static <A extends Annotation> Set<A> findMergedRepeatableAnnotations(AnnotatedElement annotatedElement, Class<A> clazz, @Nullable Class<? extends Annotation> clazz2) {
        return AnnotatedElementUtils.findRepeatableAnnotations(annotatedElement, clazz2, clazz).stream(clazz).sorted(AnnotatedElementUtils.highAggregateIndexesFirst()).collect(MergedAnnotationCollectors.toAnnotationSet());
    }

    private static MergedAnnotations getAnnotations(AnnotatedElement annotatedElement) {
        return MergedAnnotations.from(annotatedElement, MergedAnnotations.SearchStrategy.INHERITED_ANNOTATIONS, RepeatableContainers.none());
    }

    private static MergedAnnotations getRepeatableAnnotations(AnnotatedElement annotatedElement, @Nullable Class<? extends Annotation> clazz, Class<? extends Annotation> clazz2) {
        RepeatableContainers repeatableContainers = RepeatableContainers.of(clazz2, clazz);
        return MergedAnnotations.from(annotatedElement, MergedAnnotations.SearchStrategy.INHERITED_ANNOTATIONS, repeatableContainers);
    }

    private static MergedAnnotations findAnnotations(AnnotatedElement annotatedElement) {
        return MergedAnnotations.from(annotatedElement, MergedAnnotations.SearchStrategy.TYPE_HIERARCHY, RepeatableContainers.none());
    }

    private static MergedAnnotations findRepeatableAnnotations(AnnotatedElement annotatedElement, @Nullable Class<? extends Annotation> clazz, Class<? extends Annotation> clazz2) {
        RepeatableContainers repeatableContainers = RepeatableContainers.of(clazz2, clazz);
        return MergedAnnotations.from(annotatedElement, MergedAnnotations.SearchStrategy.TYPE_HIERARCHY, repeatableContainers);
    }

    @Nullable
    private static MultiValueMap<String, Object> nullIfEmpty(MultiValueMap<String, Object> multiValueMap) {
        return multiValueMap.isEmpty() ? null : multiValueMap;
    }

    private static <A extends Annotation> Comparator<MergedAnnotation<A>> highAggregateIndexesFirst() {
        return Comparator.comparingInt(MergedAnnotation::getAggregateIndex).reversed();
    }

    @Nullable
    private static AnnotationAttributes getAnnotationAttributes(MergedAnnotation<?> mergedAnnotation, boolean bl, boolean bl2) {
        if (!mergedAnnotation.isPresent()) {
            return null;
        }
        return mergedAnnotation.asAnnotationAttributes(MergedAnnotation.Adapt.values(bl, bl2));
    }

    private static class AnnotatedElementForAnnotations
    implements AnnotatedElement {
        private final Annotation[] annotations;

        AnnotatedElementForAnnotations(Annotation ... annotationArray) {
            this.annotations = annotationArray;
        }

        @Override
        @Nullable
        public <T extends Annotation> T getAnnotation(Class<T> clazz) {
            for (Annotation annotation : this.annotations) {
                if (annotation.annotationType() != clazz) continue;
                return (T)annotation;
            }
            return null;
        }

        @Override
        public Annotation[] getAnnotations() {
            return (Annotation[])this.annotations.clone();
        }

        @Override
        public Annotation[] getDeclaredAnnotations() {
            return (Annotation[])this.annotations.clone();
        }
    }
}

