/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.util.function.Supplier;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public final class ReactiveTypeDescriptor {
    private final Class<?> reactiveType;
    private final boolean multiValue;
    private final boolean noValue;
    @Nullable
    private final Supplier<?> emptyValueSupplier;
    private final boolean deferred;

    private ReactiveTypeDescriptor(Class<?> clazz, boolean bl, boolean bl2, @Nullable Supplier<?> supplier) {
        this(clazz, bl, bl2, supplier, true);
    }

    private ReactiveTypeDescriptor(Class<?> clazz, boolean bl, boolean bl2, @Nullable Supplier<?> supplier, boolean bl3) {
        Assert.notNull(clazz, "'reactiveType' must not be null");
        this.reactiveType = clazz;
        this.multiValue = bl;
        this.noValue = bl2;
        this.emptyValueSupplier = supplier;
        this.deferred = bl3;
    }

    public Class<?> getReactiveType() {
        return this.reactiveType;
    }

    public boolean isMultiValue() {
        return this.multiValue;
    }

    public boolean isNoValue() {
        return this.noValue;
    }

    public boolean supportsEmpty() {
        return this.emptyValueSupplier != null;
    }

    public Object getEmptyValue() {
        Assert.state(this.emptyValueSupplier != null, "Empty values not supported");
        return this.emptyValueSupplier.get();
    }

    public boolean isDeferred() {
        return this.deferred;
    }

    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        return this.reactiveType.equals(((ReactiveTypeDescriptor)object).reactiveType);
    }

    public int hashCode() {
        return this.reactiveType.hashCode();
    }

    public static ReactiveTypeDescriptor multiValue(Class<?> clazz, Supplier<?> supplier) {
        return new ReactiveTypeDescriptor(clazz, true, false, supplier);
    }

    public static ReactiveTypeDescriptor singleOptionalValue(Class<?> clazz, Supplier<?> supplier) {
        return new ReactiveTypeDescriptor(clazz, false, false, supplier);
    }

    public static ReactiveTypeDescriptor singleRequiredValue(Class<?> clazz) {
        return new ReactiveTypeDescriptor(clazz, false, false, null);
    }

    public static ReactiveTypeDescriptor noValue(Class<?> clazz, Supplier<?> supplier) {
        return new ReactiveTypeDescriptor(clazz, false, true, supplier);
    }

    public static ReactiveTypeDescriptor nonDeferredAsyncValue(Class<?> clazz, Supplier<?> supplier) {
        return new ReactiveTypeDescriptor(clazz, false, false, supplier, false);
    }
}

