/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.io.IOException;
import java.io.InputStream;
import org.springframework.core.DecoratingClassLoader;
import org.springframework.lang.Nullable;
import org.springframework.util.FileCopyUtils;

public class OverridingClassLoader
extends DecoratingClassLoader {
    public static final String[] DEFAULT_EXCLUDED_PACKAGES = new String[]{"java.", "javax.", "sun.", "oracle.", "javassist.", "org.aspectj.", "net.sf.cglib."};
    private static final String CLASS_FILE_SUFFIX = ".class";
    @Nullable
    private final ClassLoader overrideDelegate;

    public OverridingClassLoader(@Nullable ClassLoader classLoader) {
        this(classLoader, null);
    }

    public OverridingClassLoader(@Nullable ClassLoader classLoader, @Nullable ClassLoader classLoader2) {
        super(classLoader);
        this.overrideDelegate = classLoader2;
        for (String string : DEFAULT_EXCLUDED_PACKAGES) {
            this.excludePackage(string);
        }
    }

    @Override
    public Class<?> loadClass(String string) throws ClassNotFoundException {
        if (this.overrideDelegate != null && this.isEligibleForOverriding(string)) {
            return this.overrideDelegate.loadClass(string);
        }
        return super.loadClass(string);
    }

    @Override
    protected Class<?> loadClass(String string, boolean bl) throws ClassNotFoundException {
        Class<?> clazz;
        if (this.isEligibleForOverriding(string) && (clazz = this.loadClassForOverriding(string)) != null) {
            if (bl) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
        return super.loadClass(string, bl);
    }

    protected boolean isEligibleForOverriding(String string) {
        return !this.isExcluded(string);
    }

    @Nullable
    protected Class<?> loadClassForOverriding(String string) throws ClassNotFoundException {
        byte[] byArray;
        Class<?> clazz = this.findLoadedClass(string);
        if (clazz == null && (byArray = this.loadBytesForClass(string)) != null) {
            clazz = this.defineClass(string, byArray, 0, byArray.length);
        }
        return clazz;
    }

    @Nullable
    protected byte[] loadBytesForClass(String string) throws ClassNotFoundException {
        InputStream inputStream2 = this.openStreamForClass(string);
        if (inputStream2 == null) {
            return null;
        }
        try {
            byte[] byArray = FileCopyUtils.copyToByteArray(inputStream2);
            return this.transformIfNecessary(string, byArray);
        }
        catch (IOException iOException) {
            throw new ClassNotFoundException("Cannot load resource for class [" + string + "]", iOException);
        }
    }

    @Nullable
    protected InputStream openStreamForClass(String string) {
        String string2 = string.replace('.', '/') + CLASS_FILE_SUFFIX;
        return this.getParent().getResourceAsStream(string2);
    }

    protected byte[] transformIfNecessary(String string, byte[] byArray) {
        return byArray;
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }
}

