/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.springframework.core.Ordered;
import org.springframework.core.PriorityOrdered;
import org.springframework.lang.Nullable;
import org.springframework.util.ObjectUtils;

public class OrderComparator
implements Comparator<Object> {
    public static final OrderComparator INSTANCE = new OrderComparator();

    public Comparator<Object> withSourceProvider(OrderSourceProvider orderSourceProvider) {
        return (object, object2) -> this.doCompare(object, object2, orderSourceProvider);
    }

    @Override
    public int compare(@Nullable Object object, @Nullable Object object2) {
        return this.doCompare(object, object2, null);
    }

    private int doCompare(@Nullable Object object, @Nullable Object object2, @Nullable OrderSourceProvider orderSourceProvider) {
        boolean bl = object instanceof PriorityOrdered;
        boolean bl2 = object2 instanceof PriorityOrdered;
        if (bl && !bl2) {
            return -1;
        }
        if (bl2 && !bl) {
            return 1;
        }
        int n = this.getOrder(object, orderSourceProvider);
        int n2 = this.getOrder(object2, orderSourceProvider);
        return Integer.compare(n, n2);
    }

    private int getOrder(@Nullable Object object, @Nullable OrderSourceProvider orderSourceProvider) {
        Object object2;
        Integer n = null;
        if (object != null && orderSourceProvider != null && (object2 = orderSourceProvider.getOrderSource(object)) != null) {
            if (object2.getClass().isArray()) {
                Object object3;
                Object[] objectArray = ObjectUtils.toObjectArray(object2);
                int n2 = objectArray.length;
                for (int i = 0; i < n2 && (n = this.findOrder(object3 = objectArray[i])) == null; ++i) {
                }
            } else {
                n = this.findOrder(object2);
            }
        }
        return n != null ? n.intValue() : this.getOrder(object);
    }

    protected int getOrder(@Nullable Object object) {
        Integer n;
        if (object != null && (n = this.findOrder(object)) != null) {
            return n;
        }
        return Integer.MAX_VALUE;
    }

    @Nullable
    protected Integer findOrder(Object object) {
        return object instanceof Ordered ? Integer.valueOf(((Ordered)object).getOrder()) : null;
    }

    @Nullable
    public Integer getPriority(Object object) {
        return null;
    }

    public static void sort(List<?> list) {
        if (list.size() > 1) {
            list.sort(INSTANCE);
        }
    }

    public static void sort(Object[] objectArray) {
        if (objectArray.length > 1) {
            Arrays.sort(objectArray, INSTANCE);
        }
    }

    public static void sortIfNecessary(Object object) {
        if (object instanceof Object[]) {
            OrderComparator.sort((Object[])object);
        } else if (object instanceof List) {
            OrderComparator.sort((List)object);
        }
    }

    @FunctionalInterface
    public static interface OrderSourceProvider {
        @Nullable
        public Object getOrderSource(Object var1);
    }
}

