/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import org.springframework.core.NestedExceptionUtils;
import org.springframework.lang.Nullable;

public abstract class NestedRuntimeException
extends RuntimeException {
    private static final long serialVersionUID = 5439915454935047936L;

    public NestedRuntimeException(String string) {
        super(string);
    }

    public NestedRuntimeException(@Nullable String string, @Nullable Throwable throwable) {
        super(string, throwable);
    }

    @Override
    @Nullable
    public String getMessage() {
        return NestedExceptionUtils.buildMessage(super.getMessage(), this.getCause());
    }

    @Nullable
    public Throwable getRootCause() {
        return NestedExceptionUtils.getRootCause(this);
    }

    public Throwable getMostSpecificCause() {
        Throwable throwable = this.getRootCause();
        return throwable != null ? throwable : this;
    }

    public boolean contains(@Nullable Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        if (clazz.isInstance(this)) {
            return true;
        }
        Throwable throwable = this.getCause();
        if (throwable == this) {
            return false;
        }
        if (throwable instanceof NestedRuntimeException) {
            return ((NestedRuntimeException)throwable).contains(clazz);
        }
        while (throwable != null) {
            if (clazz.isInstance(throwable)) {
                return true;
            }
            if (throwable.getCause() == throwable) break;
            throwable = throwable.getCause();
        }
        return false;
    }

    static {
        NestedExceptionUtils.class.getName();
    }
}

