/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class Constants {
    private final String className;
    private final Map<String, Object> fieldCache = new HashMap<String, Object>();

    public Constants(Class<?> clazz) {
        Field[] fieldArray;
        Assert.notNull(clazz, "Class must not be null");
        this.className = clazz.getName();
        for (Field field : fieldArray = clazz.getFields()) {
            if (!ReflectionUtils.isPublicStaticFinal(field)) continue;
            String string = field.getName();
            try {
                Object object = field.get(null);
                this.fieldCache.put(string, object);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    public final String getClassName() {
        return this.className;
    }

    public final int getSize() {
        return this.fieldCache.size();
    }

    protected final Map<String, Object> getFieldCache() {
        return this.fieldCache;
    }

    public Number asNumber(String string) throws ConstantException {
        Object object = this.asObject(string);
        if (!(object instanceof Number)) {
            throw new ConstantException(this.className, string, "not a Number");
        }
        return (Number)object;
    }

    public String asString(String string) throws ConstantException {
        return this.asObject(string).toString();
    }

    public Object asObject(String string) throws ConstantException {
        Assert.notNull((Object)string, "Code must not be null");
        String string2 = string.toUpperCase(Locale.ENGLISH);
        Object object = this.fieldCache.get(string2);
        if (object == null) {
            throw new ConstantException(this.className, string2, "not found");
        }
        return object;
    }

    public Set<String> getNames(@Nullable String string) {
        String string2 = string != null ? string.trim().toUpperCase(Locale.ENGLISH) : "";
        HashSet<String> hashSet = new HashSet<String>();
        for (String string3 : this.fieldCache.keySet()) {
            if (!string3.startsWith(string2)) continue;
            hashSet.add(string3);
        }
        return hashSet;
    }

    public Set<String> getNamesForProperty(String string) {
        return this.getNames(this.propertyToConstantNamePrefix(string));
    }

    public Set<String> getNamesForSuffix(@Nullable String string) {
        String string2 = string != null ? string.trim().toUpperCase(Locale.ENGLISH) : "";
        HashSet<String> hashSet = new HashSet<String>();
        for (String string3 : this.fieldCache.keySet()) {
            if (!string3.endsWith(string2)) continue;
            hashSet.add(string3);
        }
        return hashSet;
    }

    public Set<Object> getValues(@Nullable String string) {
        String string3 = string != null ? string.trim().toUpperCase(Locale.ENGLISH) : "";
        HashSet<Object> hashSet = new HashSet<Object>();
        this.fieldCache.forEach((string2, object) -> {
            if (string2.startsWith(string3)) {
                hashSet.add(object);
            }
        });
        return hashSet;
    }

    public Set<Object> getValuesForProperty(String string) {
        return this.getValues(this.propertyToConstantNamePrefix(string));
    }

    public Set<Object> getValuesForSuffix(@Nullable String string) {
        String string3 = string != null ? string.trim().toUpperCase(Locale.ENGLISH) : "";
        HashSet<Object> hashSet = new HashSet<Object>();
        this.fieldCache.forEach((string2, object) -> {
            if (string2.endsWith(string3)) {
                hashSet.add(object);
            }
        });
        return hashSet;
    }

    public String toCode(Object object, @Nullable String string) throws ConstantException {
        String string2 = string != null ? string.trim().toUpperCase(Locale.ENGLISH) : "";
        for (Map.Entry<String, Object> entry : this.fieldCache.entrySet()) {
            if (!entry.getKey().startsWith(string2) || !entry.getValue().equals(object)) continue;
            return entry.getKey();
        }
        throw new ConstantException(this.className, string2, object);
    }

    public String toCodeForProperty(Object object, String string) throws ConstantException {
        return this.toCode(object, this.propertyToConstantNamePrefix(string));
    }

    public String toCodeForSuffix(Object object, @Nullable String string) throws ConstantException {
        String string2 = string != null ? string.trim().toUpperCase(Locale.ENGLISH) : "";
        for (Map.Entry<String, Object> entry : this.fieldCache.entrySet()) {
            if (!entry.getKey().endsWith(string2) || !entry.getValue().equals(object)) continue;
            return entry.getKey();
        }
        throw new ConstantException(this.className, string2, object);
    }

    public String propertyToConstantNamePrefix(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isUpperCase(c)) {
                stringBuilder.append("_");
                stringBuilder.append(c);
                continue;
            }
            stringBuilder.append(Character.toUpperCase(c));
        }
        return stringBuilder.toString();
    }

    public static class ConstantException
    extends IllegalArgumentException {
        public ConstantException(String string, String string2, String string3) {
            super("Field '" + string2 + "' " + string3 + " in class [" + string + "]");
        }

        public ConstantException(String string, String string2, Object object) {
            super("No '" + string2 + "' field with value '" + object + "' found in class [" + string + "]");
        }
    }
}

