/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;

public class ConfigurableObjectInputStream
extends ObjectInputStream {
    @Nullable
    private final ClassLoader classLoader;
    private final boolean acceptProxyClasses;

    public ConfigurableObjectInputStream(InputStream inputStream2, @Nullable ClassLoader classLoader) throws IOException {
        this(inputStream2, classLoader, true);
    }

    public ConfigurableObjectInputStream(InputStream inputStream2, @Nullable ClassLoader classLoader, boolean bl) throws IOException {
        super(inputStream2);
        this.classLoader = classLoader;
        this.acceptProxyClasses = bl;
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
        try {
            if (this.classLoader != null) {
                return ClassUtils.forName(objectStreamClass.getName(), this.classLoader);
            }
            return super.resolveClass(objectStreamClass);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return this.resolveFallbackIfPossible(objectStreamClass.getName(), classNotFoundException);
        }
    }

    @Override
    protected Class<?> resolveProxyClass(String[] stringArray) throws IOException, ClassNotFoundException {
        if (!this.acceptProxyClasses) {
            throw new NotSerializableException("Not allowed to accept serialized proxy classes");
        }
        if (this.classLoader != null) {
            Class[] classArray = new Class[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    classArray[i] = ClassUtils.forName(stringArray[i], this.classLoader);
                    continue;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    classArray[i] = this.resolveFallbackIfPossible(stringArray[i], classNotFoundException);
                }
            }
            try {
                return ClassUtils.createCompositeInterface(classArray, this.classLoader);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new ClassNotFoundException(null, illegalArgumentException);
            }
        }
        try {
            return super.resolveProxyClass(stringArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Class[] classArray = new Class[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                classArray[i] = this.resolveFallbackIfPossible(stringArray[i], classNotFoundException);
            }
            return ClassUtils.createCompositeInterface(classArray, this.getFallbackClassLoader());
        }
    }

    protected Class<?> resolveFallbackIfPossible(String string, ClassNotFoundException classNotFoundException) throws IOException, ClassNotFoundException {
        throw classNotFoundException;
    }

    @Nullable
    protected ClassLoader getFallbackClassLoader() throws IOException {
        return null;
    }
}

