/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cglib.transform.impl;

import java.lang.reflect.Method;
import org.springframework.asm.Type;
import org.springframework.cglib.core.CodeEmitter;
import org.springframework.cglib.core.Constants;
import org.springframework.cglib.core.EmitUtils;
import org.springframework.cglib.core.MethodInfo;
import org.springframework.cglib.core.ReflectUtils;
import org.springframework.cglib.core.TypeUtils;
import org.springframework.cglib.transform.ClassEmitterTransformer;

public class AddStaticInitTransformer
extends ClassEmitterTransformer {
    private MethodInfo info;

    public AddStaticInitTransformer(Method method) {
        this.info = ReflectUtils.getMethodInfo(method);
        if (!TypeUtils.isStatic(this.info.getModifiers())) {
            throw new IllegalArgumentException(method + " is not static");
        }
        Type[] typeArray = this.info.getSignature().getArgumentTypes();
        if (typeArray.length != 1 || !typeArray[0].equals(Constants.TYPE_CLASS) || !this.info.getSignature().getReturnType().equals(Type.VOID_TYPE)) {
            throw new IllegalArgumentException(method + " illegal signature");
        }
    }

    @Override
    protected void init() {
        if (!TypeUtils.isInterface(this.getAccess())) {
            CodeEmitter codeEmitter = this.getStaticHook();
            EmitUtils.load_class_this(codeEmitter);
            codeEmitter.invoke(this.info);
        }
    }
}

