/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cglib.transform;

import org.springframework.asm.AnnotationVisitor;
import org.springframework.asm.Attribute;
import org.springframework.asm.ClassVisitor;
import org.springframework.asm.FieldVisitor;
import org.springframework.asm.MethodVisitor;
import org.springframework.asm.TypePath;
import org.springframework.cglib.core.Constants;
import org.springframework.cglib.transform.AnnotationVisitorTee;
import org.springframework.cglib.transform.FieldVisitorTee;
import org.springframework.cglib.transform.MethodVisitorTee;

public class ClassVisitorTee
extends ClassVisitor {
    private ClassVisitor cv1;
    private ClassVisitor cv2;

    public ClassVisitorTee(ClassVisitor classVisitor, ClassVisitor classVisitor2) {
        super(Constants.ASM_API);
        this.cv1 = classVisitor;
        this.cv2 = classVisitor2;
    }

    @Override
    public void visit(int n, int n2, String string, String string2, String string3, String[] stringArray) {
        this.cv1.visit(n, n2, string, string2, string3, stringArray);
        this.cv2.visit(n, n2, string, string2, string3, stringArray);
    }

    @Override
    public void visitEnd() {
        this.cv1.visitEnd();
        this.cv2.visitEnd();
        this.cv2 = null;
        this.cv1 = null;
    }

    @Override
    public void visitInnerClass(String string, String string2, String string3, int n) {
        this.cv1.visitInnerClass(string, string2, string3, n);
        this.cv2.visitInnerClass(string, string2, string3, n);
    }

    @Override
    public FieldVisitor visitField(int n, String string, String string2, String string3, Object object) {
        FieldVisitor fieldVisitor = this.cv1.visitField(n, string, string2, string3, object);
        FieldVisitor fieldVisitor2 = this.cv2.visitField(n, string, string2, string3, object);
        if (fieldVisitor == null) {
            return fieldVisitor2;
        }
        if (fieldVisitor2 == null) {
            return fieldVisitor;
        }
        return new FieldVisitorTee(fieldVisitor, fieldVisitor2);
    }

    @Override
    public MethodVisitor visitMethod(int n, String string, String string2, String string3, String[] stringArray) {
        MethodVisitor methodVisitor = this.cv1.visitMethod(n, string, string2, string3, stringArray);
        MethodVisitor methodVisitor2 = this.cv2.visitMethod(n, string, string2, string3, stringArray);
        if (methodVisitor == null) {
            return methodVisitor2;
        }
        if (methodVisitor2 == null) {
            return methodVisitor;
        }
        return new MethodVisitorTee(methodVisitor, methodVisitor2);
    }

    @Override
    public void visitSource(String string, String string2) {
        this.cv1.visitSource(string, string2);
        this.cv2.visitSource(string, string2);
    }

    @Override
    public void visitOuterClass(String string, String string2, String string3) {
        this.cv1.visitOuterClass(string, string2, string3);
        this.cv2.visitOuterClass(string, string2, string3);
    }

    @Override
    public AnnotationVisitor visitAnnotation(String string, boolean bl) {
        return AnnotationVisitorTee.getInstance(this.cv1.visitAnnotation(string, bl), this.cv2.visitAnnotation(string, bl));
    }

    @Override
    public void visitAttribute(Attribute attribute) {
        this.cv1.visitAttribute(attribute);
        this.cv2.visitAttribute(attribute);
    }

    @Override
    public AnnotationVisitor visitTypeAnnotation(int n, TypePath typePath, String string, boolean bl) {
        return AnnotationVisitorTee.getInstance(this.cv1.visitTypeAnnotation(n, typePath, string, bl), this.cv2.visitTypeAnnotation(n, typePath, string, bl));
    }
}

