/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cglib.proxy;

import java.lang.reflect.Method;
import java.util.HashSet;
import org.springframework.asm.ClassVisitor;
import org.springframework.asm.Type;
import org.springframework.cglib.core.ClassEmitter;
import org.springframework.cglib.core.CodeEmitter;
import org.springframework.cglib.core.Constants;
import org.springframework.cglib.core.EmitUtils;
import org.springframework.cglib.core.MethodInfo;
import org.springframework.cglib.core.MethodWrapper;
import org.springframework.cglib.core.ReflectUtils;
import org.springframework.cglib.core.Signature;
import org.springframework.cglib.core.TypeUtils;

class MixinEmitter
extends ClassEmitter {
    private static final String FIELD_NAME = "CGLIB$DELEGATES";
    private static final Signature CSTRUCT_OBJECT_ARRAY = TypeUtils.parseConstructor("Object[]");
    private static final Type MIXIN = TypeUtils.parseType("org.springframework.cglib.proxy.Mixin");
    private static final Signature NEW_INSTANCE = new Signature("newInstance", MIXIN, new Type[]{Constants.TYPE_OBJECT_ARRAY});

    public MixinEmitter(ClassVisitor classVisitor, String string, Class[] classArray, int[] nArray) {
        super(classVisitor);
        this.begin_class(52, 1, string, MIXIN, TypeUtils.getTypes(this.getInterfaces(classArray)), "<generated>");
        EmitUtils.null_constructor(this);
        EmitUtils.factory_method(this, NEW_INSTANCE);
        this.declare_field(2, FIELD_NAME, Constants.TYPE_OBJECT_ARRAY, null);
        CodeEmitter codeEmitter = this.begin_method(1, CSTRUCT_OBJECT_ARRAY, null);
        codeEmitter.load_this();
        codeEmitter.super_invoke_constructor();
        codeEmitter.load_this();
        codeEmitter.load_arg(0);
        codeEmitter.putfield(FIELD_NAME);
        codeEmitter.return_value();
        codeEmitter.end_method();
        HashSet<Object> hashSet = new HashSet<Object>();
        for (int i = 0; i < classArray.length; ++i) {
            Method[] methodArray = this.getMethods(classArray[i]);
            for (int j = 0; j < methodArray.length; ++j) {
                if (!hashSet.add(MethodWrapper.create(methodArray[j]))) continue;
                MethodInfo methodInfo = ReflectUtils.getMethodInfo(methodArray[j]);
                int n = 1;
                if ((methodInfo.getModifiers() & 0x80) == 128) {
                    n |= 0x80;
                }
                codeEmitter = EmitUtils.begin_method(this, methodInfo, n);
                codeEmitter.load_this();
                codeEmitter.getfield(FIELD_NAME);
                codeEmitter.aaload(nArray != null ? nArray[i] : i);
                codeEmitter.checkcast(methodInfo.getClassInfo().getType());
                codeEmitter.load_args();
                codeEmitter.invoke(methodInfo);
                codeEmitter.return_value();
                codeEmitter.end_method();
            }
        }
        this.end_class();
    }

    protected Class[] getInterfaces(Class[] classArray) {
        return classArray;
    }

    protected Method[] getMethods(Class clazz) {
        return clazz.getMethods();
    }
}

