/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cglib.proxy;

import org.springframework.asm.Type;
import org.springframework.cglib.proxy.Callback;
import org.springframework.cglib.proxy.CallbackGenerator;
import org.springframework.cglib.proxy.Dispatcher;
import org.springframework.cglib.proxy.DispatcherGenerator;
import org.springframework.cglib.proxy.FixedValue;
import org.springframework.cglib.proxy.FixedValueGenerator;
import org.springframework.cglib.proxy.InvocationHandler;
import org.springframework.cglib.proxy.InvocationHandlerGenerator;
import org.springframework.cglib.proxy.LazyLoader;
import org.springframework.cglib.proxy.LazyLoaderGenerator;
import org.springframework.cglib.proxy.MethodInterceptor;
import org.springframework.cglib.proxy.MethodInterceptorGenerator;
import org.springframework.cglib.proxy.NoOp;
import org.springframework.cglib.proxy.NoOpGenerator;
import org.springframework.cglib.proxy.ProxyRefDispatcher;

class CallbackInfo {
    private Class cls;
    private CallbackGenerator generator;
    private Type type;
    private static final CallbackInfo[] CALLBACKS = new CallbackInfo[]{new CallbackInfo(NoOp.class, NoOpGenerator.INSTANCE), new CallbackInfo(MethodInterceptor.class, MethodInterceptorGenerator.INSTANCE), new CallbackInfo(InvocationHandler.class, InvocationHandlerGenerator.INSTANCE), new CallbackInfo(LazyLoader.class, LazyLoaderGenerator.INSTANCE), new CallbackInfo(Dispatcher.class, DispatcherGenerator.INSTANCE), new CallbackInfo(FixedValue.class, FixedValueGenerator.INSTANCE), new CallbackInfo(ProxyRefDispatcher.class, DispatcherGenerator.PROXY_REF_INSTANCE)};

    public static Type[] determineTypes(Class[] classArray) {
        return CallbackInfo.determineTypes(classArray, true);
    }

    public static Type[] determineTypes(Class[] classArray, boolean bl) {
        Type[] typeArray = new Type[classArray.length];
        for (int i = 0; i < typeArray.length; ++i) {
            typeArray[i] = CallbackInfo.determineType(classArray[i], bl);
        }
        return typeArray;
    }

    public static Type[] determineTypes(Callback[] callbackArray) {
        return CallbackInfo.determineTypes(callbackArray, true);
    }

    public static Type[] determineTypes(Callback[] callbackArray, boolean bl) {
        Type[] typeArray = new Type[callbackArray.length];
        for (int i = 0; i < typeArray.length; ++i) {
            typeArray[i] = CallbackInfo.determineType(callbackArray[i], bl);
        }
        return typeArray;
    }

    public static CallbackGenerator[] getGenerators(Type[] typeArray) {
        CallbackGenerator[] callbackGeneratorArray = new CallbackGenerator[typeArray.length];
        for (int i = 0; i < callbackGeneratorArray.length; ++i) {
            callbackGeneratorArray[i] = CallbackInfo.getGenerator(typeArray[i]);
        }
        return callbackGeneratorArray;
    }

    private CallbackInfo(Class clazz, CallbackGenerator callbackGenerator) {
        this.cls = clazz;
        this.generator = callbackGenerator;
        this.type = Type.getType(clazz);
    }

    private static Type determineType(Callback callback, boolean bl) {
        if (callback == null) {
            throw new IllegalStateException("Callback is null");
        }
        return CallbackInfo.determineType(callback.getClass(), bl);
    }

    private static Type determineType(Class clazz, boolean bl) {
        Class clazz2 = null;
        Type type = null;
        for (int i = 0; i < CALLBACKS.length; ++i) {
            CallbackInfo callbackInfo = CALLBACKS[i];
            if (!callbackInfo.cls.isAssignableFrom(clazz)) continue;
            if (clazz2 != null) {
                throw new IllegalStateException("Callback implements both " + clazz2 + " and " + callbackInfo.cls);
            }
            clazz2 = callbackInfo.cls;
            type = callbackInfo.type;
            if (!bl) break;
        }
        if (clazz2 == null) {
            throw new IllegalStateException("Unknown callback type " + clazz);
        }
        return type;
    }

    private static CallbackGenerator getGenerator(Type type) {
        for (int i = 0; i < CALLBACKS.length; ++i) {
            CallbackInfo callbackInfo = CALLBACKS[i];
            if (!callbackInfo.type.equals(type)) continue;
            return callbackInfo.generator;
        }
        throw new IllegalStateException("Unknown callback type " + type);
    }
}

