/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cglib.beans;

import java.beans.PropertyDescriptor;
import java.security.ProtectionDomain;
import java.util.HashMap;
import java.util.Map;
import org.springframework.asm.ClassVisitor;
import org.springframework.asm.Type;
import org.springframework.cglib.core.AbstractClassGenerator;
import org.springframework.cglib.core.ClassEmitter;
import org.springframework.cglib.core.Constants;
import org.springframework.cglib.core.EmitUtils;
import org.springframework.cglib.core.KeyFactory;
import org.springframework.cglib.core.ReflectUtils;

public class BeanGenerator
extends AbstractClassGenerator {
    private static final AbstractClassGenerator.Source SOURCE = new AbstractClassGenerator.Source(BeanGenerator.class.getName());
    private static final BeanGeneratorKey KEY_FACTORY = (BeanGeneratorKey)((Object)KeyFactory.create(BeanGeneratorKey.class));
    private Class superclass;
    private Map props = new HashMap();
    private boolean classOnly;

    public BeanGenerator() {
        super(SOURCE);
    }

    public void setSuperclass(Class clazz) {
        if (clazz != null && clazz.equals(Object.class)) {
            clazz = null;
        }
        this.superclass = clazz;
    }

    public void addProperty(String string, Class clazz) {
        if (this.props.containsKey(string)) {
            throw new IllegalArgumentException("Duplicate property name \"" + string + "\"");
        }
        this.props.put(string, Type.getType(clazz));
    }

    @Override
    protected ClassLoader getDefaultClassLoader() {
        if (this.superclass != null) {
            return this.superclass.getClassLoader();
        }
        return null;
    }

    @Override
    protected ProtectionDomain getProtectionDomain() {
        return ReflectUtils.getProtectionDomain(this.superclass);
    }

    public Object create() {
        this.classOnly = false;
        return this.createHelper();
    }

    public Object createClass() {
        this.classOnly = true;
        return this.createHelper();
    }

    private Object createHelper() {
        if (this.superclass != null) {
            this.setNamePrefix(this.superclass.getName());
        }
        String string = this.superclass != null ? this.superclass.getName() : "java.lang.Object";
        Object object = KEY_FACTORY.newInstance(string, this.props);
        return super.create(object);
    }

    @Override
    public void generateClass(ClassVisitor classVisitor) throws Exception {
        int n = this.props.size();
        String[] stringArray = this.props.keySet().toArray(new String[n]);
        Type[] typeArray = new Type[n];
        for (int i = 0; i < n; ++i) {
            typeArray[i] = (Type)this.props.get(stringArray[i]);
        }
        ClassEmitter classEmitter = new ClassEmitter(classVisitor);
        classEmitter.begin_class(52, 1, this.getClassName(), this.superclass != null ? Type.getType(this.superclass) : Constants.TYPE_OBJECT, null, null);
        EmitUtils.null_constructor(classEmitter);
        EmitUtils.add_properties(classEmitter, stringArray, typeArray);
        classEmitter.end_class();
    }

    @Override
    protected Object firstInstance(Class clazz) {
        if (this.classOnly) {
            return clazz;
        }
        return ReflectUtils.newInstance(clazz);
    }

    @Override
    protected Object nextInstance(Object object) {
        Class<?> clazz;
        Class<?> clazz2 = clazz = object instanceof Class ? (Class<?>)object : object.getClass();
        if (this.classOnly) {
            return clazz;
        }
        return ReflectUtils.newInstance(clazz);
    }

    public static void addProperties(BeanGenerator beanGenerator, Map map) {
        for (String string : map.keySet()) {
            beanGenerator.addProperty(string, (Class)map.get(string));
        }
    }

    public static void addProperties(BeanGenerator beanGenerator, Class clazz) {
        BeanGenerator.addProperties(beanGenerator, ReflectUtils.getBeanProperties(clazz));
    }

    public static void addProperties(BeanGenerator beanGenerator, PropertyDescriptor[] propertyDescriptorArray) {
        for (int i = 0; i < propertyDescriptorArray.length; ++i) {
            beanGenerator.addProperty(propertyDescriptorArray[i].getName(), propertyDescriptorArray[i].getPropertyType());
        }
    }

    static interface BeanGeneratorKey {
        public Object newInstance(String var1, Map var2);
    }
}

