/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.asm;

import org.springframework.asm.AnnotationVisitor;
import org.springframework.asm.AnnotationWriter;
import org.springframework.asm.Attribute;
import org.springframework.asm.ByteVector;
import org.springframework.asm.RecordComponentVisitor;
import org.springframework.asm.SymbolTable;
import org.springframework.asm.TypePath;

final class RecordComponentWriter
extends RecordComponentVisitor {
    private final SymbolTable symbolTable;
    private final int accessFlags;
    private final int nameIndex;
    private final int descriptorIndex;
    private int signatureIndex;
    private AnnotationWriter lastRuntimeVisibleAnnotation;
    private AnnotationWriter lastRuntimeInvisibleAnnotation;
    private AnnotationWriter lastRuntimeVisibleTypeAnnotation;
    private AnnotationWriter lastRuntimeInvisibleTypeAnnotation;
    private Attribute firstAttribute;

    RecordComponentWriter(SymbolTable symbolTable, int n, String string, String string2, String string3) {
        super(458752);
        this.symbolTable = symbolTable;
        this.accessFlags = n;
        this.nameIndex = symbolTable.addConstantUtf8(string);
        this.descriptorIndex = symbolTable.addConstantUtf8(string2);
        if (string3 != null) {
            this.signatureIndex = symbolTable.addConstantUtf8(string3);
        }
    }

    @Override
    public AnnotationVisitor visitAnnotationExperimental(String string, boolean bl) {
        if (bl) {
            this.lastRuntimeVisibleAnnotation = AnnotationWriter.create(this.symbolTable, string, this.lastRuntimeVisibleAnnotation);
            return this.lastRuntimeVisibleAnnotation;
        }
        this.lastRuntimeInvisibleAnnotation = AnnotationWriter.create(this.symbolTable, string, this.lastRuntimeInvisibleAnnotation);
        return this.lastRuntimeInvisibleAnnotation;
    }

    @Override
    public AnnotationVisitor visitTypeAnnotationExperimental(int n, TypePath typePath, String string, boolean bl) {
        if (bl) {
            this.lastRuntimeVisibleTypeAnnotation = AnnotationWriter.create(this.symbolTable, n, typePath, string, this.lastRuntimeVisibleTypeAnnotation);
            return this.lastRuntimeVisibleTypeAnnotation;
        }
        this.lastRuntimeInvisibleTypeAnnotation = AnnotationWriter.create(this.symbolTable, n, typePath, string, this.lastRuntimeInvisibleTypeAnnotation);
        return this.lastRuntimeInvisibleTypeAnnotation;
    }

    @Override
    public void visitAttributeExperimental(Attribute attribute) {
        attribute.nextAttribute = this.firstAttribute;
        this.firstAttribute = attribute;
    }

    @Override
    public void visitEndExperimental() {
    }

    int computeRecordComponentInfoSize() {
        int n = 6;
        n += Attribute.computeAttributesSize(this.symbolTable, this.accessFlags & 0x20000, this.signatureIndex);
        n += AnnotationWriter.computeAnnotationsSize(this.lastRuntimeVisibleAnnotation, this.lastRuntimeInvisibleAnnotation, this.lastRuntimeVisibleTypeAnnotation, this.lastRuntimeInvisibleTypeAnnotation);
        if (this.firstAttribute != null) {
            n += this.firstAttribute.computeAttributesSize(this.symbolTable);
        }
        return n;
    }

    void putRecordComponentInfo(ByteVector byteVector) {
        byteVector.putShort(this.nameIndex).putShort(this.descriptorIndex);
        int n = 0;
        if (this.signatureIndex != 0) {
            ++n;
        }
        if ((this.accessFlags & 0x20000) != 0) {
            ++n;
        }
        if (this.lastRuntimeVisibleAnnotation != null) {
            ++n;
        }
        if (this.lastRuntimeInvisibleAnnotation != null) {
            ++n;
        }
        if (this.lastRuntimeVisibleTypeAnnotation != null) {
            ++n;
        }
        if (this.lastRuntimeInvisibleTypeAnnotation != null) {
            ++n;
        }
        if (this.firstAttribute != null) {
            n += this.firstAttribute.getAttributeCount();
        }
        byteVector.putShort(n);
        Attribute.putAttributes(this.symbolTable, this.accessFlags, this.signatureIndex, byteVector);
        AnnotationWriter.putAnnotations(this.symbolTable, this.lastRuntimeVisibleAnnotation, this.lastRuntimeInvisibleAnnotation, this.lastRuntimeVisibleTypeAnnotation, this.lastRuntimeInvisibleTypeAnnotation, byteVector);
        if (this.firstAttribute != null) {
            this.firstAttribute.putAttributes(this.symbolTable, byteVector);
        }
    }

    final void collectAttributePrototypes(Attribute.Set set) {
        set.addAttributes(this.firstAttribute);
    }
}

