/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.logging.impl;

import org.apache.avalon.framework.logger.Logger;
import org.apache.commons.logging.Log;

public class AvalonLogger
implements Log {
    private static volatile Logger defaultLogger = null;
    private final transient Logger logger;

    public AvalonLogger(Logger logger) {
        this.logger = logger;
    }

    public AvalonLogger(String string) {
        if (defaultLogger == null) {
            throw new NullPointerException("default logger has to be specified if this constructor is used!");
        }
        this.logger = defaultLogger.getChildLogger(string);
    }

    public Logger getLogger() {
        return this.logger;
    }

    public static void setDefaultLogger(Logger logger) {
        defaultLogger = logger;
    }

    @Override
    public void debug(Object object, Throwable throwable) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug(String.valueOf(object), throwable);
        }
    }

    @Override
    public void debug(Object object) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug(String.valueOf(object));
        }
    }

    @Override
    public void error(Object object, Throwable throwable) {
        if (this.getLogger().isErrorEnabled()) {
            this.getLogger().error(String.valueOf(object), throwable);
        }
    }

    @Override
    public void error(Object object) {
        if (this.getLogger().isErrorEnabled()) {
            this.getLogger().error(String.valueOf(object));
        }
    }

    @Override
    public void fatal(Object object, Throwable throwable) {
        if (this.getLogger().isFatalErrorEnabled()) {
            this.getLogger().fatalError(String.valueOf(object), throwable);
        }
    }

    @Override
    public void fatal(Object object) {
        if (this.getLogger().isFatalErrorEnabled()) {
            this.getLogger().fatalError(String.valueOf(object));
        }
    }

    @Override
    public void info(Object object, Throwable throwable) {
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info(String.valueOf(object), throwable);
        }
    }

    @Override
    public void info(Object object) {
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info(String.valueOf(object));
        }
    }

    @Override
    public boolean isDebugEnabled() {
        return this.getLogger().isDebugEnabled();
    }

    @Override
    public boolean isErrorEnabled() {
        return this.getLogger().isErrorEnabled();
    }

    @Override
    public boolean isFatalEnabled() {
        return this.getLogger().isFatalErrorEnabled();
    }

    @Override
    public boolean isInfoEnabled() {
        return this.getLogger().isInfoEnabled();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.getLogger().isDebugEnabled();
    }

    @Override
    public boolean isWarnEnabled() {
        return this.getLogger().isWarnEnabled();
    }

    @Override
    public void trace(Object object, Throwable throwable) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug(String.valueOf(object), throwable);
        }
    }

    @Override
    public void trace(Object object) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug(String.valueOf(object));
        }
    }

    @Override
    public void warn(Object object, Throwable throwable) {
        if (this.getLogger().isWarnEnabled()) {
            this.getLogger().warn(String.valueOf(object), throwable);
        }
    }

    @Override
    public void warn(Object object) {
        if (this.getLogger().isWarnEnabled()) {
            this.getLogger().warn(String.valueOf(object));
        }
    }
}

