/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.file;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.io.file.Counters;
import org.apache.commons.io.file.CountingPathVisitor;
import org.apache.commons.io.file.DeleteOption;
import org.apache.commons.io.file.PathUtils;
import org.apache.commons.io.file.StandardDeleteOption;

public class DeletingPathVisitor
extends CountingPathVisitor {
    private final String[] skip;
    private final boolean overrideReadOnly;
    private final LinkOption[] linkOptions;

    public static DeletingPathVisitor withBigIntegerCounters() {
        return new DeletingPathVisitor(Counters.bigIntegerPathCounters(), new String[0]);
    }

    public static DeletingPathVisitor withLongCounters() {
        return new DeletingPathVisitor(Counters.longPathCounters(), new String[0]);
    }

    public DeletingPathVisitor(Counters.PathCounters pathCounters, DeleteOption[] deleteOptionArray, String ... stringArray) {
        this(pathCounters, PathUtils.NOFOLLOW_LINK_OPTION_ARRAY, deleteOptionArray, stringArray);
    }

    public DeletingPathVisitor(Counters.PathCounters pathCounters, LinkOption[] linkOptionArray, DeleteOption[] deleteOptionArray, String ... stringArray) {
        super(pathCounters);
        Object[] objectArray = stringArray != null ? (String[])stringArray.clone() : EMPTY_STRING_ARRAY;
        Arrays.sort(objectArray);
        this.skip = objectArray;
        this.overrideReadOnly = StandardDeleteOption.overrideReadOnly(deleteOptionArray);
        this.linkOptions = linkOptionArray == null ? PathUtils.NOFOLLOW_LINK_OPTION_ARRAY : (LinkOption[])linkOptionArray.clone();
    }

    public DeletingPathVisitor(Counters.PathCounters pathCounters, String ... stringArray) {
        this(pathCounters, PathUtils.EMPTY_DELETE_OPTION_ARRAY, stringArray);
    }

    private boolean accept(Path path) {
        return Arrays.binarySearch(this.skip, Objects.toString(path.getFileName(), null)) < 0;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        DeletingPathVisitor deletingPathVisitor = (DeletingPathVisitor)object;
        return this.overrideReadOnly == deletingPathVisitor.overrideReadOnly && Arrays.equals(this.skip, deletingPathVisitor.skip);
    }

    @Override
    public int hashCode() {
        int n = 31;
        int n2 = super.hashCode();
        n2 = 31 * n2 + Arrays.hashCode(this.skip);
        n2 = 31 * n2 + Objects.hash(this.overrideReadOnly);
        return n2;
    }

    @Override
    public FileVisitResult postVisitDirectory(Path path, IOException iOException) throws IOException {
        if (PathUtils.isEmptyDirectory(path)) {
            Files.deleteIfExists(path);
        }
        return super.postVisitDirectory(path, iOException);
    }

    @Override
    public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
        super.preVisitDirectory(path, basicFileAttributes);
        return this.accept(path) ? FileVisitResult.CONTINUE : FileVisitResult.SKIP_SUBTREE;
    }

    @Override
    public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
        if (this.accept(path)) {
            if (Files.exists(path, this.linkOptions)) {
                if (this.overrideReadOnly) {
                    PathUtils.setReadOnly(path, false, this.linkOptions);
                }
                Files.deleteIfExists(path);
            }
            if (Files.isSymbolicLink(path)) {
                try {
                    Files.delete(path);
                }
                catch (NoSuchFileException noSuchFileException) {
                    // empty catch block
                }
            }
        }
        this.updateFileCounters(path, basicFileAttributes);
        return FileVisitResult.CONTINUE;
    }
}

