/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.Closeable;
import java.util.Iterator;
import java.util.Objects;
import java.util.stream.Stream;

class StreamIterator<E>
implements Closeable,
Iterator<E> {
    private final Iterator<E> iterator;
    private final Stream<E> stream;

    public static <T> Iterator<T> iterator(Stream<T> stream) {
        return new StreamIterator<T>(stream).iterator;
    }

    private StreamIterator(Stream<E> stream) {
        this.stream = Objects.requireNonNull(stream, "stream");
        this.iterator = stream.iterator();
    }

    @Override
    public boolean hasNext() {
        boolean bl = this.iterator.hasNext();
        if (!bl) {
            this.close();
        }
        return bl;
    }

    @Override
    public E next() {
        E e = this.iterator.next();
        if (e == null) {
            this.close();
        }
        return e;
    }

    @Override
    public void close() {
        this.stream.close();
    }
}

