/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.net;

import java.nio.ByteBuffer;
import java.util.BitSet;
import org.apache.commons.codec.BinaryDecoder;
import org.apache.commons.codec.BinaryEncoder;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.net.Utils;

public class PercentCodec
implements BinaryDecoder,
BinaryEncoder {
    private static final byte ESCAPE_CHAR = 37;
    private final BitSet alwaysEncodeChars = new BitSet();
    private final boolean plusForSpace;
    private int alwaysEncodeCharsMin = Integer.MAX_VALUE;
    private int alwaysEncodeCharsMax = Integer.MIN_VALUE;

    public PercentCodec() {
        this.plusForSpace = false;
        this.insertAlwaysEncodeChar((byte)37);
    }

    public PercentCodec(byte[] byArray, boolean bl) {
        this.plusForSpace = bl;
        this.insertAlwaysEncodeChars(byArray);
    }

    private void insertAlwaysEncodeChars(byte[] byArray) {
        if (byArray != null) {
            for (byte by : byArray) {
                this.insertAlwaysEncodeChar(by);
            }
        }
        this.insertAlwaysEncodeChar((byte)37);
    }

    private void insertAlwaysEncodeChar(byte by) {
        this.alwaysEncodeChars.set(by);
        if (by < this.alwaysEncodeCharsMin) {
            this.alwaysEncodeCharsMin = by;
        }
        if (by > this.alwaysEncodeCharsMax) {
            this.alwaysEncodeCharsMax = by;
        }
    }

    @Override
    public byte[] encode(byte[] byArray) throws EncoderException {
        boolean bl;
        if (byArray == null) {
            return null;
        }
        int n = this.expectedEncodingBytes(byArray);
        boolean bl2 = bl = n != byArray.length;
        if (bl || this.plusForSpace && this.containsSpace(byArray)) {
            return this.doEncode(byArray, n, bl);
        }
        return byArray;
    }

    private byte[] doEncode(byte[] byArray, int n, boolean bl) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(n);
        for (byte by : byArray) {
            if (bl && this.canEncode(by)) {
                byte by2 = by;
                if (by2 < 0) {
                    by2 = (byte)(256 + by2);
                }
                char c = Utils.hexDigit(by2 >> 4);
                char c2 = Utils.hexDigit(by2);
                byteBuffer.put((byte)37);
                byteBuffer.put((byte)c);
                byteBuffer.put((byte)c2);
                continue;
            }
            if (this.plusForSpace && by == 32) {
                byteBuffer.put((byte)43);
                continue;
            }
            byteBuffer.put(by);
        }
        return byteBuffer.array();
    }

    private int expectedEncodingBytes(byte[] byArray) {
        int n = 0;
        for (byte by : byArray) {
            n += this.canEncode(by) ? 3 : 1;
        }
        return n;
    }

    private boolean containsSpace(byte[] byArray) {
        for (byte by : byArray) {
            if (by != 32) continue;
            return true;
        }
        return false;
    }

    private boolean canEncode(byte by) {
        return !this.isAsciiChar(by) || this.inAlwaysEncodeCharsRange(by) && this.alwaysEncodeChars.get(by);
    }

    private boolean inAlwaysEncodeCharsRange(byte by) {
        return by >= this.alwaysEncodeCharsMin && by <= this.alwaysEncodeCharsMax;
    }

    private boolean isAsciiChar(byte by) {
        return by >= 0;
    }

    @Override
    public byte[] decode(byte[] byArray) throws DecoderException {
        if (byArray == null) {
            return null;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(this.expectedDecodingBytes(byArray));
        for (int i = 0; i < byArray.length; ++i) {
            byte by = byArray[i];
            if (by == 37) {
                try {
                    int n = Utils.digit16(byArray[++i]);
                    int n2 = Utils.digit16(byArray[++i]);
                    byteBuffer.put((byte)((n << 4) + n2));
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    throw new DecoderException("Invalid percent decoding: ", arrayIndexOutOfBoundsException);
                }
            }
            if (this.plusForSpace && by == 43) {
                byteBuffer.put((byte)32);
                continue;
            }
            byteBuffer.put(by);
        }
        return byteBuffer.array();
    }

    private int expectedDecodingBytes(byte[] byArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < byArray.length) {
            byte by;
            n2 += (by = byArray[n2]) == 37 ? 3 : 1;
            ++n;
        }
        return n;
    }

    @Override
    public Object encode(Object object) throws EncoderException {
        if (object == null) {
            return null;
        }
        if (object instanceof byte[]) {
            return this.encode((byte[])object);
        }
        throw new EncoderException("Objects of type " + object.getClass().getName() + " cannot be Percent encoded");
    }

    @Override
    public Object decode(Object object) throws DecoderException {
        if (object == null) {
            return null;
        }
        if (object instanceof byte[]) {
            return this.decode((byte[])object);
        }
        throw new DecoderException("Objects of type " + object.getClass().getName() + " cannot be Percent decoded");
    }
}

