/*
 * Decompiled with CFR 0.152.
 */
package okio.internal;

import java.io.EOFException;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import okio.-Platform;
import okio.-Util;
import okio.Buffer;
import okio.ByteString;
import okio.Options;
import okio.Segment;
import okio.SegmentPool;
import okio.SegmentedByteString;
import okio.Sink;
import okio.Source;
import okio.internal._Utf8Kt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000v\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a0\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\bH\u0000\u001a\r\u0010\u0011\u001a\u00020\u0012*\u00020\u0013H\u0080\b\u001a\r\u0010\u0014\u001a\u00020\u0005*\u00020\u0013H\u0080\b\u001a\r\u0010\u0015\u001a\u00020\u0013*\u00020\u0013H\u0080\b\u001a%\u0010\u0016\u001a\u00020\u0013*\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u0005H\u0080\b\u001a\u0017\u0010\u001a\u001a\u00020\n*\u00020\u00132\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0080\b\u001a\u0015\u0010\u001d\u001a\u00020\u001e*\u00020\u00132\u0006\u0010\u001f\u001a\u00020\u0005H\u0080\b\u001a\r\u0010 \u001a\u00020\b*\u00020\u0013H\u0080\b\u001a%\u0010!\u001a\u00020\u0005*\u00020\u00132\u0006\u0010\"\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020\u00052\u0006\u0010$\u001a\u00020\u0005H\u0080\b\u001a\u001d\u0010!\u001a\u00020\u0005*\u00020\u00132\u0006\u0010\u000e\u001a\u00020%2\u0006\u0010#\u001a\u00020\u0005H\u0080\b\u001a\u001d\u0010&\u001a\u00020\u0005*\u00020\u00132\u0006\u0010'\u001a\u00020%2\u0006\u0010#\u001a\u00020\u0005H\u0080\b\u001a-\u0010(\u001a\u00020\n*\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020%2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\bH\u0080\b\u001a\u0015\u0010)\u001a\u00020\b*\u00020\u00132\u0006\u0010*\u001a\u00020\u0001H\u0080\b\u001a%\u0010)\u001a\u00020\b*\u00020\u00132\u0006\u0010*\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\bH\u0080\b\u001a\u001d\u0010)\u001a\u00020\u0005*\u00020\u00132\u0006\u0010*\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0005H\u0080\b\u001a\u0015\u0010+\u001a\u00020\u0005*\u00020\u00132\u0006\u0010*\u001a\u00020,H\u0080\b\u001a\r\u0010-\u001a\u00020\u001e*\u00020\u0013H\u0080\b\u001a\r\u0010.\u001a\u00020\u0001*\u00020\u0013H\u0080\b\u001a\u0015\u0010.\u001a\u00020\u0001*\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0005H\u0080\b\u001a\r\u0010/\u001a\u00020%*\u00020\u0013H\u0080\b\u001a\u0015\u0010/\u001a\u00020%*\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0005H\u0080\b\u001a\r\u00100\u001a\u00020\u0005*\u00020\u0013H\u0080\b\u001a\u0015\u00101\u001a\u00020\u0012*\u00020\u00132\u0006\u0010*\u001a\u00020\u0001H\u0080\b\u001a\u001d\u00101\u001a\u00020\u0012*\u00020\u00132\u0006\u0010*\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0005H\u0080\b\u001a\r\u00102\u001a\u00020\u0005*\u00020\u0013H\u0080\b\u001a\r\u00103\u001a\u00020\b*\u00020\u0013H\u0080\b\u001a\r\u00104\u001a\u00020\u0005*\u00020\u0013H\u0080\b\u001a\r\u00105\u001a\u000206*\u00020\u0013H\u0080\b\u001a\u0015\u00107\u001a\u000208*\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0005H\u0080\b\u001a\r\u00109\u001a\u00020\b*\u00020\u0013H\u0080\b\u001a\u000f\u0010:\u001a\u0004\u0018\u000108*\u00020\u0013H\u0080\b\u001a\u0015\u0010;\u001a\u000208*\u00020\u00132\u0006\u0010<\u001a\u00020\u0005H\u0080\b\u001a\u0015\u0010=\u001a\u00020\b*\u00020\u00132\u0006\u0010>\u001a\u00020?H\u0080\b\u001a\u0015\u0010@\u001a\u00020\u0012*\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0005H\u0080\b\u001a\r\u0010A\u001a\u00020%*\u00020\u0013H\u0080\b\u001a\u0015\u0010A\u001a\u00020%*\u00020\u00132\u0006\u0010\u0019\u001a\u00020\bH\u0080\b\u001a\u0015\u0010B\u001a\u00020\f*\u00020\u00132\u0006\u0010C\u001a\u00020\bH\u0080\b\u001a\u0015\u0010D\u001a\u00020\u0013*\u00020\u00132\u0006\u0010E\u001a\u00020\u0001H\u0080\b\u001a%\u0010D\u001a\u00020\u0013*\u00020\u00132\u0006\u0010E\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\bH\u0080\b\u001a\u001d\u0010D\u001a\u00020\u0012*\u00020\u00132\u0006\u0010E\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0005H\u0080\b\u001a)\u0010D\u001a\u00020\u0013*\u00020\u00132\u0006\u0010F\u001a\u00020%2\b\b\u0002\u0010\u0018\u001a\u00020\b2\b\b\u0002\u0010\u0019\u001a\u00020\bH\u0080\b\u001a\u001d\u0010D\u001a\u00020\u0013*\u00020\u00132\u0006\u0010E\u001a\u00020G2\u0006\u0010\u0019\u001a\u00020\u0005H\u0080\b\u001a\u0015\u0010H\u001a\u00020\u0005*\u00020\u00132\u0006\u0010E\u001a\u00020GH\u0080\b\u001a\u0015\u0010I\u001a\u00020\u0013*\u00020\u00132\u0006\u0010\"\u001a\u00020\bH\u0080\b\u001a\u0015\u0010J\u001a\u00020\u0013*\u00020\u00132\u0006\u0010K\u001a\u00020\u0005H\u0080\b\u001a\u0015\u0010L\u001a\u00020\u0013*\u00020\u00132\u0006\u0010K\u001a\u00020\u0005H\u0080\b\u001a\u0015\u0010M\u001a\u00020\u0013*\u00020\u00132\u0006\u0010N\u001a\u00020\bH\u0080\b\u001a\u0015\u0010O\u001a\u00020\u0013*\u00020\u00132\u0006\u0010K\u001a\u00020\u0005H\u0080\b\u001a\u0015\u0010P\u001a\u00020\u0013*\u00020\u00132\u0006\u0010Q\u001a\u00020\bH\u0080\b\u001a%\u0010R\u001a\u00020\u0013*\u00020\u00132\u0006\u0010S\u001a\u0002082\u0006\u0010T\u001a\u00020\b2\u0006\u0010U\u001a\u00020\bH\u0080\b\u001a\u0015\u0010V\u001a\u00020\u0013*\u00020\u00132\u0006\u0010W\u001a\u00020\bH\u0080\b\u001a\u0014\u0010X\u001a\u000208*\u00020\u00132\u0006\u0010Y\u001a\u00020\u0005H\u0000\u001a?\u0010Z\u001a\u0002H[\"\u0004\b\u0000\u0010[*\u00020\u00132\u0006\u0010#\u001a\u00020\u00052\u001a\u0010\\\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\f\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u0002H[0]H\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010^\u001a\u001e\u0010_\u001a\u00020\b*\u00020\u00132\u0006\u0010>\u001a\u00020?2\b\b\u0002\u0010`\u001a\u00020\nH\u0000\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\bX\u0080T\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006a"}, d2={"HEX_DIGIT_BYTES", "", "getHEX_DIGIT_BYTES", "()[B", "OVERFLOW_DIGIT_START", "", "OVERFLOW_ZONE", "SEGMENTING_THRESHOLD", "", "rangeEquals", "", "segment", "Lokio/Segment;", "segmentPos", "bytes", "bytesOffset", "bytesLimit", "commonClear", "", "Lokio/Buffer;", "commonCompleteSegmentByteCount", "commonCopy", "commonCopyTo", "out", "offset", "byteCount", "commonEquals", "other", "", "commonGet", "", "pos", "commonHashCode", "commonIndexOf", "b", "fromIndex", "toIndex", "Lokio/ByteString;", "commonIndexOfElement", "targetBytes", "commonRangeEquals", "commonRead", "sink", "commonReadAll", "Lokio/Sink;", "commonReadByte", "commonReadByteArray", "commonReadByteString", "commonReadDecimalLong", "commonReadFully", "commonReadHexadecimalUnsignedLong", "commonReadInt", "commonReadLong", "commonReadShort", "", "commonReadUtf8", "", "commonReadUtf8CodePoint", "commonReadUtf8Line", "commonReadUtf8LineStrict", "limit", "commonSelect", "options", "Lokio/Options;", "commonSkip", "commonSnapshot", "commonWritableSegment", "minimumCapacity", "commonWrite", "source", "byteString", "Lokio/Source;", "commonWriteAll", "commonWriteByte", "commonWriteDecimalLong", "v", "commonWriteHexadecimalUnsignedLong", "commonWriteInt", "i", "commonWriteLong", "commonWriteShort", "s", "commonWriteUtf8", "string", "beginIndex", "endIndex", "commonWriteUtf8CodePoint", "codePoint", "readUtf8Line", "newline", "seek", "T", "lambda", "Lkotlin/Function2;", "(Lokio/Buffer;JLkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "selectPrefix", "selectTruncated", "okio"})
public final class BufferKt {
    @NotNull
    private static final byte[] HEX_DIGIT_BYTES = -Platform.asUtf8ToByteArray("0123456789abcdef");
    public static final int SEGMENTING_THRESHOLD = 4096;
    public static final long OVERFLOW_ZONE = -922337203685477580L;
    public static final long OVERFLOW_DIGIT_START = -7L;

    @NotNull
    public static final byte[] getHEX_DIGIT_BYTES() {
        return HEX_DIGIT_BYTES;
    }

    public static final boolean rangeEquals(@NotNull Segment segment, int n, @NotNull byte[] byArray, int n2, int n3) {
        Intrinsics.checkNotNullParameter(segment, "segment");
        Intrinsics.checkNotNullParameter(byArray, "bytes");
        Segment segment2 = segment;
        int n4 = n;
        int n5 = segment2.limit;
        byte[] byArray2 = segment2.data;
        for (int i = n2; i < n3; ++i) {
            if (n4 == n5) {
                Intrinsics.checkNotNull(segment2.next);
                byArray2 = segment2.data;
                n4 = segment2.pos;
                n5 = segment2.limit;
            }
            if (byArray2[n4] != byArray[i]) {
                return false;
            }
            ++n4;
        }
        return true;
    }

    @NotNull
    public static final String readUtf8Line(@NotNull Buffer buffer, long l) {
        String string;
        Intrinsics.checkNotNullParameter(buffer, "$this$readUtf8Line");
        if (l > 0L && buffer.getByte(l - 1L) == (byte)13) {
            String string2 = buffer.readUtf8(l - 1L);
            buffer.skip(2L);
            string = string2;
        } else {
            String string3 = buffer.readUtf8(l);
            buffer.skip(1L);
            string = string3;
        }
        return string;
    }

    public static final <T> T seek(@NotNull Buffer buffer, long l, @NotNull Function2<? super Segment, ? super Long, ? extends T> function2) {
        long l2;
        int n = 0;
        Intrinsics.checkNotNullParameter(buffer, "$this$seek");
        Intrinsics.checkNotNullParameter(function2, "lambda");
        Segment segment = buffer.head;
        if (segment == null) {
            return function2.invoke(null, -1L);
        }
        Segment segment2 = segment;
        if (buffer.size() - l < l) {
            long l3;
            for (l3 = buffer.size(); l3 > l; l3 -= (long)(segment2.limit - segment2.pos)) {
                Intrinsics.checkNotNull(segment2.prev);
            }
            return function2.invoke(segment2, l3);
        }
        long l4 = 0L;
        while ((l2 = l4 + (long)(segment2.limit - segment2.pos)) <= l) {
            Intrinsics.checkNotNull(segment2.next);
            l4 = l2;
        }
        return function2.invoke(segment2, l4);
    }

    public static final int selectPrefix(@NotNull Buffer buffer, @NotNull Options options, boolean bl) {
        Segment segment;
        Intrinsics.checkNotNullParameter(buffer, "$this$selectPrefix");
        Intrinsics.checkNotNullParameter(options, "options");
        Segment segment2 = buffer.head;
        if (segment2 == null) {
            return bl ? -2 : -1;
        }
        Segment segment3 = segment = segment2;
        byte[] byArray = segment.data;
        int n = segment.pos;
        int n2 = segment.limit;
        int[] nArray = options.getTrie$okio();
        int n3 = 0;
        int n4 = -1;
        block0: while (true) {
            int n5;
            int n6;
            int n7;
            int n8;
            int n9;
            int n10;
            int n11 = nArray[n3++];
            if ((n10 = nArray[n3++]) != -1) {
                n4 = n10;
            }
            int n12 = 0;
            if (segment3 == null) break;
            if (n11 < 0) {
                n9 = -1 * n11;
                n8 = n3 + n9;
                do {
                    n7 = byArray[n++];
                    n6 = 255;
                    boolean bl2 = false;
                    n5 = n7 & n6;
                    if (n5 != nArray[n3++]) {
                        return n4;
                    }
                    int n13 = n7 = n3 == n8 ? 1 : 0;
                    if (n != n2) continue;
                    Segment segment4 = segment3;
                    Intrinsics.checkNotNull(segment4);
                    Intrinsics.checkNotNull(segment4.next);
                    n = segment3.pos;
                    byArray = segment3.data;
                    n2 = segment3.limit;
                    if (segment3 != segment) continue;
                    if (n7 == 0) break block0;
                    segment3 = null;
                } while (n7 == 0);
                n12 = nArray[n3];
            } else {
                n9 = n11;
                n5 = byArray[n++];
                n7 = 255;
                n6 = 0;
                n8 = n5 & n7;
                n5 = n3 + n9;
                while (true) {
                    if (n3 == n5) {
                        return n4;
                    }
                    if (n8 == nArray[n3]) break;
                    ++n3;
                }
                n12 = nArray[n3 + n9];
                if (n == n2) {
                    Intrinsics.checkNotNull(segment3.next);
                    n = segment3.pos;
                    byArray = segment3.data;
                    n2 = segment3.limit;
                    if (segment3 == segment) {
                        segment3 = null;
                    }
                }
            }
            if (n12 >= 0) {
                return n12;
            }
            n3 = -n12;
        }
        if (bl) {
            return -2;
        }
        return n4;
    }

    public static /* synthetic */ int selectPrefix$default(Buffer buffer, Options options, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return BufferKt.selectPrefix(buffer, options, bl);
    }

    @NotNull
    public static final Buffer commonCopyTo(@NotNull Buffer buffer, @NotNull Buffer buffer2, long l, long l2) {
        int n = 0;
        Intrinsics.checkNotNullParameter(buffer, "$this$commonCopyTo");
        Intrinsics.checkNotNullParameter(buffer2, "out");
        long l3 = l;
        long l4 = l2;
        -Util.checkOffsetAndCount(buffer.size(), l3, l4);
        if (l4 == 0L) {
            return buffer;
        }
        Buffer buffer3 = buffer2;
        buffer3.setSize$okio(buffer3.size() + l4);
        Segment segment = buffer.head;
        while (true) {
            Segment segment2 = segment;
            Intrinsics.checkNotNull(segment2);
            if (l3 < (long)(segment2.limit - segment.pos)) break;
            l3 -= (long)(segment.limit - segment.pos);
            segment = segment.next;
        }
        while (l4 > 0L) {
            Segment segment3 = segment;
            Intrinsics.checkNotNull(segment3);
            Segment segment4 = segment3.sharedCopy();
            segment4.pos += (int)l3;
            int n2 = segment4.pos + (int)l4;
            int n3 = segment4.limit;
            boolean bl = false;
            segment4.limit = Math.min(n2, n3);
            if (buffer2.head == null) {
                buffer2.head = segment4.next = (segment4.prev = segment4);
            } else {
                Segment segment5 = buffer2.head;
                Intrinsics.checkNotNull(segment5);
                Segment segment6 = segment5.prev;
                Intrinsics.checkNotNull(segment6);
                segment6.push(segment4);
            }
            l4 -= (long)(segment4.limit - segment4.pos);
            l3 = 0L;
            segment = segment.next;
        }
        return buffer;
    }

    public static final long commonCompleteSegmentByteCount(@NotNull Buffer buffer) {
        int n = 0;
        Intrinsics.checkNotNullParameter(buffer, "$this$commonCompleteSegmentByteCount");
        long l = buffer.size();
        if (l == 0L) {
            return 0L;
        }
        Segment segment = buffer.head;
        Intrinsics.checkNotNull(segment);
        Segment segment2 = segment.prev;
        Intrinsics.checkNotNull(segment2);
        Segment segment3 = segment2;
        if (segment3.limit < 8192 && segment3.owner) {
            l -= (long)(segment3.limit - segment3.pos);
        }
        return l;
    }

    public static final byte commonReadByte(@NotNull Buffer buffer) {
        int n = 0;
        Intrinsics.checkNotNullParameter(buffer, "$this$commonReadByte");
        if (buffer.size() == 0L) {
            throw (Throwable)new EOFException();
        }
        Segment segment = buffer.head;
        Intrinsics.checkNotNull(segment);
        Segment segment2 = segment;
        int n2 = segment2.pos;
        int n3 = segment2.limit;
        byte[] byArray = segment2.data;
        byte by = byArray[n2++];
        Buffer buffer2 = buffer;
        buffer2.setSize$okio(buffer2.size() - 1L);
        if (n2 == n3) {
            buffer.head = segment2.pop();
            SegmentPool.recycle(segment2);
        } else {
            segment2.pos = n2;
        }
        return by;
    }

    public static final short commonReadShort(@NotNull Buffer buffer) {
        int n = 0;
        Intrinsics.checkNotNullParameter(buffer, "$this$commonReadShort");
        if (buffer.size() < 2L) {
            throw (Throwable)new EOFException();
        }
        Segment segment = buffer.head;
        Intrinsics.checkNotNull(segment);
        Segment segment2 = segment;
        int n2 = segment2.pos;
        int n3 = segment2.limit;
        if (n3 - n2 < 2) {
            byte by = buffer.readByte();
            int n4 = 255;
            boolean bl = false;
            int n5 = (by & n4) << 8;
            by = buffer.readByte();
            n4 = 255;
            bl = false;
            int n6 = n5 | by & n4;
            return (short)n6;
        }
        byte[] byArray = segment2.data;
        byte by = byArray[n2++];
        int n7 = 255;
        boolean bl = false;
        int n8 = (by & n7) << 8;
        by = byArray[n2++];
        n7 = 255;
        bl = false;
        int n9 = n8 | by & n7;
        Buffer buffer2 = buffer;
        buffer2.setSize$okio(buffer2.size() - 2L);
        if (n2 == n3) {
            buffer.head = segment2.pop();
            SegmentPool.recycle(segment2);
        } else {
            segment2.pos = n2;
        }
        return (short)n9;
    }

    public static final int commonReadInt(@NotNull Buffer buffer) {
        int n = 0;
        Intrinsics.checkNotNullParameter(buffer, "$this$commonReadInt");
        if (buffer.size() < 4L) {
            throw (Throwable)new EOFException();
        }
        Segment segment = buffer.head;
        Intrinsics.checkNotNull(segment);
        Segment segment2 = segment;
        int n2 = segment2.pos;
        int n3 = segment2.limit;
        if ((long)(n3 - n2) < 4L) {
            byte by = buffer.readByte();
            int n4 = 255;
            boolean bl = false;
            int n5 = (by & n4) << 24;
            by = buffer.readByte();
            n4 = 255;
            bl = false;
            int n6 = n5 | (by & n4) << 16;
            by = buffer.readByte();
            n4 = 255;
            bl = false;
            int n7 = n6 | (by & n4) << 8;
            by = buffer.readByte();
            n4 = 255;
            bl = false;
            return n7 | by & n4;
        }
        byte[] byArray = segment2.data;
        byte by = byArray[n2++];
        int n8 = 255;
        boolean bl = false;
        int n9 = (by & n8) << 24;
        by = byArray[n2++];
        n8 = 255;
        bl = false;
        int n10 = n9 | (by & n8) << 16;
        by = byArray[n2++];
        n8 = 255;
        bl = false;
        int n11 = n10 | (by & n8) << 8;
        by = byArray[n2++];
        n8 = 255;
        bl = false;
        int n12 = n11 | by & n8;
        Buffer buffer2 = buffer;
        buffer2.setSize$okio(buffer2.size() - 4L);
        if (n2 == n3) {
            buffer.head = segment2.pop();
            SegmentPool.recycle(segment2);
        } else {
            segment2.pos = n2;
        }
        return n12;
    }

    public static final long commonReadLong(@NotNull Buffer buffer) {
        int n = 0;
        Intrinsics.checkNotNullParameter(buffer, "$this$commonReadLong");
        if (buffer.size() < 8L) {
            throw (Throwable)new EOFException();
        }
        Segment segment = buffer.head;
        Intrinsics.checkNotNull(segment);
        Segment segment2 = segment;
        int n2 = segment2.pos;
        int n3 = segment2.limit;
        if ((long)(n3 - n2) < 8L) {
            int n4 = buffer.readInt();
            long l = 0xFFFFFFFFL;
            boolean bl = false;
            long l2 = ((long)n4 & l) << 32;
            n4 = buffer.readInt();
            l = 0xFFFFFFFFL;
            bl = false;
            return l2 | (long)n4 & l;
        }
        byte[] byArray = segment2.data;
        byte by = byArray[n2++];
        long l = 255L;
        boolean bl = false;
        long l3 = ((long)by & l) << 56;
        by = byArray[n2++];
        l = 255L;
        bl = false;
        long l4 = l3 | ((long)by & l) << 48;
        by = byArray[n2++];
        l = 255L;
        bl = false;
        long l5 = l4 | ((long)by & l) << 40;
        by = byArray[n2++];
        l = 255L;
        bl = false;
        long l6 = l5 | ((long)by & l) << 32;
        by = byArray[n2++];
        l = 255L;
        bl = false;
        long l7 = l6 | ((long)by & l) << 24;
        by = byArray[n2++];
        l = 255L;
        bl = false;
        long l8 = l7 | ((long)by & l) << 16;
        by = byArray[n2++];
        l = 255L;
        bl = false;
        long l9 = l8 | ((long)by & l) << 8;
        by = byArray[n2++];
        l = 255L;
        bl = false;
        long l10 = l9 | (long)by & l;
        Buffer buffer2 = buffer;
        buffer2.setSize$okio(buffer2.size() - 8L);
        if (n2 == n3) {
            buffer.head = segment2.pop();
            SegmentPool.recycle(segment2);
        } else {
            segment2.pos = n2;
        }
        return l10;
    }

    public static final byte commonGet(@NotNull Buffer buffer, long l) {
        long l2;
        int n = 0;
        Intrinsics.checkNotNullParameter(buffer, "$this$commonGet");
        -Util.checkOffsetAndCount(buffer.size(), l, 1L);
        Buffer buffer2 = buffer;
        boolean bl = false;
        Segment segment = buffer2.head;
        if (segment == null) {
            long l3 = -1L;
            Segment segment2 = null;
            boolean bl2 = false;
            Segment segment3 = segment2;
            Intrinsics.checkNotNull(segment3);
            return segment3.data[(int)((long)segment2.pos + l - l3)];
        }
        Segment segment4 = segment;
        if (buffer2.size() - l < l) {
            long l4;
            for (l4 = buffer2.size(); l4 > l; l4 -= (long)(segment4.limit - segment4.pos)) {
                Intrinsics.checkNotNull(segment4.prev);
            }
            long l5 = l4;
            Segment segment5 = segment4;
            boolean bl3 = false;
            Segment segment6 = segment5;
            Intrinsics.checkNotNull(segment6);
            return segment6.data[(int)((long)segment5.pos + l - l5)];
        }
        long l6 = 0L;
        while ((l2 = l6 + (long)(segment4.limit - segment4.pos)) <= l) {
            Intrinsics.checkNotNull(segment4.next);
            l6 = l2;
        }
        long l7 = l6;
        Segment segment7 = segment4;
        boolean bl4 = false;
        Segment segment8 = segment7;
        Intrinsics.checkNotNull(segment8);
        return segment8.data[(int)((long)segment7.pos + l - l7)];
    }

    public static final void commonClear(@NotNull Buffer buffer) {
        int n = 0;
        Intrinsics.checkNotNullParameter(buffer, "$this$commonClear");
        buffer.skip(buffer.size());
    }

    public static final void commonSkip(@NotNull Buffer buffer, long l) {
        int n = 0;
        Intrinsics.checkNotNullParameter(buffer, "$this$commonSkip");
        long l2 = l;
        while (l2 > 0L) {
            Segment segment;
            if (buffer.head == null) {
                throw (Throwable)new EOFException();
            }
            int n2 = segment.limit - segment.pos;
            boolean bl = false;
            long l3 = n2;
            boolean bl2 = false;
            int n3 = (int)Math.min(l2, l3);
            Buffer buffer2 = buffer;
            buffer2.setSize$okio(buffer2.size() - (long)n3);
            l2 -= (long)n3;
            segment.pos += n3;
            if (segment.pos != segment.limit) continue;
            buffer.head = segment.pop();
            SegmentPool.recycle(segment);
        }
    }

    @NotNull
    public static final Buffer commonWrite(@NotNull Buffer buffer, @NotNull ByteString byteString, int n, int n2) {
        int n3 = 0;
        Intrinsics.checkNotNullParameter(buffer, "$this$commonWrite");
        Intrinsics.checkNotNullParameter(byteString, "byteString");
        byteString.write$okio(buffer, n, n2);
        return buffer;
    }

    public static /* synthetic */ Buffer commonWrite$default(Buffer buffer, ByteString byteString, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = byteString.size();
        }
        n3 = 0;
        Intrinsics.checkNotNullParameter(buffer, "$this$commonWrite");
        Intrinsics.checkNotNullParameter(byteString, "byteString");
        byteString.write$okio(buffer, n, n2);
        return buffer;
    }

    @NotNull
    public static final Buffer commonWriteDecimalLong(@NotNull Buffer buffer, long l) {
        int n;
        int n2 = 0;
        Intrinsics.checkNotNullParameter(buffer, "$this$commonWriteDecimalLong");
        long l2 = l;
        if (l2 == 0L) {
            return buffer.writeByte(48);
        }
        boolean bl = false;
        if (l2 < 0L) {
            if ((l2 = -l2) < 0L) {
                return buffer.writeUtf8("-9223372036854775808");
            }
            bl = true;
        }
        int n3 = l2 < 100000000L ? (l2 < 10000L ? (l2 < 100L ? (l2 < 10L ? 1 : 2) : (l2 < 1000L ? 3 : 4)) : (l2 < 1000000L ? (l2 < 100000L ? 5 : 6) : (l2 < 10000000L ? 7 : 8))) : (l2 < 1000000000000L ? (l2 < 10000000000L ? (l2 < 1000000000L ? 9 : 10) : (l2 < 100000000000L ? 11 : 12)) : (l2 < 1000000000000000L ? (l2 < 10000000000000L ? 13 : (l2 < 100000000000000L ? 14 : 15)) : (l2 < 100000000000000000L ? (l2 < 10000000000000000L ? 16 : 17) : (n = l2 < 1000000000000000000L ? 18 : 19))));
        if (bl) {
            ++n;
        }
        Segment segment = buffer.writableSegment$okio(n);
        byte[] byArray = segment.data;
        int n4 = segment.limit + n;
        while (l2 != 0L) {
            int n5 = (int)(l2 % (long)10);
            byArray[--n4] = BufferKt.getHEX_DIGIT_BYTES()[n5];
            l2 /= (long)10;
        }
        if (bl) {
            byArray[--n4] = (byte)45;
        }
        segment.limit += n;
        Buffer buffer2 = buffer;
        buffer2.setSize$okio(buffer2.size() + (long)n);
        return buffer;
    }

    @NotNull
    public static final Buffer commonWriteHexadecimalUnsignedLong(@NotNull Buffer buffer, long l) {
        int n = 0;
        Intrinsics.checkNotNullParameter(buffer, "$this$commonWriteHexadecimalUnsignedLong");
        long l2 = l;
        if (l2 == 0L) {
            return buffer.writeByte(48);
        }
        long l3 = l2;
        l3 |= l3 >>> 1;
        l3 |= l3 >>> 2;
        l3 |= l3 >>> 4;
        l3 |= l3 >>> 8;
        l3 |= l3 >>> 16;
        l3 |= l3 >>> 32;
        l3 -= l3 >>> 1 & 0x5555555555555555L;
        l3 = (l3 >>> 2 & 0x3333333333333333L) + (l3 & 0x3333333333333333L);
        l3 = (l3 >>> 4) + l3 & 0xF0F0F0F0F0F0F0FL;
        l3 += l3 >>> 8;
        l3 += l3 >>> 16;
        l3 = (l3 & 0x3FL) + (l3 >>> 32 & 0x3FL);
        int n2 = (int)((l3 + (long)3) / (long)4);
        Segment segment = buffer.writableSegment$okio(n2);
        byte[] byArray = segment.data;
        int n3 = segment.limit;
        for (int i = segment.limit + n2 - 1; i >= n3; --i) {
            byArray[i] = BufferKt.getHEX_DIGIT_BYTES()[(int)(l2 & 0xFL)];
            l2 >>>= 4;
        }
        segment.limit += n2;
        Buffer buffer2 = buffer;
        buffer2.setSize$okio(buffer2.size() + (long)n2);
        return buffer;
    }

    @NotNull
    public static final Segment commonWritableSegment(@NotNull Buffer buffer, int n) {
        Segment segment;
        int n2 = 0;
        Intrinsics.checkNotNullParameter(buffer, "$this$commonWritableSegment");
        boolean bl = n >= 1 && n <= 8192;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "unexpected capacity";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        if (buffer.head == null) {
            Segment segment2;
            buffer.head = segment2 = SegmentPool.take();
            segment2.prev = segment2;
            segment2.next = segment2;
            return segment2;
        }
        Segment segment3 = buffer.head;
        Intrinsics.checkNotNull(segment3);
        Segment segment4 = segment = segment3.prev;
        Intrinsics.checkNotNull(segment4);
        if (segment4.limit + n > 8192 || !segment.owner) {
            segment = segment.push(SegmentPool.take());
        }
        return segment;
    }

    @NotNull
    public static final Buffer commonWrite(@NotNull Buffer buffer, @NotNull byte[] byArray) {
        int n = 0;
        Intrinsics.checkNotNullParameter(buffer, "$this$commonWrite");
        Intrinsics.checkNotNullParameter(byArray, "source");
        return buffer.write(byArray, 0, byArray.length);
    }

    @NotNull
    public static final Buffer commonWrite(@NotNull Buffer buffer, @NotNull byte[] byArray, int n, int n2) {
        int n3 = 0;
        Intrinsics.checkNotNullParameter(buffer, "$this$commonWrite");
        Intrinsics.checkNotNullParameter(byArray, "source");
        int n4 = n;
        -Util.checkOffsetAndCount(byArray.length, n4, n2);
        int n5 = n4 + n2;
        while (n4 < n5) {
            Segment segment = buffer.writableSegment$okio(1);
            int n6 = n5 - n4;
            int n7 = 8192 - segment.limit;
            boolean bl = false;
            int n8 = Math.min(n6, n7);
            ArraysKt.copyInto(byArray, segment.data, segment.limit, n4, n4 + n8);
            n4 += n8;
            segment.limit += n8;
        }
        Buffer buffer2 = buffer;
        buffer2.setSize$okio(buffer2.size() + (long)n2);
        return buffer;
    }

    @NotNull
    public static final byte[] commonReadByteArray(@NotNull Buffer buffer) {
        int n = 0;
        Intrinsics.checkNotNullParameter(buffer, "$this$commonReadByteArray");
        return buffer.readByteArray(buffer.size());
    }

    @NotNull
    public static final byte[] commonReadByteArray(@NotNull Buffer buffer, long l) {
        int n = 0;
        Intrinsics.checkNotNullParameter(buffer, "$this$commonReadByteArray");
        boolean bl = l >= 0L && l <= (long)Integer.MAX_VALUE;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "byteCount: " + l;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        if (buffer.size() < l) {
            throw (Throwable)new EOFException();
        }
        byte[] byArray = new byte[(int)l];
        buffer.readFully(byArray);
        return byArray;
    }

    public static final int commonRead(@NotNull Buffer buffer, @NotNull byte[] byArray) {
        int n = 0;
        Intrinsics.checkNotNullParameter(buffer, "$this$commonRead");
        Intrinsics.checkNotNullParameter(byArray, "sink");
        return buffer.read(byArray, 0, byArray.length);
    }

    public static final void commonReadFully(@NotNull Buffer buffer, @NotNull byte[] byArray) {
        int n;
        int n2 = 0;
        Intrinsics.checkNotNullParameter(buffer, "$this$commonReadFully");
        Intrinsics.checkNotNullParameter(byArray, "sink");
        for (int i = 0; i < byArray.length; i += n) {
            n = buffer.read(byArray, i, byArray.length - i);
            if (n != -1) continue;
            throw (Throwable)new EOFException();
        }
    }

    public static final int commonRead(@NotNull Buffer buffer, @NotNull byte[] byArray, int n, int n2) {
        int n3 = 0;
        Intrinsics.checkNotNullParameter(buffer, "$this$commonRead");
        Intrinsics.checkNotNullParameter(byArray, "sink");
        -Util.checkOffsetAndCount(byArray.length, n, n2);
        Segment segment = buffer.head;
        if (segment == null) {
            return -1;
        }
        Segment segment2 = segment;
        int n4 = segment2.limit - segment2.pos;
        boolean bl = false;
        int n5 = Math.min(n2, n4);
        ArraysKt.copyInto(segment2.data, byArray, n, segment2.pos, segment2.pos + n5);
        segment2.pos += n5;
        Buffer buffer2 = buffer;
        buffer2.setSize$okio(buffer2.size() - (long)n5);
        if (segment2.pos == segment2.limit) {
            buffer.head = segment2.pop();
            SegmentPool.recycle(segment2);
        }
        return n5;
    }

    public static final long commonReadDecimalLong(@NotNull Buffer buffer) {
        int n = 0;
        Intrinsics.checkNotNullParameter(buffer, "$this$commonReadDecimalLong");
        if (buffer.size() == 0L) {
            throw (Throwable)new EOFException();
        }
        long l = 0L;
        int n2 = 0;
        boolean bl = false;
        boolean bl2 = false;
        long l2 = -7L;
        do {
            Segment segment;
            Intrinsics.checkNotNull(buffer.head);
            byte[] byArray = segment.data;
            int n3 = segment.pos;
            int n4 = segment.limit;
            while (n3 < n4) {
                byte by = byArray[n3];
                if (by >= (byte)48 && by <= (byte)57) {
                    int n5 = (byte)48 - by;
                    if (l < -922337203685477580L || l == -922337203685477580L && (long)n5 < l2) {
                        Buffer buffer2 = new Buffer().writeDecimalLong(l).writeByte(by);
                        if (!bl) {
                            buffer2.readByte();
                        }
                        throw (Throwable)new NumberFormatException("Number too large: " + buffer2.readUtf8());
                    }
                    l *= 10L;
                    l += (long)n5;
                } else if (by == (byte)45 && n2 == 0) {
                    bl = true;
                    --l2;
                } else {
                    if (n2 == 0) {
                        throw (Throwable)new NumberFormatException("Expected leading [0-9] or '-' character but was 0x" + -Util.toHexString(by));
                    }
                    bl2 = true;
                    break;
                }
                ++n3;
                ++n2;
            }
            if (n3 == n4) {
                buffer.head = segment.pop();
                SegmentPool.recycle(segment);
                continue;
            }
            segment.pos = n3;
        } while (!bl2 && buffer.head != null);
        Buffer buffer3 = buffer;
        buffer3.setSize$okio(buffer3.size() - (long)n2);
        return bl ? l : -l;
    }

    public static final long commonReadHexadecimalUnsignedLong(@NotNull Buffer buffer) {
        int n = 0;
        Intrinsics.checkNotNullParameter(buffer, "$this$commonReadHexadecimalUnsignedLong");
        if (buffer.size() == 0L) {
            throw (Throwable)new EOFException();
        }
        long l = 0L;
        int n2 = 0;
        boolean bl = false;
        do {
            Segment segment;
            Intrinsics.checkNotNull(buffer.head);
            byte[] byArray = segment.data;
            int n3 = segment.pos;
            int n4 = segment.limit;
            while (n3 < n4) {
                int n5 = 0;
                byte by = byArray[n3];
                if (by >= (byte)48 && by <= (byte)57) {
                    n5 = by - (byte)48;
                } else if (by >= (byte)97 && by <= (byte)102) {
                    n5 = by - (byte)97 + 10;
                } else if (by >= (byte)65 && by <= (byte)70) {
                    n5 = by - (byte)65 + 10;
                } else {
                    if (n2 == 0) {
                        throw (Throwable)new NumberFormatException("Expected leading [0-9a-fA-F] character but was 0x" + -Util.toHexString(by));
                    }
                    bl = true;
                    break;
                }
                if ((l & 0xF000000000000000L) != 0L) {
                    Buffer buffer2 = new Buffer().writeHexadecimalUnsignedLong(l).writeByte(by);
                    throw (Throwable)new NumberFormatException("Number too large: " + buffer2.readUtf8());
                }
                l <<= 4;
                l |= (long)n5;
                ++n3;
                ++n2;
            }
            if (n3 == n4) {
                buffer.head = segment.pop();
                SegmentPool.recycle(segment);
                continue;
            }
            segment.pos = n3;
        } while (!bl && buffer.head != null);
        Buffer buffer3 = buffer;
        buffer3.setSize$okio(buffer3.size() - (long)n2);
        return l;
    }

    @NotNull
    public static final ByteString commonReadByteString(@NotNull Buffer buffer) {
        int n = 0;
        Intrinsics.checkNotNullParameter(buffer, "$this$commonReadByteString");
        return buffer.readByteString(buffer.size());
    }

    @NotNull
    public static final ByteString commonReadByteString(@NotNull Buffer buffer, long l) {
        int n = 0;
        Intrinsics.checkNotNullParameter(buffer, "$this$commonReadByteString");
        boolean bl = l >= 0L && l <= (long)Integer.MAX_VALUE;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "byteCount: " + l;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        if (buffer.size() < l) {
            throw (Throwable)new EOFException();
        }
        if (l >= (long)4096) {
            ByteString byteString = buffer.snapshot((int)l);
            bl2 = false;
            bl3 = false;
            ByteString byteString2 = byteString;
            boolean bl5 = false;
            buffer.skip(l);
            return byteString;
        }
        return new ByteString(buffer.readByteArray(l));
    }

    public static final int commonSelect(@NotNull Buffer buffer, @NotNull Options options) {
        int n = 0;
        Intrinsics.checkNotNullParameter(buffer, "$this$commonSelect");
        Intrinsics.checkNotNullParameter(options, "options");
        int n2 = BufferKt.selectPrefix$default(buffer, options, false, 2, null);
        if (n2 == -1) {
            return -1;
        }
        int n3 = options.getByteStrings$okio()[n2].size();
        buffer.skip(n3);
        return n2;
    }

    public static final void commonReadFully(@NotNull Buffer buffer, @NotNull Buffer buffer2, long l) {
        int n = 0;
        Intrinsics.checkNotNullParameter(buffer, "$this$commonReadFully");
        Intrinsics.checkNotNullParameter(buffer2, "sink");
        if (buffer.size() < l) {
            buffer2.write(buffer, buffer.size());
            throw (Throwable)new EOFException();
        }
        buffer2.write(buffer, l);
    }

    public static final long commonReadAll(@NotNull Buffer buffer, @NotNull Sink sink2) {
        int n = 0;
        Intrinsics.checkNotNullParameter(buffer, "$this$commonReadAll");
        Intrinsics.checkNotNullParameter(sink2, "sink");
        long l = buffer.size();
        if (l > 0L) {
            sink2.write(buffer, l);
        }
        return l;
    }

    @NotNull
    public static final String commonReadUtf8(@NotNull Buffer buffer, long l) {
        int n = 0;
        Intrinsics.checkNotNullParameter(buffer, "$this$commonReadUtf8");
        boolean bl = l >= 0L && l <= (long)Integer.MAX_VALUE;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "byteCount: " + l;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        if (buffer.size() < l) {
            throw (Throwable)new EOFException();
        }
        if (l == 0L) {
            return "";
        }
        Segment segment = buffer.head;
        Intrinsics.checkNotNull(segment);
        Segment segment2 = segment;
        if ((long)segment2.pos + l > (long)segment2.limit) {
            return _Utf8Kt.commonToUtf8String$default(buffer.readByteArray(l), 0, 0, 3, null);
        }
        String string = _Utf8Kt.commonToUtf8String(segment2.data, segment2.pos, segment2.pos + (int)l);
        segment2.pos += (int)l;
        Buffer buffer2 = buffer;
        buffer2.setSize$okio(buffer2.size() - l);
        if (segment2.pos == segment2.limit) {
            buffer.head = segment2.pop();
            SegmentPool.recycle(segment2);
        }
        return string;
    }

    @Nullable
    public static final String commonReadUtf8Line(@NotNull Buffer buffer) {
        int n = 0;
        Intrinsics.checkNotNullParameter(buffer, "$this$commonReadUtf8Line");
        long l = buffer.indexOf((byte)10);
        return l != -1L ? BufferKt.readUtf8Line(buffer, l) : (buffer.size() != 0L ? buffer.readUtf8(buffer.size()) : null);
    }

    @NotNull
    public static final String commonReadUtf8LineStrict(@NotNull Buffer buffer, long l) {
        int n = 0;
        Intrinsics.checkNotNullParameter(buffer, "$this$commonReadUtf8LineStrict");
        boolean bl = l >= 0L;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "limit < 0: " + l;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        long l2 = l == Long.MAX_VALUE ? Long.MAX_VALUE : l + 1L;
        long l3 = buffer.indexOf((byte)10, 0L, l2);
        if (l3 != -1L) {
            return BufferKt.readUtf8Line(buffer, l3);
        }
        if (l2 < buffer.size() && buffer.getByte(l2 - 1L) == (byte)13 && buffer.getByte(l2) == (byte)10) {
            return BufferKt.readUtf8Line(buffer, l2);
        }
        Buffer buffer2 = new Buffer();
        int n2 = 32;
        long l4 = buffer.size();
        boolean bl5 = false;
        long l5 = n2;
        boolean bl6 = false;
        buffer.copyTo(buffer2, 0L, Math.min(l5, l4));
        long l6 = buffer.size();
        boolean bl7 = false;
        throw (Throwable)new EOFException("\\n not found: limit=" + Math.min(l6, l) + " content=" + buffer2.readByteString().hex() + '\u2026');
    }

    public static final int commonReadUtf8CodePoint(@NotNull Buffer buffer) {
        int n = 0;
        Intrinsics.checkNotNullParameter(buffer, "$this$commonReadUtf8CodePoint");
        if (buffer.size() == 0L) {
            throw (Throwable)new EOFException();
        }
        int n2 = buffer.getByte(0L);
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = n2;
        int n7 = 128;
        byte by = 0;
        if ((n6 & n7) == 0) {
            n6 = n2;
            n7 = 127;
            by = 0;
            n3 = n6 & n7;
            n4 = 1;
            n5 = 0;
        } else {
            n6 = n2;
            n7 = 224;
            by = 0;
            if ((n6 & n7) == 192) {
                n6 = n2;
                n7 = 31;
                by = 0;
                n3 = n6 & n7;
                n4 = 2;
                n5 = 128;
            } else {
                n6 = n2;
                n7 = 240;
                by = 0;
                if ((n6 & n7) == 224) {
                    n6 = n2;
                    n7 = 15;
                    by = 0;
                    n3 = n6 & n7;
                    n4 = 3;
                    n5 = 2048;
                } else {
                    n6 = n2;
                    n7 = 248;
                    by = 0;
                    if ((n6 & n7) == 240) {
                        n6 = n2;
                        n7 = 7;
                        by = 0;
                        n3 = n6 & n7;
                        n4 = 4;
                        n5 = 65536;
                    } else {
                        buffer.skip(1L);
                        return 65533;
                    }
                }
            }
        }
        if (buffer.size() < (long)n4) {
            throw (Throwable)new EOFException("size < " + n4 + ": " + buffer.size() + " (to read code point prefixed 0x" + -Util.toHexString((byte)n2) + ')');
        }
        n7 = n4;
        for (n6 = 1; n6 < n7; ++n6) {
            byte by2 = by = buffer.getByte(n6);
            int n8 = 192;
            boolean bl = false;
            if ((by2 & n8) == 128) {
                n3 <<= 6;
                by2 = by;
                n8 = 63;
                bl = false;
                n3 |= by2 & n8;
                continue;
            }
            buffer.skip(n6);
            return 65533;
        }
        buffer.skip(n4);
        return n3 > 0x10FFFF ? 65533 : (55296 <= (n6 = n3) && 57343 >= n6 ? 65533 : (n3 < n5 ? 65533 : n3));
    }

    @NotNull
    public static final Buffer commonWriteUtf8(@NotNull Buffer buffer, @NotNull String string, int n, int n2) {
        int n3 = 0;
        Intrinsics.checkNotNullParameter(buffer, "$this$commonWriteUtf8");
        Intrinsics.checkNotNullParameter(string, "string");
        int n4 = n >= 0 ? 1 : 0;
        char c = '\u0000';
        int n5 = 0;
        if (n4 == 0) {
            boolean bl = false;
            String string2 = "beginIndex < 0: " + n;
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        n4 = n2 >= n ? 1 : 0;
        c = '\u0000';
        n5 = 0;
        if (n4 == 0) {
            boolean bl = false;
            String string3 = "endIndex < beginIndex: " + n2 + " < " + n;
            throw (Throwable)new IllegalArgumentException(string3.toString());
        }
        n4 = n2 <= string.length() ? 1 : 0;
        c = '\u0000';
        n5 = 0;
        if (n4 == 0) {
            boolean bl = false;
            String string4 = "endIndex > string.length: " + n2 + " > " + string.length();
            throw (Throwable)new IllegalArgumentException(string4.toString());
        }
        n4 = n;
        while (n4 < n2) {
            int n6;
            c = string.charAt(n4);
            if (c < '\u0080') {
                Segment segment = buffer.writableSegment$okio(1);
                byte[] byArray = segment.data;
                int n7 = segment.limit - n4;
                int n8 = 8192 - n7;
                boolean bl = false;
                int n9 = Math.min(n2, n8);
                byArray[n7 + n4++] = (byte)c;
                while (n4 < n9 && (c = string.charAt(n4)) < '\u0080') {
                    byArray[n7 + n4++] = (byte)c;
                }
                n8 = n4 + n7 - segment.limit;
                segment.limit += n8;
                Buffer buffer2 = buffer;
                buffer2.setSize$okio(buffer2.size() + (long)n8);
                continue;
            }
            if (c < '\u0800') {
                Segment segment = buffer.writableSegment$okio(2);
                segment.data[segment.limit] = (byte)(c >> 6 | 0xC0);
                segment.data[segment.limit + 1] = (byte)(c & 0x3F | 0x80);
                segment.limit += 2;
                Buffer buffer3 = buffer;
                buffer3.setSize$okio(buffer3.size() + 2L);
                ++n4;
                continue;
            }
            if (c < '\ud800' || c > '\udfff') {
                Segment segment = buffer.writableSegment$okio(3);
                segment.data[segment.limit] = (byte)(c >> 12 | 0xE0);
                segment.data[segment.limit + 1] = (byte)(c >> 6 & 0x3F | 0x80);
                segment.data[segment.limit + 2] = (byte)(c & 0x3F | 0x80);
                segment.limit += 3;
                Buffer buffer4 = buffer;
                buffer4.setSize$okio(buffer4.size() + 3L);
                ++n4;
                continue;
            }
            int n10 = n5 = n4 + 1 < n2 ? string.charAt(n4 + 1) : 0;
            if (c > '\udbff' || 56320 > (n6 = n5) || 57343 < n6) {
                buffer.writeByte(63);
                ++n4;
                continue;
            }
            n6 = 65536 + ((c & 0x3FF) << 10 | n5 & 0x3FF);
            Segment segment = buffer.writableSegment$okio(4);
            segment.data[segment.limit] = (byte)(n6 >> 18 | 0xF0);
            segment.data[segment.limit + 1] = (byte)(n6 >> 12 & 0x3F | 0x80);
            segment.data[segment.limit + 2] = (byte)(n6 >> 6 & 0x3F | 0x80);
            segment.data[segment.limit + 3] = (byte)(n6 & 0x3F | 0x80);
            segment.limit += 4;
            Buffer buffer5 = buffer;
            buffer5.setSize$okio(buffer5.size() + 4L);
            n4 += 2;
        }
        return buffer;
    }

    @NotNull
    public static final Buffer commonWriteUtf8CodePoint(@NotNull Buffer buffer, int n) {
        int n2 = 0;
        Intrinsics.checkNotNullParameter(buffer, "$this$commonWriteUtf8CodePoint");
        if (n < 128) {
            buffer.writeByte(n);
        } else if (n < 2048) {
            Segment segment = buffer.writableSegment$okio(2);
            segment.data[segment.limit] = (byte)(n >> 6 | 0xC0);
            segment.data[segment.limit + 1] = (byte)(n & 0x3F | 0x80);
            segment.limit += 2;
            Buffer buffer2 = buffer;
            buffer2.setSize$okio(buffer2.size() + 2L);
        } else {
            int n3 = n;
            if (55296 <= n3 && 57343 >= n3) {
                buffer.writeByte(63);
            } else if (n < 65536) {
                Segment segment = buffer.writableSegment$okio(3);
                segment.data[segment.limit] = (byte)(n >> 12 | 0xE0);
                segment.data[segment.limit + 1] = (byte)(n >> 6 & 0x3F | 0x80);
                segment.data[segment.limit + 2] = (byte)(n & 0x3F | 0x80);
                segment.limit += 3;
                Buffer buffer3 = buffer;
                buffer3.setSize$okio(buffer3.size() + 3L);
            } else if (n <= 0x10FFFF) {
                Segment segment = buffer.writableSegment$okio(4);
                segment.data[segment.limit] = (byte)(n >> 18 | 0xF0);
                segment.data[segment.limit + 1] = (byte)(n >> 12 & 0x3F | 0x80);
                segment.data[segment.limit + 2] = (byte)(n >> 6 & 0x3F | 0x80);
                segment.data[segment.limit + 3] = (byte)(n & 0x3F | 0x80);
                segment.limit += 4;
                Buffer buffer4 = buffer;
                buffer4.setSize$okio(buffer4.size() + 4L);
            } else {
                throw (Throwable)new IllegalArgumentException("Unexpected code point: 0x" + -Util.toHexString(n));
            }
        }
        return buffer;
    }

    public static final long commonWriteAll(@NotNull Buffer buffer, @NotNull Source source2) {
        long l;
        int n = 0;
        Intrinsics.checkNotNullParameter(buffer, "$this$commonWriteAll");
        Intrinsics.checkNotNullParameter(source2, "source");
        long l2 = 0L;
        while ((l = source2.read(buffer, 8192)) != -1L) {
            l2 += l;
        }
        return l2;
    }

    @NotNull
    public static final Buffer commonWrite(@NotNull Buffer buffer, @NotNull Source source2, long l) {
        long l2;
        int n = 0;
        Intrinsics.checkNotNullParameter(buffer, "$this$commonWrite");
        Intrinsics.checkNotNullParameter(source2, "source");
        for (long i = l; i > 0L; i -= l2) {
            l2 = source2.read(buffer, i);
            if (l2 != -1L) continue;
            throw (Throwable)new EOFException();
        }
        return buffer;
    }

    @NotNull
    public static final Buffer commonWriteByte(@NotNull Buffer buffer, int n) {
        int n2 = 0;
        Intrinsics.checkNotNullParameter(buffer, "$this$commonWriteByte");
        Segment segment = buffer.writableSegment$okio(1);
        int n3 = segment.limit;
        segment.limit = n3 + 1;
        segment.data[n3] = (byte)n;
        Buffer buffer2 = buffer;
        buffer2.setSize$okio(buffer2.size() + 1L);
        return buffer;
    }

    @NotNull
    public static final Buffer commonWriteShort(@NotNull Buffer buffer, int n) {
        int n2 = 0;
        Intrinsics.checkNotNullParameter(buffer, "$this$commonWriteShort");
        Segment segment = buffer.writableSegment$okio(2);
        byte[] byArray = segment.data;
        int n3 = segment.limit;
        byArray[n3++] = (byte)(n >>> 8 & 0xFF);
        byArray[n3++] = (byte)(n & 0xFF);
        segment.limit = n3;
        Buffer buffer2 = buffer;
        buffer2.setSize$okio(buffer2.size() + 2L);
        return buffer;
    }

    @NotNull
    public static final Buffer commonWriteInt(@NotNull Buffer buffer, int n) {
        int n2 = 0;
        Intrinsics.checkNotNullParameter(buffer, "$this$commonWriteInt");
        Segment segment = buffer.writableSegment$okio(4);
        byte[] byArray = segment.data;
        int n3 = segment.limit;
        byArray[n3++] = (byte)(n >>> 24 & 0xFF);
        byArray[n3++] = (byte)(n >>> 16 & 0xFF);
        byArray[n3++] = (byte)(n >>> 8 & 0xFF);
        byArray[n3++] = (byte)(n & 0xFF);
        segment.limit = n3;
        Buffer buffer2 = buffer;
        buffer2.setSize$okio(buffer2.size() + 4L);
        return buffer;
    }

    @NotNull
    public static final Buffer commonWriteLong(@NotNull Buffer buffer, long l) {
        int n = 0;
        Intrinsics.checkNotNullParameter(buffer, "$this$commonWriteLong");
        Segment segment = buffer.writableSegment$okio(8);
        byte[] byArray = segment.data;
        int n2 = segment.limit;
        byArray[n2++] = (byte)(l >>> 56 & 0xFFL);
        byArray[n2++] = (byte)(l >>> 48 & 0xFFL);
        byArray[n2++] = (byte)(l >>> 40 & 0xFFL);
        byArray[n2++] = (byte)(l >>> 32 & 0xFFL);
        byArray[n2++] = (byte)(l >>> 24 & 0xFFL);
        byArray[n2++] = (byte)(l >>> 16 & 0xFFL);
        byArray[n2++] = (byte)(l >>> 8 & 0xFFL);
        byArray[n2++] = (byte)(l & 0xFFL);
        segment.limit = n2;
        Buffer buffer2 = buffer;
        buffer2.setSize$okio(buffer2.size() + 8L);
        return buffer;
    }

    public static final void commonWrite(@NotNull Buffer buffer, @NotNull Buffer buffer2, long l) {
        long l2;
        long l3;
        int n = 0;
        Intrinsics.checkNotNullParameter(buffer, "$this$commonWrite");
        Intrinsics.checkNotNullParameter(buffer2, "source");
        boolean bl = buffer2 != buffer;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "source == this";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        -Util.checkOffsetAndCount(buffer2.size(), 0L, l3);
        for (l3 = l; l3 > 0L; l3 -= l2) {
            Segment segment;
            Segment segment2 = buffer2.head;
            Intrinsics.checkNotNull(segment2);
            int n2 = segment2.limit;
            Segment segment3 = buffer2.head;
            Intrinsics.checkNotNull(segment3);
            if (l3 < (long)(n2 - segment3.pos)) {
                Segment segment4;
                Segment segment5;
                if (buffer.head != null) {
                    Segment segment6 = buffer.head;
                    Intrinsics.checkNotNull(segment6);
                    segment5 = segment6.prev;
                } else {
                    segment5 = segment4 = null;
                }
                if (segment4 != null && segment4.owner && l3 + (long)segment4.limit - (long)(segment4.shared ? 0 : segment4.pos) <= (long)8192) {
                    Segment segment7 = buffer2.head;
                    Intrinsics.checkNotNull(segment7);
                    segment7.writeTo(segment4, (int)l3);
                    Buffer buffer3 = buffer2;
                    buffer3.setSize$okio(buffer3.size() - l3);
                    Buffer buffer4 = buffer;
                    buffer4.setSize$okio(buffer4.size() + l3);
                    return;
                }
                Segment segment8 = buffer2.head;
                Intrinsics.checkNotNull(segment8);
                buffer2.head = segment8.split((int)l3);
            }
            Segment segment9 = segment = buffer2.head;
            Intrinsics.checkNotNull(segment9);
            l2 = segment9.limit - segment.pos;
            buffer2.head = segment.pop();
            if (buffer.head == null) {
                buffer.head = segment;
                segment.next = segment.prev = segment;
            } else {
                Segment segment10;
                Segment segment11 = buffer.head;
                Intrinsics.checkNotNull(segment11);
                Segment segment12 = segment10 = segment11.prev;
                Intrinsics.checkNotNull(segment12);
                segment10 = segment12.push(segment);
                segment10.compact();
            }
            Buffer buffer5 = buffer2;
            buffer5.setSize$okio(buffer5.size() - l2);
            Buffer buffer6 = buffer;
            buffer6.setSize$okio(buffer6.size() + l2);
        }
    }

    public static final long commonRead(@NotNull Buffer buffer, @NotNull Buffer buffer2, long l) {
        int n = 0;
        Intrinsics.checkNotNullParameter(buffer, "$this$commonRead");
        Intrinsics.checkNotNullParameter(buffer2, "sink");
        long l2 = l;
        boolean bl = l2 >= 0L;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "byteCount < 0: " + l2;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        if (buffer.size() == 0L) {
            return -1L;
        }
        if (l2 > buffer.size()) {
            l2 = buffer.size();
        }
        buffer2.write(buffer, l2);
        return l2;
    }

    public static final long commonIndexOf(@NotNull Buffer buffer, byte by, long l, long l2) {
        long l3;
        long l4;
        int n = 0;
        Intrinsics.checkNotNullParameter(buffer, "$this$commonIndexOf");
        long l5 = l;
        long l6 = l5;
        boolean bl = 0L <= l6 && (l4 = l2) >= l6;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "size=" + buffer.size() + " fromIndex=" + l5 + " toIndex=" + l4;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        if (l4 > buffer.size()) {
            l4 = buffer.size();
        }
        if (l5 == l4) {
            return -1L;
        }
        Buffer buffer2 = buffer;
        long l7 = l5;
        boolean bl5 = false;
        Segment segment = buffer2.head;
        if (segment == null) {
            long l8 = -1L;
            Segment segment2 = null;
            boolean bl6 = false;
            return -1L;
        }
        Segment segment3 = segment;
        if (buffer2.size() - l7 < l7) {
            long l9;
            for (l9 = buffer2.size(); l9 > l7; l9 -= (long)(segment3.limit - segment3.pos)) {
                Intrinsics.checkNotNull(segment3.prev);
            }
            long l10 = l9;
            Segment segment4 = segment3;
            boolean bl7 = false;
            Segment segment5 = segment4;
            if (segment5 == null) {
                return -1L;
            }
            Segment segment6 = segment5;
            long l11 = l10;
            while (l11 < l4) {
                byte[] byArray = segment6.data;
                long l12 = segment6.limit;
                long l13 = (long)segment6.pos + l4 - l11;
                boolean bl8 = false;
                int n2 = (int)Math.min(l12, l13);
                for (int i = (int)((long)segment6.pos + l5 - l11); i < n2; ++i) {
                    if (byArray[i] != by) continue;
                    return (long)(i - segment6.pos) + l11;
                }
                l5 = l11 += (long)(segment6.limit - segment6.pos);
                Intrinsics.checkNotNull(segment6.next);
            }
            return -1L;
        }
        long l14 = 0L;
        while ((l3 = l14 + (long)(segment3.limit - segment3.pos)) <= l7) {
            Intrinsics.checkNotNull(segment3.next);
            l14 = l3;
        }
        long l15 = l14;
        Segment segment7 = segment3;
        boolean bl9 = false;
        Segment segment8 = segment7;
        if (segment8 == null) {
            return -1L;
        }
        Segment segment9 = segment8;
        long l16 = l15;
        while (l16 < l4) {
            byte[] byArray = segment9.data;
            long l17 = segment9.limit;
            long l18 = (long)segment9.pos + l4 - l16;
            boolean bl10 = false;
            int n3 = (int)Math.min(l17, l18);
            for (int i = (int)((long)segment9.pos + l5 - l16); i < n3; ++i) {
                if (byArray[i] != by) continue;
                return (long)(i - segment9.pos) + l16;
            }
            l5 = l16 += (long)(segment9.limit - segment9.pos);
            Intrinsics.checkNotNull(segment9.next);
        }
        return -1L;
    }

    public static final long commonIndexOf(@NotNull Buffer buffer, @NotNull ByteString byteString, long l) {
        long l2;
        int n = 0;
        Intrinsics.checkNotNullParameter(buffer, "$this$commonIndexOf");
        Intrinsics.checkNotNullParameter(byteString, "bytes");
        long l3 = l;
        boolean bl = byteString.size() > 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "bytes is empty";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = l3 >= 0L;
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "fromIndex < 0: " + l3;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        Buffer buffer2 = buffer;
        long l4 = l3;
        boolean bl6 = false;
        Segment segment = buffer2.head;
        if (segment == null) {
            long l5 = -1L;
            Segment segment2 = null;
            boolean bl7 = false;
            return -1L;
        }
        Segment segment3 = segment;
        if (buffer2.size() - l4 < l4) {
            long l6;
            for (l6 = buffer2.size(); l6 > l4; l6 -= (long)(segment3.limit - segment3.pos)) {
                Intrinsics.checkNotNull(segment3.prev);
            }
            long l7 = l6;
            Segment segment4 = segment3;
            boolean bl8 = false;
            Segment segment5 = segment4;
            if (segment5 == null) {
                return -1L;
            }
            Segment segment6 = segment5;
            long l8 = l7;
            byte[] byArray = byteString.internalArray$okio();
            byte by = byArray[0];
            int n2 = byteString.size();
            long l9 = buffer.size() - (long)n2 + 1L;
            while (l8 < l9) {
                byte[] byArray2 = segment6.data;
                int n3 = segment6.limit;
                long l10 = (long)segment6.pos + l9 - l8;
                boolean bl9 = false;
                long l11 = n3;
                boolean bl10 = false;
                int n4 = (int)Math.min(l11, l10);
                int n5 = n4;
                for (n3 = (int)((long)segment6.pos + l3 - l8); n3 < n5; ++n3) {
                    if (byArray2[n3] != by || !BufferKt.rangeEquals(segment6, n3 + 1, byArray, 1, n2)) continue;
                    return (long)(n3 - segment6.pos) + l8;
                }
                l3 = l8 += (long)(segment6.limit - segment6.pos);
                Intrinsics.checkNotNull(segment6.next);
            }
            return -1L;
        }
        long l12 = 0L;
        while ((l2 = l12 + (long)(segment3.limit - segment3.pos)) <= l4) {
            Intrinsics.checkNotNull(segment3.next);
            l12 = l2;
        }
        long l13 = l12;
        Segment segment7 = segment3;
        boolean bl11 = false;
        Segment segment8 = segment7;
        if (segment8 == null) {
            return -1L;
        }
        Segment segment9 = segment8;
        long l14 = l13;
        byte[] byArray = byteString.internalArray$okio();
        byte by = byArray[0];
        int n6 = byteString.size();
        long l15 = buffer.size() - (long)n6 + 1L;
        while (l14 < l15) {
            byte[] byArray3 = segment9.data;
            int n7 = segment9.limit;
            long l16 = (long)segment9.pos + l15 - l14;
            boolean bl12 = false;
            long l17 = n7;
            boolean bl13 = false;
            int n8 = (int)Math.min(l17, l16);
            int n9 = n8;
            for (n7 = (int)((long)segment9.pos + l3 - l14); n7 < n9; ++n7) {
                if (byArray3[n7] != by || !BufferKt.rangeEquals(segment9, n7 + 1, byArray, 1, n6)) continue;
                return (long)(n7 - segment9.pos) + l14;
            }
            l3 = l14 += (long)(segment9.limit - segment9.pos);
            Intrinsics.checkNotNull(segment9.next);
        }
        return -1L;
    }

    public static final long commonIndexOfElement(@NotNull Buffer buffer, @NotNull ByteString byteString, long l) {
        long l2;
        int n = 0;
        Intrinsics.checkNotNullParameter(buffer, "$this$commonIndexOfElement");
        Intrinsics.checkNotNullParameter(byteString, "targetBytes");
        long l3 = l;
        boolean bl = l3 >= 0L;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "fromIndex < 0: " + l3;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        Buffer buffer2 = buffer;
        long l4 = l3;
        boolean bl5 = false;
        Segment segment = buffer2.head;
        if (segment == null) {
            long l5 = -1L;
            Segment segment2 = null;
            boolean bl6 = false;
            return -1L;
        }
        Segment segment3 = segment;
        if (buffer2.size() - l4 < l4) {
            long l6;
            for (l6 = buffer2.size(); l6 > l4; l6 -= (long)(segment3.limit - segment3.pos)) {
                Intrinsics.checkNotNull(segment3.prev);
            }
            long l7 = l6;
            Segment segment4 = segment3;
            boolean bl7 = false;
            Segment segment5 = segment4;
            if (segment5 == null) {
                return -1L;
            }
            Segment segment6 = segment5;
            long l8 = l7;
            if (byteString.size() == 2) {
                byte by = byteString.getByte(0);
                byte by2 = byteString.getByte(1);
                while (l8 < buffer.size()) {
                    byte[] byArray = segment6.data;
                    int n2 = segment6.limit;
                    for (int i = (int)((long)segment6.pos + l3 - l8); i < n2; ++i) {
                        byte by3 = byArray[i];
                        if (by3 != by && by3 != by2) continue;
                        return (long)(i - segment6.pos) + l8;
                    }
                    l3 = l8 += (long)(segment6.limit - segment6.pos);
                    Intrinsics.checkNotNull(segment6.next);
                }
            } else {
                byte[] byArray = byteString.internalArray$okio();
                while (l8 < buffer.size()) {
                    byte[] byArray2 = segment6.data;
                    int n3 = segment6.limit;
                    for (int i = (int)((long)segment6.pos + l3 - l8); i < n3; ++i) {
                        byte by = byArray2[i];
                        for (byte by4 : byArray) {
                            if (by != by4) continue;
                            return (long)(i - segment6.pos) + l8;
                        }
                    }
                    l3 = l8 += (long)(segment6.limit - segment6.pos);
                    Intrinsics.checkNotNull(segment6.next);
                }
            }
            return -1L;
        }
        long l9 = 0L;
        while ((l2 = l9 + (long)(segment3.limit - segment3.pos)) <= l4) {
            Intrinsics.checkNotNull(segment3.next);
            l9 = l2;
        }
        long l10 = l9;
        Segment segment7 = segment3;
        boolean bl8 = false;
        Segment segment8 = segment7;
        if (segment8 == null) {
            return -1L;
        }
        Segment segment9 = segment8;
        long l11 = l10;
        if (byteString.size() == 2) {
            byte by = byteString.getByte(0);
            byte by5 = byteString.getByte(1);
            while (l11 < buffer.size()) {
                byte[] byArray = segment9.data;
                int n4 = segment9.limit;
                for (int i = (int)((long)segment9.pos + l3 - l11); i < n4; ++i) {
                    byte by6 = byArray[i];
                    if (by6 != by && by6 != by5) continue;
                    return (long)(i - segment9.pos) + l11;
                }
                l3 = l11 += (long)(segment9.limit - segment9.pos);
                Intrinsics.checkNotNull(segment9.next);
            }
        } else {
            byte[] byArray = byteString.internalArray$okio();
            while (l11 < buffer.size()) {
                byte[] byArray3 = segment9.data;
                int n5 = segment9.limit;
                for (int i = (int)((long)segment9.pos + l3 - l11); i < n5; ++i) {
                    byte by = byArray3[i];
                    for (byte by7 : byArray) {
                        if (by != by7) continue;
                        return (long)(i - segment9.pos) + l11;
                    }
                }
                l3 = l11 += (long)(segment9.limit - segment9.pos);
                Intrinsics.checkNotNull(segment9.next);
            }
        }
        return -1L;
    }

    public static final boolean commonRangeEquals(@NotNull Buffer buffer, long l, @NotNull ByteString byteString, int n, int n2) {
        int n3 = 0;
        Intrinsics.checkNotNullParameter(buffer, "$this$commonRangeEquals");
        Intrinsics.checkNotNullParameter(byteString, "bytes");
        if (l < 0L || n < 0 || n2 < 0 || buffer.size() - l < (long)n2 || byteString.size() - n < n2) {
            return false;
        }
        int n4 = n2;
        for (int i = 0; i < n4; ++i) {
            if (buffer.getByte(l + (long)i) == byteString.getByte(n + i)) continue;
            return false;
        }
        return true;
    }

    public static final boolean commonEquals(@NotNull Buffer buffer, @Nullable Object object) {
        int n = 0;
        Intrinsics.checkNotNullParameter(buffer, "$this$commonEquals");
        if (buffer == object) {
            return true;
        }
        if (!(object instanceof Buffer)) {
            return false;
        }
        if (buffer.size() != ((Buffer)object).size()) {
            return false;
        }
        if (buffer.size() == 0L) {
            return true;
        }
        Segment segment = buffer.head;
        Intrinsics.checkNotNull(segment);
        Segment segment2 = segment;
        Segment segment3 = ((Buffer)object).head;
        Intrinsics.checkNotNull(segment3);
        Segment segment4 = segment3;
        int n2 = segment2.pos;
        int n3 = segment4.pos;
        long l = 0L;
        for (long i = 0L; i < buffer.size(); i += l) {
            int n4 = segment2.limit - n2;
            int n5 = segment4.limit - n3;
            boolean bl = false;
            l = Math.min(n4, n5);
            long l2 = l;
            for (long j = 0L; j < l2; ++j) {
                if (segment2.data[n2++] == segment4.data[n3++]) continue;
                return false;
            }
            if (n2 == segment2.limit) {
                Intrinsics.checkNotNull(segment2.next);
                n2 = segment2.pos;
            }
            if (n3 != segment4.limit) continue;
            Intrinsics.checkNotNull(segment4.next);
            n3 = segment4.pos;
        }
        return true;
    }

    public static final int commonHashCode(@NotNull Buffer buffer) {
        int n = 0;
        Intrinsics.checkNotNullParameter(buffer, "$this$commonHashCode");
        Segment segment = buffer.head;
        if (segment == null) {
            return 0;
        }
        Segment segment2 = segment;
        int n2 = 1;
        do {
            int n3 = segment2.limit;
            for (int i = segment2.pos; i < n3; ++i) {
                n2 = 31 * n2 + segment2.data[i];
            }
            Intrinsics.checkNotNull(segment2.next);
        } while (segment2 != buffer.head);
        return n2;
    }

    @NotNull
    public static final Buffer commonCopy(@NotNull Buffer buffer) {
        Segment segment;
        int n = 0;
        Intrinsics.checkNotNullParameter(buffer, "$this$commonCopy");
        Buffer buffer2 = new Buffer();
        if (buffer.size() == 0L) {
            return buffer2;
        }
        Segment segment2 = buffer.head;
        Intrinsics.checkNotNull(segment2);
        Segment segment3 = segment2;
        segment.next = segment.prev = (buffer2.head = (segment = segment3.sharedCopy()));
        Segment segment4 = segment3.next;
        while (segment4 != segment3) {
            Segment segment5 = segment.prev;
            Intrinsics.checkNotNull(segment5);
            Segment segment6 = segment4;
            Intrinsics.checkNotNull(segment6);
            segment5.push(segment6.sharedCopy());
            segment4 = segment4.next;
        }
        buffer2.setSize$okio(buffer.size());
        return buffer2;
    }

    @NotNull
    public static final ByteString commonSnapshot(@NotNull Buffer buffer) {
        int n = 0;
        Intrinsics.checkNotNullParameter(buffer, "$this$commonSnapshot");
        boolean bl = buffer.size() <= (long)Integer.MAX_VALUE;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "size > Int.MAX_VALUE: " + buffer.size();
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return buffer.snapshot((int)buffer.size());
    }

    @NotNull
    public static final ByteString commonSnapshot(@NotNull Buffer buffer, int n) {
        int n2 = 0;
        Intrinsics.checkNotNullParameter(buffer, "$this$commonSnapshot");
        if (n == 0) {
            return ByteString.EMPTY;
        }
        -Util.checkOffsetAndCount(buffer.size(), 0L, n);
        int n3 = 0;
        int n4 = 0;
        Segment segment = buffer.head;
        while (n3 < n) {
            Segment segment2 = segment;
            Intrinsics.checkNotNull(segment2);
            if (segment2.limit == segment.pos) {
                throw (Throwable)((Object)new AssertionError((Object)"s.limit == s.pos"));
            }
            n3 += segment.limit - segment.pos;
            ++n4;
            segment = segment.next;
        }
        byte[][] byArrayArray = new byte[n4][];
        int[] nArray = new int[n4 * 2];
        n3 = 0;
        n4 = 0;
        segment = buffer.head;
        while (n3 < n) {
            Segment segment3 = segment;
            Intrinsics.checkNotNull(segment3);
            byArrayArray[n4] = segment3.data;
            boolean bl = false;
            nArray[n4] = Math.min(n3 += segment.limit - segment.pos, n);
            nArray[n4 + ((Object[])byArrayArray).length] = segment.pos;
            segment.shared = true;
            ++n4;
            segment = segment.next;
        }
        return new SegmentedByteString(byArrayArray, nArray);
    }
}

