/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.util.Arrays;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import okio.-Base64;
import okio.-Platform;
import okio.-Util;
import okio.Buffer;
import okio.internal.ByteStringKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u001a\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 Z2\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002:\u0001ZB\u000f\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0010H\u0016J\b\u0010\u0018\u001a\u00020\u0010H\u0016J\u0011\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u0000H\u0096\u0002J\u0015\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u0010H\u0010\u00a2\u0006\u0002\b\u001dJ\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0004J\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0000J\u0013\u0010!\u001a\u00020\u001f2\b\u0010\u001a\u001a\u0004\u0018\u00010\"H\u0096\u0002J\u0016\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\tH\u0087\u0002\u00a2\u0006\u0002\b&J\u0015\u0010&\u001a\u00020$2\u0006\u0010%\u001a\u00020\tH\u0007\u00a2\u0006\u0002\b'J\r\u0010(\u001a\u00020\tH\u0010\u00a2\u0006\u0002\b)J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010*\u001a\u00020\u0010H\u0016J\u001d\u0010+\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u00102\u0006\u0010,\u001a\u00020\u0000H\u0010\u00a2\u0006\u0002\b-J\u0010\u0010.\u001a\u00020\u00002\u0006\u0010,\u001a\u00020\u0000H\u0016J\u0010\u0010/\u001a\u00020\u00002\u0006\u0010,\u001a\u00020\u0000H\u0016J\u0010\u00100\u001a\u00020\u00002\u0006\u0010,\u001a\u00020\u0000H\u0016J\u001a\u00101\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u00042\b\b\u0002\u00102\u001a\u00020\tH\u0017J\u001a\u00101\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u00102\u001a\u00020\tH\u0007J\r\u00103\u001a\u00020\u0004H\u0010\u00a2\u0006\u0002\b4J\u0015\u00105\u001a\u00020$2\u0006\u00106\u001a\u00020\tH\u0010\u00a2\u0006\u0002\b7J\u001a\u00108\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u00042\b\b\u0002\u00102\u001a\u00020\tH\u0017J\u001a\u00108\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u00102\u001a\u00020\tH\u0007J\b\u00109\u001a\u00020\u0000H\u0016J(\u0010:\u001a\u00020\u001f2\u0006\u0010;\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010<\u001a\u00020\t2\u0006\u0010=\u001a\u00020\tH\u0016J(\u0010:\u001a\u00020\u001f2\u0006\u0010;\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u00002\u0006\u0010<\u001a\u00020\t2\u0006\u0010=\u001a\u00020\tH\u0016J\u0010\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020AH\u0002J\b\u0010B\u001a\u00020\u0000H\u0016J\b\u0010C\u001a\u00020\u0000H\u0016J\b\u0010D\u001a\u00020\u0000H\u0016J\r\u0010\u000e\u001a\u00020\tH\u0007\u00a2\u0006\u0002\bEJ\u000e\u0010F\u001a\u00020\u001f2\u0006\u0010G\u001a\u00020\u0004J\u000e\u0010F\u001a\u00020\u001f2\u0006\u0010G\u001a\u00020\u0000J\u0010\u0010H\u001a\u00020\u00102\u0006\u0010I\u001a\u00020JH\u0016J\u001c\u0010K\u001a\u00020\u00002\b\b\u0002\u0010L\u001a\u00020\t2\b\b\u0002\u0010M\u001a\u00020\tH\u0017J\b\u0010N\u001a\u00020\u0000H\u0016J\b\u0010O\u001a\u00020\u0000H\u0016J\b\u0010P\u001a\u00020\u0004H\u0016J\b\u0010Q\u001a\u00020\u0010H\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010R\u001a\u00020?2\u0006\u0010S\u001a\u00020TH\u0016J%\u0010R\u001a\u00020?2\u0006\u0010U\u001a\u00020V2\u0006\u0010;\u001a\u00020\t2\u0006\u0010=\u001a\u00020\tH\u0010\u00a2\u0006\u0002\bWJ\u0010\u0010X\u001a\u00020?2\u0006\u0010S\u001a\u00020YH\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\t8G\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000bR\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006["}, d2={"Lokio/ByteString;", "Ljava/io/Serializable;", "", "data", "", "([B)V", "getData$okio", "()[B", "hashCode", "", "getHashCode$okio", "()I", "setHashCode$okio", "(I)V", "size", "utf8", "", "getUtf8$okio", "()Ljava/lang/String;", "setUtf8$okio", "(Ljava/lang/String;)V", "asByteBuffer", "Ljava/nio/ByteBuffer;", "base64", "base64Url", "compareTo", "other", "digest", "algorithm", "digest$okio", "endsWith", "", "suffix", "equals", "", "get", "", "index", "getByte", "-deprecated_getByte", "getSize", "getSize$okio", "hex", "hmac", "key", "hmac$okio", "hmacSha1", "hmacSha256", "hmacSha512", "indexOf", "fromIndex", "internalArray", "internalArray$okio", "internalGet", "pos", "internalGet$okio", "lastIndexOf", "md5", "rangeEquals", "offset", "otherOffset", "byteCount", "readObject", "", "in", "Ljava/io/ObjectInputStream;", "sha1", "sha256", "sha512", "-deprecated_size", "startsWith", "prefix", "string", "charset", "Ljava/nio/charset/Charset;", "substring", "beginIndex", "endIndex", "toAsciiLowercase", "toAsciiUppercase", "toByteArray", "toString", "write", "out", "Ljava/io/OutputStream;", "buffer", "Lokio/Buffer;", "write$okio", "writeObject", "Ljava/io/ObjectOutputStream;", "Companion", "okio"})
public class ByteString
implements Serializable,
Comparable<ByteString> {
    private transient int hashCode;
    @Nullable
    private transient String utf8;
    @NotNull
    private final byte[] data;
    private static final long serialVersionUID = 1L;
    @JvmField
    @NotNull
    public static final ByteString EMPTY;
    public static final Companion Companion;

    public final int getHashCode$okio() {
        return this.hashCode;
    }

    public final void setHashCode$okio(int n) {
        this.hashCode = n;
    }

    @Nullable
    public final String getUtf8$okio() {
        return this.utf8;
    }

    public final void setUtf8$okio(@Nullable String string) {
        this.utf8 = string;
    }

    @NotNull
    public String utf8() {
        ByteString byteString = this;
        boolean bl = false;
        String string = byteString.getUtf8$okio();
        if (string == null) {
            string = -Platform.toUtf8String(byteString.internalArray$okio());
            byteString.setUtf8$okio(string);
        }
        return string;
    }

    @NotNull
    public String string(@NotNull Charset charset) {
        Intrinsics.checkNotNullParameter(charset, "charset");
        byte[] byArray = this.data;
        boolean bl = false;
        return new String(byArray, charset);
    }

    @NotNull
    public String base64() {
        ByteString byteString = this;
        boolean bl = false;
        return -Base64.encodeBase64$default(byteString.getData$okio(), null, 1, null);
    }

    @NotNull
    public ByteString md5() {
        return this.digest$okio("MD5");
    }

    @NotNull
    public ByteString sha1() {
        return this.digest$okio("SHA-1");
    }

    @NotNull
    public ByteString sha256() {
        return this.digest$okio("SHA-256");
    }

    @NotNull
    public ByteString sha512() {
        return this.digest$okio("SHA-512");
    }

    @NotNull
    public ByteString digest$okio(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "algorithm");
        byte[] byArray = MessageDigest.getInstance(string).digest(this.data);
        Intrinsics.checkNotNullExpressionValue(byArray, "MessageDigest.getInstance(algorithm).digest(data)");
        return new ByteString(byArray);
    }

    @NotNull
    public ByteString hmacSha1(@NotNull ByteString byteString) {
        Intrinsics.checkNotNullParameter(byteString, "key");
        return this.hmac$okio("HmacSHA1", byteString);
    }

    @NotNull
    public ByteString hmacSha256(@NotNull ByteString byteString) {
        Intrinsics.checkNotNullParameter(byteString, "key");
        return this.hmac$okio("HmacSHA256", byteString);
    }

    @NotNull
    public ByteString hmacSha512(@NotNull ByteString byteString) {
        Intrinsics.checkNotNullParameter(byteString, "key");
        return this.hmac$okio("HmacSHA512", byteString);
    }

    @NotNull
    public ByteString hmac$okio(@NotNull String string, @NotNull ByteString byteString) {
        Intrinsics.checkNotNullParameter(string, "algorithm");
        Intrinsics.checkNotNullParameter(byteString, "key");
        try {
            Mac mac = Mac.getInstance(string);
            mac.init(new SecretKeySpec(byteString.toByteArray(), string));
            byte[] byArray = mac.doFinal(this.data);
            Intrinsics.checkNotNullExpressionValue(byArray, "mac.doFinal(data)");
            return new ByteString(byArray);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw (Throwable)new IllegalArgumentException(invalidKeyException);
        }
    }

    @NotNull
    public String base64Url() {
        ByteString byteString = this;
        boolean bl = false;
        return -Base64.encodeBase64(byteString.getData$okio(), -Base64.getBASE64_URL_SAFE());
    }

    @NotNull
    public String hex() {
        byte by2;
        ByteString byteString = this;
        boolean bl = false;
        char[] cArray = new char[byteString.getData$okio().length * 2];
        int n = 0;
        for (byte by2 : byteString.getData$okio()) {
            int n2 = n++;
            byte by3 = by2;
            int n3 = 4;
            boolean bl2 = false;
            cArray[n2] = ByteStringKt.getHEX_DIGIT_CHARS()[by3 >> n3 & 0xF];
            int n4 = n++;
            by3 = by2;
            n3 = 15;
            bl2 = false;
            cArray[n4] = ByteStringKt.getHEX_DIGIT_CHARS()[by3 & n3];
        }
        by2 = 0;
        return new String(cArray);
    }

    @NotNull
    public ByteString toAsciiLowercase() {
        ByteString byteString;
        block4: {
            ByteString byteString2 = this;
            boolean bl = false;
            for (int i = 0; i < byteString2.getData$okio().length; ++i) {
                byte by = byteString2.getData$okio()[i];
                if (by < (byte)65 || by > (byte)90) {
                    continue;
                }
                byte[] byArray = byteString2.getData$okio();
                boolean bl2 = false;
                byte[] byArray2 = Arrays.copyOf(byArray, byArray.length);
                Intrinsics.checkNotNullExpressionValue(byArray2, "java.util.Arrays.copyOf(this, size)");
                byte[] byArray3 = byArray2;
                byArray3[i++] = (byte)(by - -32);
                while (i < byArray3.length) {
                    by = byArray3[i];
                    if (by < (byte)65 || by > (byte)90) {
                        ++i;
                        continue;
                    }
                    byArray3[i] = (byte)(by - -32);
                    ++i;
                }
                byteString = new ByteString(byArray3);
                break block4;
            }
            byteString = byteString2;
        }
        return byteString;
    }

    @NotNull
    public ByteString toAsciiUppercase() {
        ByteString byteString;
        block4: {
            ByteString byteString2 = this;
            boolean bl = false;
            for (int i = 0; i < byteString2.getData$okio().length; ++i) {
                byte by = byteString2.getData$okio()[i];
                if (by < (byte)97 || by > (byte)122) {
                    continue;
                }
                byte[] byArray = byteString2.getData$okio();
                boolean bl2 = false;
                byte[] byArray2 = Arrays.copyOf(byArray, byArray.length);
                Intrinsics.checkNotNullExpressionValue(byArray2, "java.util.Arrays.copyOf(this, size)");
                byte[] byArray3 = byArray2;
                byArray3[i++] = (byte)(by - 32);
                while (i < byArray3.length) {
                    by = byArray3[i];
                    if (by < (byte)97 || by > (byte)122) {
                        ++i;
                        continue;
                    }
                    byArray3[i] = (byte)(by - 32);
                    ++i;
                }
                byteString = new ByteString(byArray3);
                break block4;
            }
            byteString = byteString2;
        }
        return byteString;
    }

    @JvmOverloads
    @NotNull
    public ByteString substring(int n, int n2) {
        ByteString byteString;
        ByteString byteString2 = this;
        boolean bl = false;
        int n3 = n >= 0 ? 1 : 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (n3 == 0) {
            boolean bl4 = false;
            String string = "beginIndex < 0";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        n3 = n2 <= byteString2.getData$okio().length ? 1 : 0;
        bl2 = false;
        bl3 = false;
        if (n3 == 0) {
            boolean bl5 = false;
            String string = "endIndex > length(" + byteString2.getData$okio().length + ')';
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        n3 = n2 - n;
        bl2 = n3 >= 0;
        bl3 = false;
        boolean bl6 = false;
        if (!bl2) {
            boolean bl7 = false;
            String string = "endIndex < beginIndex";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        if (n == 0 && n2 == byteString2.getData$okio().length) {
            byteString = byteString2;
        } else {
            byte[] byArray = byteString2.getData$okio();
            bl3 = false;
            ByteString byteString3 = new ByteString(ArraysKt.copyOfRange(byArray, n, n2));
            byteString = byteString3;
        }
        return byteString;
    }

    public static /* synthetic */ ByteString substring$default(ByteString byteString, int n, int n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: substring");
        }
        if ((n3 & 1) != 0) {
            n = 0;
        }
        if ((n3 & 2) != 0) {
            n2 = byteString.size();
        }
        return byteString.substring(n, n2);
    }

    @JvmOverloads
    @NotNull
    public final ByteString substring(int n) {
        return ByteString.substring$default(this, n, 0, 2, null);
    }

    @JvmOverloads
    @NotNull
    public final ByteString substring() {
        return ByteString.substring$default(this, 0, 0, 3, null);
    }

    public byte internalGet$okio(int n) {
        ByteString byteString = this;
        boolean bl = false;
        return byteString.getData$okio()[n];
    }

    @JvmName(name="getByte")
    public final byte getByte(int n) {
        return this.internalGet$okio(n);
    }

    @JvmName(name="size")
    public final int size() {
        return this.getSize$okio();
    }

    public int getSize$okio() {
        ByteString byteString = this;
        boolean bl = false;
        return byteString.getData$okio().length;
    }

    @NotNull
    public byte[] toByteArray() {
        ByteString byteString = this;
        boolean bl = false;
        byte[] byArray = byteString.getData$okio();
        boolean bl2 = false;
        byte[] byArray2 = Arrays.copyOf(byArray, byArray.length);
        Intrinsics.checkNotNullExpressionValue(byArray2, "java.util.Arrays.copyOf(this, size)");
        return byArray2;
    }

    @NotNull
    public byte[] internalArray$okio() {
        ByteString byteString = this;
        boolean bl = false;
        return byteString.getData$okio();
    }

    @NotNull
    public ByteBuffer asByteBuffer() {
        ByteBuffer byteBuffer = ByteBuffer.wrap(this.data).asReadOnlyBuffer();
        Intrinsics.checkNotNullExpressionValue(byteBuffer, "ByteBuffer.wrap(data).asReadOnlyBuffer()");
        return byteBuffer;
    }

    public void write(@NotNull OutputStream outputStream2) throws IOException {
        Intrinsics.checkNotNullParameter(outputStream2, "out");
        outputStream2.write(this.data);
    }

    public void write$okio(@NotNull Buffer buffer, int n, int n2) {
        Intrinsics.checkNotNullParameter(buffer, "buffer");
        ByteStringKt.commonWrite(this, buffer, n, n2);
    }

    public boolean rangeEquals(int n, @NotNull ByteString byteString, int n2, int n3) {
        Intrinsics.checkNotNullParameter(byteString, "other");
        ByteString byteString2 = this;
        boolean bl = false;
        return byteString.rangeEquals(n2, byteString2.getData$okio(), n, n3);
    }

    public boolean rangeEquals(int n, @NotNull byte[] byArray, int n2, int n3) {
        Intrinsics.checkNotNullParameter(byArray, "other");
        ByteString byteString = this;
        boolean bl = false;
        return n >= 0 && n <= byteString.getData$okio().length - n3 && n2 >= 0 && n2 <= byArray.length - n3 && -Util.arrayRangeEquals(byteString.getData$okio(), n, byArray, n2, n3);
    }

    public final boolean startsWith(@NotNull ByteString byteString) {
        Intrinsics.checkNotNullParameter(byteString, "prefix");
        ByteString byteString2 = this;
        boolean bl = false;
        return byteString2.rangeEquals(0, byteString, 0, byteString.size());
    }

    public final boolean startsWith(@NotNull byte[] byArray) {
        Intrinsics.checkNotNullParameter(byArray, "prefix");
        ByteString byteString = this;
        boolean bl = false;
        return byteString.rangeEquals(0, byArray, 0, byArray.length);
    }

    public final boolean endsWith(@NotNull ByteString byteString) {
        Intrinsics.checkNotNullParameter(byteString, "suffix");
        ByteString byteString2 = this;
        boolean bl = false;
        return byteString2.rangeEquals(byteString2.size() - byteString.size(), byteString, 0, byteString.size());
    }

    public final boolean endsWith(@NotNull byte[] byArray) {
        Intrinsics.checkNotNullParameter(byArray, "suffix");
        ByteString byteString = this;
        boolean bl = false;
        return byteString.rangeEquals(byteString.size() - byArray.length, byArray, 0, byArray.length);
    }

    @JvmOverloads
    public final int indexOf(@NotNull ByteString byteString, int n) {
        Intrinsics.checkNotNullParameter(byteString, "other");
        return this.indexOf(byteString.internalArray$okio(), n);
    }

    public static /* synthetic */ int indexOf$default(ByteString byteString, ByteString byteString2, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: indexOf");
        }
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return byteString.indexOf(byteString2, n);
    }

    @JvmOverloads
    public final int indexOf(@NotNull ByteString byteString) {
        return ByteString.indexOf$default(this, byteString, 0, 2, null);
    }

    @JvmOverloads
    public int indexOf(@NotNull byte[] byArray, int n) {
        int n2;
        block3: {
            Intrinsics.checkNotNullParameter(byArray, "other");
            ByteString byteString = this;
            boolean bl = false;
            int n3 = byteString.getData$okio().length - byArray.length;
            int n4 = 0;
            boolean bl2 = false;
            int n5 = Math.max(n, n4);
            int n6 = n3;
            if (n5 <= n6) {
                while (true) {
                    if (-Util.arrayRangeEquals(byteString.getData$okio(), n5, byArray, 0, byArray.length)) {
                        n2 = n5;
                        break block3;
                    }
                    if (n5 == n6) break;
                    ++n5;
                }
            }
            n2 = -1;
        }
        return n2;
    }

    public static /* synthetic */ int indexOf$default(ByteString byteString, byte[] byArray, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: indexOf");
        }
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return byteString.indexOf(byArray, n);
    }

    @JvmOverloads
    public final int indexOf(@NotNull byte[] byArray) {
        return ByteString.indexOf$default(this, byArray, 0, 2, null);
    }

    @JvmOverloads
    public final int lastIndexOf(@NotNull ByteString byteString, int n) {
        Intrinsics.checkNotNullParameter(byteString, "other");
        ByteString byteString2 = this;
        boolean bl = false;
        return byteString2.lastIndexOf(byteString.internalArray$okio(), n);
    }

    public static /* synthetic */ int lastIndexOf$default(ByteString byteString, ByteString byteString2, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: lastIndexOf");
        }
        if ((n2 & 2) != 0) {
            n = byteString.size();
        }
        return byteString.lastIndexOf(byteString2, n);
    }

    @JvmOverloads
    public final int lastIndexOf(@NotNull ByteString byteString) {
        return ByteString.lastIndexOf$default(this, byteString, 0, 2, null);
    }

    @JvmOverloads
    public int lastIndexOf(@NotNull byte[] byArray, int n) {
        int n2;
        block1: {
            Intrinsics.checkNotNullParameter(byArray, "other");
            ByteString byteString = this;
            boolean bl = false;
            int n3 = byteString.getData$okio().length - byArray.length;
            boolean bl2 = false;
            boolean bl3 = false;
            for (int i = Math.min(n, n3); i >= 0; --i) {
                if (!-Util.arrayRangeEquals(byteString.getData$okio(), i, byArray, 0, byArray.length)) continue;
                n2 = i;
                break block1;
            }
            n2 = -1;
        }
        return n2;
    }

    public static /* synthetic */ int lastIndexOf$default(ByteString byteString, byte[] byArray, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: lastIndexOf");
        }
        if ((n2 & 2) != 0) {
            n = byteString.size();
        }
        return byteString.lastIndexOf(byArray, n);
    }

    @JvmOverloads
    public final int lastIndexOf(@NotNull byte[] byArray) {
        return ByteString.lastIndexOf$default(this, byArray, 0, 2, null);
    }

    public boolean equals(@Nullable Object object) {
        ByteString byteString = this;
        boolean bl = false;
        return object == byteString ? true : (object instanceof ByteString ? ((ByteString)object).size() == byteString.getData$okio().length && ((ByteString)object).rangeEquals(0, byteString.getData$okio(), 0, byteString.getData$okio().length) : false);
    }

    public int hashCode() {
        int n;
        ByteString byteString = this;
        boolean bl = false;
        int n2 = byteString.getHashCode$okio();
        if (n2 != 0) {
            n = n2;
        } else {
            byte[] byArray = byteString.getData$okio();
            boolean bl2 = false;
            int n3 = Arrays.hashCode(byArray);
            bl2 = false;
            boolean bl3 = false;
            int n4 = n3;
            boolean bl4 = false;
            byteString.setHashCode$okio(n4);
            n = n3;
        }
        return n;
    }

    @Override
    public int compareTo(@NotNull ByteString byteString) {
        int n;
        block2: {
            Intrinsics.checkNotNullParameter(byteString, "other");
            ByteString byteString2 = this;
            boolean bl = false;
            int n2 = byteString2.size();
            int n3 = byteString.size();
            int n4 = 0;
            int n5 = Math.min(n2, n3);
            for (int i = 0; i < n5; ++i) {
                int n6 = byteString2.getByte(i);
                int n7 = 255;
                int n8 = 0;
                n4 = n6 & n7;
                n7 = byteString.getByte(i);
                n8 = 255;
                boolean bl2 = false;
                n6 = n7 & n8;
                if (n4 == n6) {
                    continue;
                }
                n = n4 < n6 ? -1 : 1;
                break block2;
            }
            n = n2 == n3 ? 0 : (n2 < n3 ? -1 : 1);
        }
        return n;
    }

    @NotNull
    public String toString() {
        String string;
        ByteString byteString = this;
        boolean bl = false;
        byte[] byArray = byteString.getData$okio();
        boolean bl2 = false;
        if (byArray.length == 0) {
            string = "[size=0]";
        } else {
            int n = ByteStringKt.access$codePointIndexToCharIndex(byteString.getData$okio(), 64);
            if (n == -1) {
                if (byteString.getData$okio().length <= 64) {
                    string = "[hex=" + byteString.hex() + ']';
                } else {
                    ByteString byteString2;
                    StringBuilder stringBuilder = new StringBuilder().append("[size=").append(byteString.getData$okio().length).append(" hex=");
                    ByteString byteString3 = byteString;
                    int n2 = 0;
                    int n3 = 64;
                    boolean bl3 = false;
                    int n4 = 1;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    n4 = n3 <= byteString3.getData$okio().length ? 1 : 0;
                    bl4 = false;
                    bl5 = false;
                    if (n4 == 0) {
                        boolean bl6 = false;
                        String string2 = "endIndex > length(" + byteString3.getData$okio().length + ')';
                        throw (Throwable)new IllegalArgumentException(string2.toString());
                    }
                    n4 = n3 - n2;
                    bl4 = n4 >= 0;
                    bl5 = false;
                    boolean bl7 = false;
                    if (!bl4) {
                        boolean bl8 = false;
                        String string3 = "endIndex < beginIndex";
                        throw (Throwable)new IllegalArgumentException(string3.toString());
                    }
                    if (n3 == byteString3.getData$okio().length) {
                        byteString2 = byteString3;
                    } else {
                        byte[] byArray2 = byteString3.getData$okio();
                        bl5 = false;
                        ByteString byteString4 = new ByteString(ArraysKt.copyOfRange(byArray2, n2, n3));
                        byteString2 = byteString4;
                    }
                    string = stringBuilder.append(byteString2.hex()).append("\u2026]").toString();
                }
            } else {
                String string4;
                String string5 = string4 = byteString.utf8();
                int n5 = 0;
                boolean bl9 = false;
                String string6 = string5;
                if (string6 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string7 = string6.substring(n5, n);
                Intrinsics.checkNotNullExpressionValue(string7, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                String string8 = StringsKt.replace$default(StringsKt.replace$default(StringsKt.replace$default(string7, "\\", "\\\\", false, 4, null), "\n", "\\n", false, 4, null), "\r", "\\r", false, 4, null);
                string = n < string4.length() ? "[size=" + byteString.getData$okio().length + " text=" + string8 + "\u2026]" : "[text=" + string8 + ']';
            }
        }
        return string;
    }

    private final void readObject(ObjectInputStream objectInputStream) throws IOException {
        Field field;
        int n = objectInputStream.readInt();
        ByteString byteString = Companion.read(objectInputStream, n);
        Field field2 = field = ByteString.class.getDeclaredField("data");
        Intrinsics.checkNotNullExpressionValue(field2, "field");
        field2.setAccessible(true);
        field.set(this, byteString.data);
    }

    private final void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(this.data.length);
        objectOutputStream.write(this.data);
    }

    @Deprecated(message="moved to operator function", replaceWith=@ReplaceWith(imports={}, expression="this[index]"), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_getByte")
    public final byte -deprecated_getByte(int n) {
        return this.getByte(n);
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(imports={}, expression="size"), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_size")
    public final int -deprecated_size() {
        return this.size();
    }

    @NotNull
    public final byte[] getData$okio() {
        return this.data;
    }

    public ByteString(@NotNull byte[] byArray) {
        Intrinsics.checkNotNullParameter(byArray, "data");
        this.data = byArray;
    }

    static {
        Companion = new Companion(null);
        EMPTY = new ByteString(new byte[0]);
    }

    @JvmStatic
    @NotNull
    public static final ByteString of(byte ... byArray) {
        return Companion.of(byArray);
    }

    @JvmStatic
    @JvmName(name="of")
    @NotNull
    public static final ByteString of(@NotNull byte[] byArray, int n, int n2) {
        return Companion.of(byArray, n, n2);
    }

    @JvmStatic
    @JvmName(name="of")
    @NotNull
    public static final ByteString of(@NotNull ByteBuffer byteBuffer) {
        return Companion.of(byteBuffer);
    }

    @JvmStatic
    @NotNull
    public static final ByteString encodeUtf8(@NotNull String string) {
        return Companion.encodeUtf8(string);
    }

    @JvmStatic
    @JvmName(name="encodeString")
    @NotNull
    public static final ByteString encodeString(@NotNull String string, @NotNull Charset charset) {
        return Companion.encodeString(string, charset);
    }

    @JvmStatic
    @Nullable
    public static final ByteString decodeBase64(@NotNull String string) {
        return Companion.decodeBase64(string);
    }

    @JvmStatic
    @NotNull
    public static final ByteString decodeHex(@NotNull String string) {
        return Companion.decodeHex(string);
    }

    @JvmStatic
    @JvmName(name="read")
    @NotNull
    public static final ByteString read(@NotNull InputStream inputStream2, int n) throws IOException {
        return Companion.read(inputStream2, n);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0017\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\tH\u0007\u00a2\u0006\u0002\b\nJ\u0015\u0010\u000b\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0007\u00a2\u0006\u0002\b\fJ\u001d\u0010\r\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007\u00a2\u0006\u0002\b\u0010J\u0015\u0010\u0011\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0007\u00a2\u0006\u0002\b\u0012J\u0015\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0015H\u0007\u00a2\u0006\u0002\b\u0016J\u0014\u0010\u0013\u001a\u00020\u00042\n\u0010\u0017\u001a\u00020\u0018\"\u00020\u0019H\u0007J%\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cH\u0007\u00a2\u0006\u0002\b\u0016J\u001d\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020\u001cH\u0007\u00a2\u0006\u0002\b!J\u000e\u0010\u0007\u001a\u0004\u0018\u00010\u0004*\u00020\tH\u0007J\f\u0010\u000b\u001a\u00020\u0004*\u00020\tH\u0007J\u001b\u0010\"\u001a\u00020\u0004*\u00020\t2\b\b\u0002\u0010\u000e\u001a\u00020\u000fH\u0007\u00a2\u0006\u0002\b\rJ\f\u0010\u0011\u001a\u00020\u0004*\u00020\tH\u0007J\u0019\u0010#\u001a\u00020\u0004*\u00020 2\u0006\u0010\u001d\u001a\u00020\u001cH\u0007\u00a2\u0006\u0002\b\u001eJ\u0011\u0010$\u001a\u00020\u0004*\u00020\u0015H\u0007\u00a2\u0006\u0002\b\u0013J%\u0010$\u001a\u00020\u0004*\u00020\u00182\b\b\u0002\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010\u001d\u001a\u00020\u001cH\u0007\u00a2\u0006\u0002\b\u0013R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lokio/ByteString$Companion;", "", "()V", "EMPTY", "Lokio/ByteString;", "serialVersionUID", "", "decodeBase64", "string", "", "-deprecated_decodeBase64", "decodeHex", "-deprecated_decodeHex", "encodeString", "charset", "Ljava/nio/charset/Charset;", "-deprecated_encodeString", "encodeUtf8", "-deprecated_encodeUtf8", "of", "buffer", "Ljava/nio/ByteBuffer;", "-deprecated_of", "data", "", "", "array", "offset", "", "byteCount", "read", "inputstream", "Ljava/io/InputStream;", "-deprecated_read", "encode", "readByteString", "toByteString", "okio"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final ByteString of(byte ... byArray) {
            Intrinsics.checkNotNullParameter(byArray, "data");
            boolean bl = false;
            byte[] byArray2 = byArray;
            boolean bl2 = false;
            byte[] byArray3 = Arrays.copyOf(byArray2, byArray2.length);
            Intrinsics.checkNotNullExpressionValue(byArray3, "java.util.Arrays.copyOf(this, size)");
            return new ByteString(byArray3);
        }

        @JvmStatic
        @JvmName(name="of")
        @NotNull
        public final ByteString of(@NotNull byte[] byArray, int n, int n2) {
            Intrinsics.checkNotNullParameter(byArray, "$this$toByteString");
            byte[] byArray2 = byArray;
            boolean bl = false;
            -Util.checkOffsetAndCount(byArray2.length, n, n2);
            byte[] byArray3 = byArray2;
            int n3 = n + n2;
            boolean bl2 = false;
            return new ByteString(ArraysKt.copyOfRange(byArray3, n, n3));
        }

        public static /* synthetic */ ByteString of$default(Companion companion, byte[] byArray, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = 0;
            }
            if ((n3 & 2) != 0) {
                n2 = byArray.length;
            }
            return companion.of(byArray, n, n2);
        }

        @JvmStatic
        @JvmName(name="of")
        @NotNull
        public final ByteString of(@NotNull ByteBuffer byteBuffer) {
            Intrinsics.checkNotNullParameter(byteBuffer, "$this$toByteString");
            byte[] byArray = new byte[byteBuffer.remaining()];
            byteBuffer.get(byArray);
            return new ByteString(byArray);
        }

        @JvmStatic
        @NotNull
        public final ByteString encodeUtf8(@NotNull String string) {
            Intrinsics.checkNotNullParameter(string, "$this$encodeUtf8");
            String string2 = string;
            boolean bl = false;
            ByteString byteString = new ByteString(-Platform.asUtf8ToByteArray(string2));
            byteString.setUtf8$okio(string2);
            return byteString;
        }

        @JvmStatic
        @JvmName(name="encodeString")
        @NotNull
        public final ByteString encodeString(@NotNull String string, @NotNull Charset charset) {
            Intrinsics.checkNotNullParameter(string, "$this$encode");
            Intrinsics.checkNotNullParameter(charset, "charset");
            String string2 = string;
            boolean bl = false;
            byte[] byArray = string2.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue(byArray, "(this as java.lang.String).getBytes(charset)");
            return new ByteString(byArray);
        }

        public static /* synthetic */ ByteString encodeString$default(Companion companion, String string, Charset charset, int n, Object object) {
            if ((n & 1) != 0) {
                charset = Charsets.UTF_8;
            }
            return companion.encodeString(string, charset);
        }

        @JvmStatic
        @Nullable
        public final ByteString decodeBase64(@NotNull String string) {
            Intrinsics.checkNotNullParameter(string, "$this$decodeBase64");
            String string2 = string;
            boolean bl = false;
            byte[] byArray = -Base64.decodeBase64ToArray(string2);
            return byArray != null ? new ByteString(byArray) : null;
        }

        @JvmStatic
        @NotNull
        public final ByteString decodeHex(@NotNull String string) {
            Intrinsics.checkNotNullParameter(string, "$this$decodeHex");
            String string2 = string;
            boolean bl = false;
            boolean bl2 = string2.length() % 2 == 0;
            int n = 0;
            int n2 = 0;
            if (!bl2) {
                boolean bl3 = false;
                String string3 = "Unexpected hex string: " + string2;
                throw (Throwable)new IllegalArgumentException(string3.toString());
            }
            byte[] byArray = new byte[string2.length() / 2];
            n2 = byArray.length;
            for (n = 0; n < n2; ++n) {
                int n3 = ByteStringKt.access$decodeHexDigit(string2.charAt(n * 2)) << 4;
                int n4 = ByteStringKt.access$decodeHexDigit(string2.charAt(n * 2 + 1));
                byArray[n] = (byte)(n3 + n4);
            }
            return new ByteString(byArray);
        }

        @JvmStatic
        @JvmName(name="read")
        @NotNull
        public final ByteString read(@NotNull InputStream inputStream2, int n) throws IOException {
            Intrinsics.checkNotNullParameter(inputStream2, "$this$readByteString");
            boolean bl = n >= 0;
            int n2 = 0;
            int n3 = 0;
            if (!bl) {
                boolean bl2 = false;
                String string = "byteCount < 0: " + n;
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            byte[] byArray = new byte[n];
            n3 = 0;
            for (n2 = 0; n2 < n; n2 += n3) {
                n3 = inputStream2.read(byArray, n2, n - n2);
                if (n3 != -1) continue;
                throw (Throwable)new EOFException();
            }
            return new ByteString(byArray);
        }

        @Deprecated(message="moved to extension function", replaceWith=@ReplaceWith(imports={"okio.ByteString.Companion.decodeBase64"}, expression="string.decodeBase64()"), level=DeprecationLevel.ERROR)
        @JvmName(name="-deprecated_decodeBase64")
        @Nullable
        public final ByteString -deprecated_decodeBase64(@NotNull String string) {
            Intrinsics.checkNotNullParameter(string, "string");
            return this.decodeBase64(string);
        }

        @Deprecated(message="moved to extension function", replaceWith=@ReplaceWith(imports={"okio.ByteString.Companion.decodeHex"}, expression="string.decodeHex()"), level=DeprecationLevel.ERROR)
        @JvmName(name="-deprecated_decodeHex")
        @NotNull
        public final ByteString -deprecated_decodeHex(@NotNull String string) {
            Intrinsics.checkNotNullParameter(string, "string");
            return this.decodeHex(string);
        }

        @Deprecated(message="moved to extension function", replaceWith=@ReplaceWith(imports={"okio.ByteString.Companion.encode"}, expression="string.encode(charset)"), level=DeprecationLevel.ERROR)
        @JvmName(name="-deprecated_encodeString")
        @NotNull
        public final ByteString -deprecated_encodeString(@NotNull String string, @NotNull Charset charset) {
            Intrinsics.checkNotNullParameter(string, "string");
            Intrinsics.checkNotNullParameter(charset, "charset");
            return this.encodeString(string, charset);
        }

        @Deprecated(message="moved to extension function", replaceWith=@ReplaceWith(imports={"okio.ByteString.Companion.encodeUtf8"}, expression="string.encodeUtf8()"), level=DeprecationLevel.ERROR)
        @JvmName(name="-deprecated_encodeUtf8")
        @NotNull
        public final ByteString -deprecated_encodeUtf8(@NotNull String string) {
            Intrinsics.checkNotNullParameter(string, "string");
            return this.encodeUtf8(string);
        }

        @Deprecated(message="moved to extension function", replaceWith=@ReplaceWith(imports={"okio.ByteString.Companion.toByteString"}, expression="buffer.toByteString()"), level=DeprecationLevel.ERROR)
        @JvmName(name="-deprecated_of")
        @NotNull
        public final ByteString -deprecated_of(@NotNull ByteBuffer byteBuffer) {
            Intrinsics.checkNotNullParameter(byteBuffer, "buffer");
            return this.of(byteBuffer);
        }

        @Deprecated(message="moved to extension function", replaceWith=@ReplaceWith(imports={"okio.ByteString.Companion.toByteString"}, expression="array.toByteString(offset, byteCount)"), level=DeprecationLevel.ERROR)
        @JvmName(name="-deprecated_of")
        @NotNull
        public final ByteString -deprecated_of(@NotNull byte[] byArray, int n, int n2) {
            Intrinsics.checkNotNullParameter(byArray, "array");
            return this.of(byArray, n, n2);
        }

        @Deprecated(message="moved to extension function", replaceWith=@ReplaceWith(imports={"okio.ByteString.Companion.readByteString"}, expression="inputstream.readByteString(byteCount)"), level=DeprecationLevel.ERROR)
        @JvmName(name="-deprecated_read")
        @NotNull
        public final ByteString -deprecated_read(@NotNull InputStream inputStream2, int n) {
            Intrinsics.checkNotNullParameter(inputStream2, "inputstream");
            return this.read(inputStream2, n);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

