/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.publicsuffix;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.IDN;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import okhttp3.internal.Util;
import okio.BufferedSource;
import okio.GzipSource;
import okio.Okio;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002J\u0010\u0010\u000e\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000f\u001a\u00020\fJ\b\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u0011H\u0002J\u0016\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u000f\u001a\u00020\fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lokhttp3/internal/publicsuffix/PublicSuffixDatabase;", "", "()V", "listRead", "Ljava/util/concurrent/atomic/AtomicBoolean;", "publicSuffixExceptionListBytes", "", "publicSuffixListBytes", "readCompleteLatch", "Ljava/util/concurrent/CountDownLatch;", "findMatchingRule", "", "", "domainLabels", "getEffectiveTldPlusOne", "domain", "readTheList", "", "readTheListUninterruptibly", "setListBytes", "splitDomain", "Companion", "okhttp"})
public final class PublicSuffixDatabase {
    private final AtomicBoolean listRead = new AtomicBoolean(false);
    private final CountDownLatch readCompleteLatch = new CountDownLatch(1);
    private byte[] publicSuffixListBytes;
    private byte[] publicSuffixExceptionListBytes;
    @NotNull
    public static final String PUBLIC_SUFFIX_RESOURCE = "publicsuffixes.gz";
    private static final byte[] WILDCARD_LABEL;
    private static final List<String> PREVAILING_RULE;
    private static final char EXCEPTION_MARKER = '!';
    private static final PublicSuffixDatabase instance;
    public static final Companion Companion;

    @Nullable
    public final String getEffectiveTldPlusOne(@NotNull String string) {
        String string2;
        Intrinsics.checkNotNullParameter(string, "domain");
        String string3 = string2 = IDN.toUnicode(string);
        Intrinsics.checkNotNullExpressionValue(string3, "unicodeDomain");
        List<String> list = this.splitDomain(string3);
        List<String> list2 = this.findMatchingRule(list);
        if (list.size() == list2.size() && list2.get(0).charAt(0) != '!') {
            return null;
        }
        int n = list2.get(0).charAt(0) == '!' ? list.size() - list2.size() : list.size() - (list2.size() + 1);
        return SequencesKt.joinToString$default(SequencesKt.drop(CollectionsKt.asSequence((Iterable)this.splitDomain(string)), n), ".", null, null, 0, null, null, 62, null);
    }

    private final List<String> splitDomain(String string) {
        List list = StringsKt.split$default((CharSequence)string, new char[]{'.'}, false, 0, 6, null);
        if (Intrinsics.areEqual((String)CollectionsKt.last(list), "")) {
            return CollectionsKt.dropLast(list, 1);
        }
        return list;
    }

    private final List<String> findMatchingRule(List<String> list) {
        Object object;
        Object object2;
        String string;
        int n;
        if (!this.listRead.get() && this.listRead.compareAndSet(false, true)) {
            this.readTheListUninterruptibly();
        } else {
            try {
                this.readCompleteLatch.await();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
        boolean bl = this.publicSuffixListBytes != null;
        int n2 = 0;
        boolean bl2 = false;
        if (!bl) {
            boolean bl3 = false;
            String string2 = "Unable to load publicsuffixes.gz resource from the classpath.";
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        n2 = list.size();
        byte[][] byArrayArray = new byte[n2][];
        int n3 = 0;
        while (n3 < n2) {
            byte[] byArray;
            Charset charset;
            int n4 = n3;
            int n5 = n3++;
            byte[][] byArrayArray2 = byArrayArray;
            n = 0;
            string = list.get(n4);
            Intrinsics.checkNotNullExpressionValue(StandardCharsets.UTF_8, "UTF_8");
            boolean bl4 = false;
            String string3 = string;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkNotNullExpressionValue(string3.getBytes(charset), "(this as java.lang.String).getBytes(charset)");
            byArrayArray2[n5] = byArray;
        }
        byte[][] byArray = byArrayArray;
        String string4 = null;
        n3 = byArray.length;
        for (int i = 0; i < n3; ++i) {
            String string5;
            if (this.publicSuffixListBytes == null) {
                Intrinsics.throwUninitializedPropertyAccessException("publicSuffixListBytes");
            }
            if ((string5 = PublicSuffixDatabase.Companion.binarySearch(this.publicSuffixListBytes, byArray, i)) == null) continue;
            string4 = string5;
            break;
        }
        String string6 = null;
        if (((Object[])byArray).length > 1) {
            byte[][] byArray2 = (byte[][])((Object[])byArray).clone();
            n = ((Object[])byArray2).length - 1;
            for (int i = 0; i < n; ++i) {
                byArray2[i] = WILDCARD_LABEL;
                if (this.publicSuffixListBytes == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("publicSuffixListBytes");
                }
                if ((string = PublicSuffixDatabase.Companion.binarySearch(this.publicSuffixListBytes, byArray2, i)) == null) continue;
                string6 = string;
                break;
            }
        }
        String string7 = null;
        if (string6 != null) {
            n = ((Object[])byArray).length - 1;
            for (int i = 0; i < n; ++i) {
                if (this.publicSuffixExceptionListBytes == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("publicSuffixExceptionListBytes");
                }
                if ((string = PublicSuffixDatabase.Companion.binarySearch(this.publicSuffixExceptionListBytes, byArray, i)) == null) continue;
                string7 = string;
                break;
            }
        }
        if (string7 != null) {
            string7 = '!' + string7;
            return StringsKt.split$default((CharSequence)string7, new char[]{'.'}, false, 0, 6, null);
        }
        if (string4 == null && string6 == null) {
            return PREVAILING_RULE;
        }
        Object object3 = string4;
        if (object3 == null || (object3 = StringsKt.split$default((CharSequence)object3, new char[]{'.'}, false, 0, 6, null)) == null) {
            n = 0;
            object3 = object2 = CollectionsKt.emptyList();
        }
        if ((object = string6) == null || (object = StringsKt.split$default((CharSequence)object, new char[]{'.'}, false, 0, 6, null)) == null) {
            boolean bl5 = false;
            object = CollectionsKt.emptyList();
        }
        Object object4 = object;
        return object2.size() > object4.size() ? object2 : object4;
    }

    /*
     * Exception decompiling
     */
    private final void readTheListUninterruptibly() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void readTheList() throws IOException {
        byte[] byArray = null;
        byte[] byArray2 = null;
        InputStream inputStream2 = PublicSuffixDatabase.class.getResourceAsStream(PUBLIC_SUFFIX_RESOURCE);
        if (inputStream2 == null) {
            return;
        }
        InputStream inputStream3 = inputStream2;
        Object object = Okio.buffer(new GzipSource(Okio.source(inputStream3)));
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            Object object2 = (BufferedSource)object;
            boolean bl3 = false;
            int n = object2.readInt();
            byArray = object2.readByteArray(n);
            int n2 = object2.readInt();
            byArray2 = object2.readByteArray(n2);
            object2 = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, throwable);
        }
        object = this;
        bl = false;
        boolean bl4 = false;
        synchronized (object) {
            boolean bl5 = false;
            Intrinsics.checkNotNull(byArray);
            this.publicSuffixListBytes = byArray;
            Intrinsics.checkNotNull(byArray2);
            this.publicSuffixExceptionListBytes = byArray2;
            Unit unit = Unit.INSTANCE;
        }
        this.readCompleteLatch.countDown();
    }

    public final void setListBytes(@NotNull byte[] byArray, @NotNull byte[] byArray2) {
        Intrinsics.checkNotNullParameter(byArray, "publicSuffixListBytes");
        Intrinsics.checkNotNullParameter(byArray2, "publicSuffixExceptionListBytes");
        this.publicSuffixListBytes = byArray;
        this.publicSuffixExceptionListBytes = byArray2;
        this.listRead.set(true);
        this.readCompleteLatch.countDown();
    }

    static {
        Companion = new Companion(null);
        WILDCARD_LABEL = new byte[]{(byte)42};
        PREVAILING_RULE = CollectionsKt.listOf("*");
        instance = new PublicSuffixDatabase();
    }

    public static final /* synthetic */ byte[] access$getPublicSuffixListBytes$p(PublicSuffixDatabase publicSuffixDatabase) {
        if (publicSuffixDatabase.publicSuffixListBytes == null) {
            Intrinsics.throwUninitializedPropertyAccessException("publicSuffixListBytes");
        }
        return publicSuffixDatabase.publicSuffixListBytes;
    }

    public static final /* synthetic */ void access$setPublicSuffixListBytes$p(PublicSuffixDatabase publicSuffixDatabase, byte[] byArray) {
        publicSuffixDatabase.publicSuffixListBytes = byArray;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\r\u001a\u00020\fJ)\u0010\u000e\u001a\u0004\u0018\u00010\u0007*\u00020\n2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a2\u0006\u0002\u0010\u0013R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lokhttp3/internal/publicsuffix/PublicSuffixDatabase$Companion;", "", "()V", "EXCEPTION_MARKER", "", "PREVAILING_RULE", "", "", "PUBLIC_SUFFIX_RESOURCE", "WILDCARD_LABEL", "", "instance", "Lokhttp3/internal/publicsuffix/PublicSuffixDatabase;", "get", "binarySearch", "labels", "", "labelIndex", "", "([B[[BI)Ljava/lang/String;", "okhttp"})
    public static final class Companion {
        @NotNull
        public final PublicSuffixDatabase get() {
            return instance;
        }

        private final String binarySearch(byte[] byArray, byte[][] byArray2, int n) {
            int n2 = 0;
            int n3 = byArray.length;
            String string = null;
            while (n2 < n3) {
                int n4;
                int n5;
                int n6;
                for (n6 = (n2 + n3) / 2; n6 > -1 && byArray[n6] != (byte)10; --n6) {
                }
                ++n6;
                int n7 = 1;
                while (byArray[n6 + n7] != (byte)10) {
                    ++n7;
                }
                int n8 = n6 + n7 - n6;
                int n9 = 0;
                int n10 = n;
                int n11 = 0;
                int n12 = 0;
                boolean bl = false;
                while (true) {
                    n5 = 0;
                    if (bl) {
                        n5 = 46;
                        bl = false;
                    } else {
                        n5 = Util.and(byArray2[n10][n11], 255);
                    }
                    n4 = Util.and(byArray[n6 + n12], 255);
                    n9 = n5 - n4;
                    if (n9 != 0) break;
                    ++n11;
                    if (++n12 == n8) break;
                    if (byArray2[n10].length != n11) continue;
                    if (n10 == ((Object[])byArray2).length - 1) break;
                    ++n10;
                    n11 = -1;
                    bl = true;
                }
                if (n9 < 0) {
                    n3 = n6 - 1;
                    continue;
                }
                if (n9 > 0) {
                    n2 = n6 + n7 + 1;
                    continue;
                }
                n5 = n8 - n12;
                n4 = byArray2[n10].length - n11;
                int n13 = ((Object[])byArray2).length;
                for (int i = n10 + 1; i < n13; ++i) {
                    n4 += byArray2[i].length;
                }
                if (n4 < n5) {
                    n3 = n6 - 1;
                    continue;
                }
                if (n4 > n5) {
                    n2 = n6 + n7 + 1;
                    continue;
                }
                Charset charset = StandardCharsets.UTF_8;
                Intrinsics.checkNotNullExpressionValue(charset, "UTF_8");
                Charset charset2 = charset;
                n13 = 0;
                string = new String(byArray, n6, n8, charset2);
                break;
            }
            return string;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

