/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pe.header;

import com.uqm.crashsight.symtabtool.pdb.stream.ParseBuffer;
import com.uqm.crashsight.symtabtool.pe.Section;

public class CoffHeader {
    int machine;
    int number_of_sections;
    long timeDateStamp;
    long pointer_to_symbol_table;
    long number_of_symbol_table;
    int size_of_optional_header;
    int characteristics;

    public static CoffHeader parse(ParseBuffer parseBuffer) {
        CoffHeader coffHeader = new CoffHeader();
        long l = parseBuffer.readU32();
        coffHeader.machine = parseBuffer.readU16();
        coffHeader.number_of_sections = parseBuffer.readU16();
        coffHeader.timeDateStamp = parseBuffer.readU32();
        coffHeader.pointer_to_symbol_table = parseBuffer.readU32();
        coffHeader.number_of_symbol_table = parseBuffer.readU32();
        coffHeader.size_of_optional_header = parseBuffer.readU16();
        coffHeader.characteristics = parseBuffer.readU16();
        return coffHeader;
    }

    public Section[] parseSection(ParseBuffer parseBuffer, long l) {
        Section[] sectionArray = new Section[this.number_of_sections];
        if (parseBuffer.len() / 40L < (long)this.number_of_sections) {
            return null;
        }
        parseBuffer.pos(l);
        for (int i = 0; i < this.number_of_sections; ++i) {
            sectionArray[i] = Section.parse(parseBuffer);
        }
        return sectionArray;
    }

    public int getMachine() {
        return this.machine;
    }

    public int getNumber_of_sections() {
        return this.number_of_sections;
    }

    public long getTimeDateStamp() {
        return this.timeDateStamp;
    }

    public long getPointer_to_symbol_table() {
        return this.pointer_to_symbol_table;
    }

    public long getNumber_of_symbol_table() {
        return this.number_of_symbol_table;
    }

    public int getSize_of_optional_header() {
        return this.size_of_optional_header;
    }

    public int getCharacteristics() {
        return this.characteristics;
    }

    public void setMachine(int n) {
        this.machine = n;
    }

    public void setNumber_of_sections(int n) {
        this.number_of_sections = n;
    }

    public void setTimeDateStamp(long l) {
        this.timeDateStamp = l;
    }

    public void setPointer_to_symbol_table(long l) {
        this.pointer_to_symbol_table = l;
    }

    public void setNumber_of_symbol_table(long l) {
        this.number_of_symbol_table = l;
    }

    public void setSize_of_optional_header(int n) {
        this.size_of_optional_header = n;
    }

    public void setCharacteristics(int n) {
        this.characteristics = n;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CoffHeader)) {
            return false;
        }
        CoffHeader coffHeader = (CoffHeader)object;
        if (!coffHeader.canEqual(this)) {
            return false;
        }
        if (this.getMachine() != coffHeader.getMachine()) {
            return false;
        }
        if (this.getNumber_of_sections() != coffHeader.getNumber_of_sections()) {
            return false;
        }
        if (this.getTimeDateStamp() != coffHeader.getTimeDateStamp()) {
            return false;
        }
        if (this.getPointer_to_symbol_table() != coffHeader.getPointer_to_symbol_table()) {
            return false;
        }
        if (this.getNumber_of_symbol_table() != coffHeader.getNumber_of_symbol_table()) {
            return false;
        }
        if (this.getSize_of_optional_header() != coffHeader.getSize_of_optional_header()) {
            return false;
        }
        return this.getCharacteristics() == coffHeader.getCharacteristics();
    }

    protected boolean canEqual(Object object) {
        return object instanceof CoffHeader;
    }

    public int hashCode() {
        int n = 59;
        int n2 = 1;
        n2 = n2 * 59 + this.getMachine();
        n2 = n2 * 59 + this.getNumber_of_sections();
        long l = this.getTimeDateStamp();
        n2 = n2 * 59 + (int)(l >>> 32 ^ l);
        long l2 = this.getPointer_to_symbol_table();
        n2 = n2 * 59 + (int)(l2 >>> 32 ^ l2);
        long l3 = this.getNumber_of_symbol_table();
        n2 = n2 * 59 + (int)(l3 >>> 32 ^ l3);
        n2 = n2 * 59 + this.getSize_of_optional_header();
        n2 = n2 * 59 + this.getCharacteristics();
        return n2;
    }

    public String toString() {
        return "CoffHeader(machine=" + this.getMachine() + ", number_of_sections=" + this.getNumber_of_sections() + ", timeDateStamp=" + this.getTimeDateStamp() + ", pointer_to_symbol_table=" + this.getPointer_to_symbol_table() + ", number_of_symbol_table=" + this.getNumber_of_symbol_table() + ", size_of_optional_header=" + this.getSize_of_optional_header() + ", characteristics=" + this.getCharacteristics() + ")";
    }
}

