/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pe;

import com.uqm.crashsight.symtabtool.pdb.pdbi.Uuid;
import com.uqm.crashsight.symtabtool.pdb.stream.ParseBuffer;
import com.uqm.crashsight.symtabtool.pe.Section;
import com.uqm.crashsight.symtabtool.pe.header.DataDirectories;

public class DebugData {
    ImageDebugDirectory imageDebugDirectory = new ImageDebugDirectory();
    CodeviewPDB70DebugInfo codeviewPDB70DebugInfo = new CodeviewPDB70DebugInfo();
    private static final long IMAGE_DEBUG_TYPE_CODEVIEW = 2L;

    public static DebugData parse(ParseBuffer parseBuffer, DataDirectories.DataDirectory dataDirectory, Section[] sectionArray, long l) {
        DebugData debugData = new DebugData();
        debugData.imageDebugDirectory.parse(parseBuffer, dataDirectory.virtualAddress, l, sectionArray);
        debugData.codeviewPDB70DebugInfo.parse(parseBuffer, debugData.imageDebugDirectory);
        return debugData;
    }

    public class CodeviewPDB70DebugInfo {
        long codeviewSignature;
        Uuid signature;
        long age;
        byte[] fileName;
        char[] fileNameChar = new char[8];
        private static final long CODEVIEW_PDB70_MAGIC = 1396986706L;

        public boolean parse(ParseBuffer parseBuffer, ImageDebugDirectory imageDebugDirectory) {
            if (imageDebugDirectory.dataType != 2L) {
                return false;
            }
            long l = imageDebugDirectory.pointerToRawData;
            long l2 = imageDebugDirectory.sizeOfData - 24L;
            if (l2 < 0L) {
                return false;
            }
            parseBuffer.pos(l);
            this.codeviewSignature = parseBuffer.readU32();
            if (this.codeviewSignature != 1396986706L) {
                return false;
            }
            this.signature = Uuid.parse(parseBuffer);
            this.age = parseBuffer.readU32();
            this.fileName = parseBuffer.readBytes(l2);
            this.fileNameChar = new char[new Long(l2).intValue()];
            int n = 0;
            while ((long)n < l2) {
                this.fileNameChar[n] = (char)this.fileName[n];
                ++n;
            }
            return true;
        }
    }

    public class ImageDebugDirectory {
        long characteriestics;
        long timeDateStamp;
        int majorVersion;
        int minorVersion;
        long dataType;
        long sizeOfData;
        long addressOfRawData;
        long pointerToRawData;

        public boolean parse(ParseBuffer parseBuffer, long l, long l2, Section[] sectionArray) {
            int n = 511;
            int n2 = 4095;
            long l3 = -1L;
            for (int i = 0; i < sectionArray.length; ++i) {
                if (!sectionArray[i].is_in_section(l, l2)) continue;
                l3 = l - sectionArray[i].virtualAddress + (sectionArray[i].pointerToRawData & (long)(~n));
                break;
            }
            if (l3 == -1L) {
                return false;
            }
            parseBuffer.pos(l3);
            this.characteriestics = parseBuffer.readU32();
            this.timeDateStamp = parseBuffer.readU32();
            this.majorVersion = parseBuffer.readU16();
            this.minorVersion = parseBuffer.readU16();
            this.dataType = parseBuffer.readU32();
            this.sizeOfData = parseBuffer.readU32();
            this.addressOfRawData = parseBuffer.readU32();
            this.pointerToRawData = parseBuffer.readU32();
            return true;
        }
    }
}

