/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pdb.types;

import com.uqm.crashsight.symtabtool.common.Pair;
import com.uqm.crashsight.symtabtool.common.utils.Log;
import com.uqm.crashsight.symtabtool.pdb.common.Variant;
import com.uqm.crashsight.symtabtool.pdb.common.VariantEnum;
import com.uqm.crashsight.symtabtool.pdb.tpi.ArgumentList;
import com.uqm.crashsight.symtabtool.pdb.tpi.ArrayType;
import com.uqm.crashsight.symtabtool.pdb.tpi.ClassKind;
import com.uqm.crashsight.symtabtool.pdb.tpi.ClassType;
import com.uqm.crashsight.symtabtool.pdb.tpi.EnumerateType;
import com.uqm.crashsight.symtabtool.pdb.tpi.EnumerationType;
import com.uqm.crashsight.symtabtool.pdb.tpi.Item;
import com.uqm.crashsight.symtabtool.pdb.tpi.ItemFinder;
import com.uqm.crashsight.symtabtool.pdb.tpi.ItemInformation;
import com.uqm.crashsight.symtabtool.pdb.tpi.ItemIter;
import com.uqm.crashsight.symtabtool.pdb.tpi.MemberFunctionType;
import com.uqm.crashsight.symtabtool.pdb.tpi.ModifierType;
import com.uqm.crashsight.symtabtool.pdb.tpi.PFunctionAttributes;
import com.uqm.crashsight.symtabtool.pdb.tpi.PointerMode;
import com.uqm.crashsight.symtabtool.pdb.tpi.PointerType;
import com.uqm.crashsight.symtabtool.pdb.tpi.PrimitiveKind;
import com.uqm.crashsight.symtabtool.pdb.tpi.PrimitiveType;
import com.uqm.crashsight.symtabtool.pdb.tpi.ProcedureType;
import com.uqm.crashsight.symtabtool.pdb.tpi.TypeData;
import com.uqm.crashsight.symtabtool.pdb.tpi.TypeEnum;
import com.uqm.crashsight.symtabtool.pdb.tpi.TypeIndex;
import com.uqm.crashsight.symtabtool.pdb.tpi.TypeInterface;
import com.uqm.crashsight.symtabtool.pdb.tpi.UnionType;
import com.uqm.crashsight.symtabtool.pdb.types.DemangleOptions;
import com.uqm.crashsight.symtabtool.pdb.types.DumperFlags;
import com.uqm.crashsight.symtabtool.pdb.types.Language;
import com.uqm.crashsight.symtabtool.pdb.types.Name;
import com.uqm.crashsight.symtabtool.pdb.types.NameMangling;
import com.uqm.crashsight.symtabtool.pdb.types.PFuncName;
import com.uqm.crashsight.symtabtool.pdb.types.PtrAttributes;
import com.uqm.crashsight.symtabtool.pdb.types.Quaternion;
import com.uqm.crashsight.symtabtool.pdb.types.ThisKind;
import com.uqm.crashsight.symtabtool.pdb.types.Undecorated;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class TypeDumper {
    ItemFinder finder;
    Map<String, Long> fwd;
    long ptrSize;
    DumperFlags flags;

    public TypeDumper(ItemInformation itemInformation, long l, DumperFlags dumperFlags) {
        Item item;
        ItemIter itemIter = itemInformation.iter();
        ItemFinder itemFinder = itemInformation.finder();
        this.fwd = new LinkedHashMap<String, Long>();
        while ((item = itemIter.next()) != null) {
            String string;
            TypeInterface typeInterface;
            itemFinder.update(itemIter);
            TypeData typeData = item.parse();
            if (typeData.get((Object)TypeEnum.Class) != null) {
                typeInterface = (ClassType)typeData.get((Object)TypeEnum.Class);
                if (((ClassType)typeInterface).getProperties().forwardReference()) continue;
                string = ((ClassType)typeInterface).getUniqueName();
                this.fwd.put(string, Long.valueOf(((ClassType)typeInterface).getSize()));
                continue;
            }
            if (typeData.get((Object)TypeEnum.Union) == null || ((UnionType)(typeInterface = (UnionType)typeData.get((Object)TypeEnum.Union))).getProperties().forwardReference()) continue;
            string = ((UnionType)typeInterface).getUniqueName();
            this.fwd.put(string, ((UnionType)typeInterface).getSize());
        }
        this.finder = itemFinder;
        this.ptrSize = l;
        this.flags = dumperFlags;
    }

    public TypeData find(TypeIndex typeIndex) {
        Item item = this.finder.find(typeIndex.getIndex());
        return item.parse();
    }

    public long getClassSize(ClassType classType) {
        if (classType.getProperties().forwardReference()) {
            String string = classType.getUniqueName();
            return this.fwd.getOrDefault(string, Long.valueOf(classType.getSize()));
        }
        return classType.getSize();
    }

    public long getUnionSize(UnionType unionType) {
        if (unionType.getProperties().forwardReference()) {
            String string = unionType.getUniqueName();
            return this.fwd.getOrDefault(string, unionType.getSize());
        }
        return unionType.getSize();
    }

    public long getTypeSize(TypeIndex typeIndex) {
        TypeData typeData = this.find(typeIndex);
        return this.getDataSize(typeData);
    }

    public long getDataSize(TypeData typeData) {
        if (typeData.get((Object)TypeEnum.Primitive) != null) {
            PrimitiveType primitiveType = (PrimitiveType)typeData.get((Object)TypeEnum.Primitive);
            if (primitiveType.getIndirection() != null) {
                return this.ptrSize;
            }
            PrimitiveKind primitiveKind = primitiveType.getKind();
            switch (primitiveKind) {
                case NoType: 
                case Void: {
                    return 0L;
                }
                case Char: 
                case UChar: 
                case RChar: 
                case I8: 
                case U8: 
                case Bool8: {
                    return 1L;
                }
                case WChar: 
                case RChar16: 
                case Short: 
                case UShort: 
                case I16: 
                case U16: 
                case F16: 
                case Bool16: {
                    return 2L;
                }
                case RChar32: 
                case Long: 
                case ULong: 
                case I32: 
                case U32: 
                case F32: 
                case F32PP: 
                case Bool32: 
                case HRESULT: {
                    return 4L;
                }
                case I64: 
                case U64: 
                case Quad: 
                case UQuad: 
                case F64: 
                case Complex32: 
                case Bool64: {
                    return 8L;
                }
                case I128: 
                case U128: 
                case Octa: 
                case UOcta: 
                case F128: 
                case Complex64: {
                    return 16L;
                }
                case F48: {
                    return 6L;
                }
                case F80: {
                    return 10L;
                }
                case Complex80: {
                    return 20L;
                }
                case Complex128: {
                    return 32L;
                }
            }
            Log.error("Unsupported primitive type %d", new Object[]{primitiveKind});
        } else {
            if (typeData.get((Object)TypeEnum.Class) != null) {
                ClassType classType = (ClassType)typeData.get((Object)TypeEnum.Class);
                return this.getClassSize(classType);
            }
            if (typeData.get((Object)TypeEnum.MemberFunction) != null) {
                return this.ptrSize;
            }
            if (typeData.get((Object)TypeEnum.Procedure) != null) {
                return this.ptrSize;
            }
            if (typeData.get((Object)TypeEnum.Pointer) != null) {
                PointerType pointerType = (PointerType)typeData.get((Object)TypeEnum.Pointer);
                return pointerType.getAttributes().size();
            }
            if (typeData.get((Object)TypeEnum.Array) != null) {
                ArrayType arrayType = (ArrayType)typeData.get((Object)TypeEnum.Array);
                return arrayType.getDimensions().get(arrayType.getDimensions().size() - 1);
            }
            if (typeData.get((Object)TypeEnum.Union) != null) {
                UnionType unionType = (UnionType)typeData.get((Object)TypeEnum.Union);
                return this.getUnionSize(unionType);
            }
            if (typeData.get((Object)TypeEnum.Enumeration) != null) {
                EnumerationType enumerationType = (EnumerationType)typeData.get((Object)TypeEnum.Enumeration);
                return this.getTypeSize(enumerationType.getUnderlyingType());
            }
            if (typeData.get((Object)TypeEnum.Enumerate) != null) {
                EnumerateType enumerateType = (EnumerateType)typeData.get((Object)TypeEnum.Enumerate);
                Variant variant = enumerateType.getValue();
                if (variant.get((Object)VariantEnum.I8) != null || variant.get((Object)VariantEnum.U8) != null) {
                    return 1L;
                }
                if (variant.get((Object)VariantEnum.I16) != null || variant.get((Object)VariantEnum.U16) != null) {
                    return 2L;
                }
                if (variant.get((Object)VariantEnum.I32) != null || variant.get((Object)VariantEnum.U32) != null) {
                    return 4L;
                }
                if (variant.get((Object)VariantEnum.I64) != null || variant.get((Object)VariantEnum.U64) != null) {
                    return 8L;
                }
            } else {
                if (typeData.get((Object)TypeEnum.Modifier) != null) {
                    ModifierType modifierType = (ModifierType)typeData.get((Object)TypeEnum.Modifier);
                    return this.getTypeSize(modifierType.getUnderlyingType());
                }
                return 0L;
            }
        }
        return 0L;
    }

    public PFuncName dumpFunction(String string, TypeIndex typeIndex) {
        if (string == null || string.isEmpty()) {
            return new PFuncName(new Undecorated("<name omitted>"), null);
        }
        if (typeIndex.getIndex() == 0L) {
            return this.demangle(string);
        }
        TypeData typeData = this.find(typeIndex);
        if (typeData.containsKey((Object)TypeEnum.MemberFunction)) {
            boolean bl = this.flags.intersects(1);
            MemberFunctionType memberFunctionType = (MemberFunctionType)typeData.get((Object)TypeEnum.MemberFunction);
            Quaternion<Boolean, Boolean, String, String> quaternion = this.dumpMethodParts(memberFunctionType, bl);
            String string2 = (Boolean)quaternion.v1 != false ? "static " : "";
            String string3 = (Boolean)quaternion.v2 != false ? " const" : "";
            return new PFuncName(new Undecorated(String.format("%s%s%s(%s)%s", string2, this.fixReturn((String)quaternion.v3), string, quaternion.v4, string3)), null);
        }
        if (typeData.containsKey((Object)TypeEnum.Procedure)) {
            ProcedureType procedureType = (ProcedureType)typeData.get((Object)TypeEnum.Procedure);
            Pair<String, String> pair = this.dumpProcedureParts(procedureType, this.flags.intersects(1));
            return new PFuncName(new Undecorated(String.format("%s%s(%s)", this.fixReturn(pair.getKey()), string, pair.getValue())), null);
        }
        Log.error("Function %s hasn't a function type", string);
        return new PFuncName(new Undecorated(string), null);
    }

    public String fixReturn(String string) {
        if (!string.isEmpty()) {
            return string + " ";
        }
        return string;
    }

    public String fixMangledName(String string) {
        return string.replace("__cdecl", "").replace("public: ", "").replace("protected: ", "").replace("private: ", "").replace("(void)", "").replace("  ", " ");
    }

    public PFuncName demangle(String string) {
        Language language = new Name(string, NameMangling.Mangled, Language.Unknown).detectLanguage();
        if (language == Language.Unknown) {
            return PFuncName.getUnknown(string);
        }
        Name name = new Name(string, NameMangling.Mangled, language);
        String string2 = (name = Name.fixSymbolName(name)).demangle(DemangleOptions.complete());
        if (string2 != null) {
            if (string2.equals(string)) {
                return PFuncName.getUnknown(string2);
            }
            string2 = this.fixMangledName(string2);
            return new PFuncName(new Undecorated(string2), null);
        }
        Log.warn("Didn't manage to demangle $s", string);
        return new PFuncName(new Undecorated(string), null);
    }

    public String getReturnType(TypeIndex typeIndex, PFunctionAttributes pFunctionAttributes, boolean bl) {
        if (!bl && !pFunctionAttributes.isConstructor()) {
            String string = this.dumpIndex(typeIndex);
            if (string != null) {
                return string;
            }
            return "";
        }
        return "";
    }

    public Pair<String, String> dumpProcedureParts(ProcedureType procedureType, boolean bl) {
        String string = this.getReturnType(procedureType.getReturnType(), procedureType.getAttributes(), bl);
        String string2 = this.dumpIndex(procedureType.getArgumentList());
        return new Pair<String, String>(string, string2);
    }

    public ThisKind checkThisType(TypeIndex typeIndex, TypeIndex typeIndex2) {
        TypeData typeData = this.find(typeIndex);
        if (typeData.containsKey((Object)TypeEnum.Pointer)) {
            PointerType pointerType = (PointerType)typeData.get((Object)TypeEnum.Pointer);
            if (pointerType.getUnderlyingType().getIndex() == typeIndex2.getIndex()) {
                return ThisKind.This;
            }
            TypeData typeData2 = this.find(pointerType.getUnderlyingType());
            if (typeData2.containsKey((Object)TypeEnum.Modifier)) {
                ModifierType modifierType = (ModifierType)typeData2.get((Object)TypeEnum.Modifier);
                return ThisKind.newKind(modifierType.getUnderlyingType().getIndex() == typeIndex2.getIndex(), modifierType.isConstant());
            }
            return ThisKind.NotThis;
        }
        if (typeData.containsKey((Object)TypeEnum.Modifier)) {
            ModifierType modifierType = (ModifierType)typeData.get((Object)TypeEnum.Modifier);
            TypeData typeData3 = this.find(modifierType.getUnderlyingType());
            if (typeData3.containsKey((Object)TypeEnum.Pointer)) {
                PointerType pointerType = (PointerType)typeData3.get((Object)TypeEnum.Pointer);
                return ThisKind.newKind(pointerType.getUnderlyingType().getIndex() == typeIndex2.getIndex(), modifierType.isConstant());
            }
            return ThisKind.NotThis;
        }
        return ThisKind.NotThis;
    }

    public Quaternion<Boolean, Boolean, String, String> dumpMethodParts(MemberFunctionType memberFunctionType, Boolean bl) {
        String string = this.getReturnType(memberFunctionType.getReturnType(), memberFunctionType.getAttributes(), bl);
        String string2 = this.dumpIndex(memberFunctionType.getArgumentList());
        boolean bl2 = memberFunctionType.getThisPointerType() == null;
        boolean bl3 = false;
        if (!bl2) {
            TypeIndex typeIndex = memberFunctionType.getThisPointerType();
            ThisKind thisKind = this.checkThisType(typeIndex, memberFunctionType.getClassType());
            if (thisKind == ThisKind.NotThis) {
                String string3 = this.dumpIndex(typeIndex);
                if (string2.isEmpty()) {
                    string2 = string3;
                } else {
                    string2 = String.format("%s, %s", string3, string2);
                    bl3 = false;
                }
            } else {
                bl3 = thisKind == ThisKind.ConstThis;
            }
        }
        return new Quaternion<Boolean, Boolean, String, String>(bl2, bl3, string, string2);
    }

    public String dumpAttributes(List<PtrAttributes> list) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = list.size() - 1; i >= 0; --i) {
            PtrAttributes ptrAttributes = list.get(i);
            if (ptrAttributes.isPointeeConst) {
                if (this.flags.intersects(4)) {
                    stringBuilder.append(" const ");
                } else {
                    stringBuilder.append(" const");
                }
            }
            if (ptrAttributes.mode == PointerMode.Pointer) {
                stringBuilder.append("*");
            } else if (ptrAttributes.mode == PointerMode.LValueReference) {
                stringBuilder.append("&");
            } else if (ptrAttributes.mode == PointerMode.Member) {
                stringBuilder.append("::*");
            } else if (ptrAttributes.mode == PointerMode.RValueReference) {
                stringBuilder.append("&&");
            }
            if (!ptrAttributes.isPointerConst) continue;
            if (this.flags.intersects(4)) {
                stringBuilder.append(" const ");
                continue;
            }
            stringBuilder.append(" const");
        }
        return stringBuilder.toString().trim();
    }

    public String dumpMemberPtr(MemberFunctionType memberFunctionType, List<PtrAttributes> list) {
        String string = this.dumpIndex(memberFunctionType.getClassType());
        Quaternion<Boolean, Boolean, String, String> quaternion = this.dumpMethodParts(memberFunctionType, false);
        String string2 = (String)quaternion.v3;
        String string3 = (String)quaternion.v4;
        String string4 = this.dumpAttributes(list);
        return String.format("%s(%s%s)(%s)", this.fixReturn(string2), string, string4, string3);
    }

    public String dumpProcPtr(ProcedureType procedureType, List<PtrAttributes> list) {
        Pair<String, String> pair = this.dumpProcedureParts(procedureType, false);
        String string = pair.getKey();
        String string2 = pair.getValue();
        String string3 = this.dumpAttributes(list);
        return String.format("%s(%s)(%s)", this.fixReturn(string), string3, string2);
    }

    public String dumpOtherPtr(TypeData typeData, List<PtrAttributes> list) {
        String string = this.dumpData(typeData);
        if (StringUtils.isEmpty(string) || string.length() == 0) {
            return "";
        }
        String string2 = this.dumpAttributes(list);
        char c = string.charAt(string.length() - 1);
        String string3 = " ";
        if (!string2.startsWith("c") && (c == '*' || c == '&' || this.flags.intersects(4))) {
            string3 = "";
        }
        return String.format("%s%s%s", string, string3, string2);
    }

    public String dumpPtrHelper(List<PtrAttributes> list, TypeData typeData) {
        if (typeData.containsKey((Object)TypeEnum.MemberFunction)) {
            MemberFunctionType memberFunctionType = (MemberFunctionType)typeData.get((Object)TypeEnum.MemberFunction);
            return this.dumpMemberPtr(memberFunctionType, list);
        }
        if (typeData.containsKey((Object)TypeEnum.Procedure)) {
            ProcedureType procedureType = (ProcedureType)typeData.get((Object)TypeEnum.Procedure);
            return this.dumpProcPtr(procedureType, list);
        }
        return this.dumpOtherPtr(typeData, list);
    }

    public String dumpPtr(PointerType typeInterface, boolean bl) {
        TypeData typeData;
        ArrayList<PtrAttributes> arrayList;
        block2: {
            TypeData typeData2;
            PtrAttributes ptrAttributes = new PtrAttributes(typeInterface.getAttributes().isConst() || bl, false, typeInterface.getAttributes().pointerMode());
            arrayList = new ArrayList<PtrAttributes>();
            arrayList.add(ptrAttributes);
            while (true) {
                TypeInterface typeInterface2;
                if ((typeData = this.find(typeInterface.getUnderlyingType())).containsKey((Object)TypeEnum.Pointer)) {
                    typeInterface2 = (PointerType)typeData.get((Object)TypeEnum.Pointer);
                    arrayList.add(new PtrAttributes(((PointerType)typeInterface2).getAttributes().isConst(), false, ((PointerType)typeInterface2).getAttributes().pointerMode()));
                    typeInterface = typeInterface2;
                    continue;
                }
                if (!typeData.containsKey((Object)TypeEnum.Modifier)) break block2;
                typeInterface2 = (ModifierType)typeData.get((Object)TypeEnum.Modifier);
                ((PtrAttributes)arrayList.get((int)(arrayList.size() - 1))).isPointeeConst = ((ModifierType)typeInterface2).isConstant();
                typeData2 = this.find(((ModifierType)typeInterface2).getUnderlyingType());
                if (!typeData2.containsKey((Object)TypeEnum.Pointer)) break;
                PointerType pointerType = (PointerType)typeData2.get((Object)TypeEnum.Pointer);
                arrayList.add(new PtrAttributes(pointerType.getAttributes().isConst(), false, pointerType.getAttributes().pointerMode()));
                typeInterface = pointerType;
            }
            return this.dumpPtrHelper(arrayList, typeData2);
        }
        return this.dumpPtrHelper(arrayList, typeData);
    }

    public Pair<List<Long>, TypeData> getArrayInfo(ArrayType arrayType) {
        TypeData typeData;
        ArrayType arrayType2 = arrayType;
        ArrayList<Long> arrayList = new ArrayList<Long>();
        arrayList.add(arrayType2.getDimensions().get(0));
        while ((typeData = this.find(arrayType2.getElementType())).containsKey((Object)TypeEnum.Array)) {
            ArrayType arrayType3 = (ArrayType)typeData.get((Object)TypeEnum.Array);
            arrayList.add(arrayType3.getDimensions().get(0));
            arrayType2 = arrayType3;
        }
        return new Pair<List<Long>, TypeData>(arrayList, typeData);
    }

    public String dumpArray(ArrayType arrayType) {
        Pair<List<Long>, TypeData> pair = this.getArrayInfo(arrayType);
        List<Long> list = pair.getKey();
        TypeData typeData = pair.getValue();
        long l2 = this.getDataSize(typeData);
        Collections.reverse(list);
        long[] lArray = new long[]{l2};
        List list2 = list.stream().map(l -> {
            String string = "[]";
            if (lArray[0] != 0L) {
                string = String.format("[%d]", l / lArray[0]);
            }
            lArray[0] = l;
            return string;
        }).collect(Collectors.toList());
        Collections.reverse(list2);
        String string = this.dumpData(typeData);
        return String.format("%s%s", string, StringUtils.join(list2, ""));
    }

    public String dumpModifier(ModifierType modifierType) {
        TypeData typeData = this.find(modifierType.getUnderlyingType());
        if (typeData.containsKey((Object)TypeEnum.Pointer)) {
            PointerType pointerType = (PointerType)typeData.get((Object)TypeEnum.Pointer);
            return this.dumpPtr(pointerType, modifierType.isConstant());
        }
        if (typeData.containsKey((Object)TypeEnum.Primitive)) {
            PrimitiveType primitiveType = (PrimitiveType)typeData.get((Object)TypeEnum.Primitive);
            return this.dumpPrimitive(primitiveType, modifierType.isConstant());
        }
        String string = this.dumpData(typeData);
        if (modifierType.isConstant()) {
            return String.format("const %s", string);
        }
        return string;
    }

    public String dumpClass(ClassType classType) {
        if (this.flags.intersects(8)) {
            return classType.getName();
        }
        String string = classType.getName();
        ClassKind classKind = classType.getKind();
        if (classKind == ClassKind.Class) {
            string = "class";
        } else if (classKind == ClassKind.Interface) {
            string = "interface";
        } else if (classKind == ClassKind.Struct) {
            string = "struct";
        } else {
            Log.error("invalid class kind %s", classKind.toString());
        }
        return String.format("%s %s", string, classType.getName());
    }

    public String dumpArgList(ArgumentList argumentList) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = this.flags.intersects(2) ? ", " : ",";
        List list = argumentList.getArguments().stream().map(this::dumpIndex).collect(Collectors.toList());
        return StringUtils.join(list, string);
    }

    public static String getPrimitiveString(PrimitiveKind primitiveKind) {
        switch (primitiveKind) {
            case NoType: {
                return "<NoType>";
            }
            case Void: {
                return "void";
            }
            case Char: {
                return "signed char";
            }
            case UChar: {
                return "unsigned char";
            }
            case RChar: {
                return "char";
            }
            case WChar: {
                return "wchar_t";
            }
            case RChar16: {
                return "char16_t";
            }
            case RChar32: {
                return "char32_t";
            }
            case I8: {
                return "int8_t";
            }
            case U8: {
                return "uint8_t";
            }
            case Short: {
                return "short";
            }
            case UShort: {
                return "unsigned short";
            }
            case I16: {
                return "int16_t";
            }
            case U16: {
                return "uint16_t";
            }
            case Long: {
                return "long";
            }
            case ULong: {
                return "unsigned long";
            }
            case I32: {
                return "int";
            }
            case U32: {
                return "unsigned int";
            }
            case Quad: {
                return "long long";
            }
            case UQuad: {
                return "unsigned long long";
            }
            case I64: {
                return "int64_t";
            }
            case U64: {
                return "uint64_t";
            }
            case I128: 
            case Octa: {
                return "int128_t";
            }
            case U128: 
            case UOcta: {
                return "uint128_t";
            }
            case F16: {
                return "float16_t";
            }
            case F32: {
                return "float";
            }
            case F32PP: {
                return "float";
            }
            case F48: {
                return "float48_t";
            }
            case F64: {
                return "double";
            }
            case F80: {
                return "long double";
            }
            case F128: {
                return "long double";
            }
            case Complex32: {
                return "complex<float>";
            }
            case Complex64: {
                return "complex<double>";
            }
            case Complex80: {
                return "complex<long double>";
            }
            case Complex128: {
                return "complex<long double>";
            }
            case Bool8: {
                return "bool";
            }
            case Bool16: {
                return "bool16_t";
            }
            case Bool32: {
                return "bool32_t";
            }
            case Bool64: {
                return "bool64_t";
            }
            case HRESULT: {
                return "HRESULT";
            }
        }
        return null;
    }

    public String dumpPrimitive(PrimitiveType primitiveType, boolean bl) {
        String string = TypeDumper.getPrimitiveString(primitiveType.getKind());
        if (string == null) {
            Log.error("Unsupported primitive type %s", primitiveType.getKind().toString());
            System.exit(0);
        }
        if (primitiveType.getIndirection() != null) {
            if (this.flags.intersects(4)) {
                if (bl) {
                    return String.format("%s const *", string);
                }
                return String.format("%s *", string);
            }
            if (bl) {
                return String.format("%s const*", string);
            }
            return String.format("%s*", string);
        }
        if (bl) {
            return String.format("const %s", string);
        }
        return string;
    }

    public String dumpIndex(TypeIndex typeIndex) {
        TypeData typeData = this.find(typeIndex);
        return this.dumpData(typeData);
    }

    public String dumpNamed(String string, String string2) {
        if (this.flags.intersects(8)) {
            return string2;
        }
        return String.format("%s %s", string, string2);
    }

    public String dumpData(TypeData typeData) {
        if (typeData.containsKey((Object)TypeEnum.Primitive)) {
            PrimitiveType primitiveType = (PrimitiveType)typeData.get((Object)TypeEnum.Primitive);
            return this.dumpPrimitive(primitiveType, false);
        }
        if (typeData.containsKey((Object)TypeEnum.Class)) {
            ClassType classType = (ClassType)typeData.get((Object)TypeEnum.Class);
            return this.dumpClass(classType);
        }
        if (typeData.containsKey((Object)TypeEnum.MemberFunction)) {
            MemberFunctionType memberFunctionType = (MemberFunctionType)typeData.get((Object)TypeEnum.MemberFunction);
            Quaternion<Boolean, Boolean, String, String> quaternion = this.dumpMethodParts(memberFunctionType, this.flags.intersects(1));
            String string = (String)quaternion.v3;
            String string2 = (String)quaternion.v4;
            return String.format("%s()(%s)", this.fixReturn(string), string2);
        }
        if (typeData.containsKey((Object)TypeEnum.Procedure)) {
            ProcedureType procedureType = (ProcedureType)typeData.get((Object)TypeEnum.Procedure);
            Pair<String, String> pair = this.dumpProcedureParts(procedureType, this.flags.intersects(1));
            return String.format("%s()(%s)", this.fixReturn(pair.getKey()), pair.getValue());
        }
        if (typeData.containsKey((Object)TypeEnum.ArgumentList)) {
            ArgumentList argumentList = (ArgumentList)typeData.get((Object)TypeEnum.ArgumentList);
            return this.dumpArgList(argumentList);
        }
        if (typeData.containsKey((Object)TypeEnum.Pointer)) {
            PointerType pointerType = (PointerType)typeData.get((Object)TypeEnum.Pointer);
            return this.dumpPtr(pointerType, false);
        }
        if (typeData.containsKey((Object)TypeEnum.Array)) {
            ArrayType arrayType = (ArrayType)typeData.get((Object)TypeEnum.Array);
            return this.dumpArray(arrayType);
        }
        if (typeData.containsKey((Object)TypeEnum.Union)) {
            UnionType unionType = (UnionType)typeData.get((Object)TypeEnum.Union);
            return this.dumpNamed("union", unionType.getName());
        }
        if (typeData.containsKey((Object)TypeEnum.Enumeration)) {
            EnumerationType enumerationType = (EnumerationType)typeData.get((Object)TypeEnum.Enumeration);
            return this.dumpNamed("enum", enumerationType.getName());
        }
        if (typeData.containsKey((Object)TypeEnum.Enumerate)) {
            EnumerateType enumerateType = (EnumerateType)typeData.get((Object)TypeEnum.Enumerate);
            return this.dumpNamed("enum class", enumerateType.getName());
        }
        if (typeData.containsKey((Object)TypeEnum.Modifier)) {
            ModifierType modifierType = (ModifierType)typeData.get((Object)TypeEnum.Modifier);
            return this.dumpModifier(modifierType);
        }
        return String.format("unhandled type /* %s */", typeData);
    }
}

